/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.event;

import com.mcmoddev.golems.EGConfig;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.block.GolemHeadBlock;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_models.GolemRenderSettings;
import com.mcmoddev.golems.golem_stats.GolemContainer;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehaviors;
import com.mcmoddev.golems.network.SGolemContainerPacket;
import com.mcmoddev.golems.network.SGolemModelPacket;
import com.mcmoddev.golems.network.SummonGolemCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.sensor.GolemLastSeenSensor;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class EGForgeEvents {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ExtraGolems.GOLEM_CONTAINERS);
        event.addListener(ExtraGolems.GOLEM_RENDER_SETTINGS);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            ExtraGolems.GOLEM_CONTAINERS.getEntries().forEach(e -> ((Optional)e.getValue()).ifPresent(c -> ExtraGolems.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SGolemContainerPacket((ResourceLocation)e.getKey(), (GolemContainer)c))));
            ExtraGolems.GOLEM_RENDER_SETTINGS.getEntries().forEach(e -> ((Optional)e.getValue()).ifPresent(c -> ExtraGolems.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SGolemModelPacket((ResourceLocation)e.getKey(), (GolemRenderSettings)c))));
        }
    }

    @SubscribeEvent
    public static void onAddCommands(RegisterCommandsEvent event) {
        SummonGolemCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlacePumpkin(BlockEvent.EntityPlaceEvent event) {
        if (!event.isCanceled() && EGConfig.pumpkinBuildsGolems() && event.getPlacedBlock().func_177230_c() == Blocks.field_196625_cS && event.getWorld() instanceof World) {
            GolemHeadBlock.trySpawnGolem(event.getEntity(), (World)event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public static void onTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof MobEntity && event.getTarget() instanceof GolemBase) {
            MobEntity mob = (MobEntity)event.getEntityLiving();
            GolemBase target = (GolemBase)event.getTarget();
            if (target.getContainer().hasBehavior(GolemBehaviors.USE_FUEL) && !target.hasFuel()) {
                mob.func_70624_b(null);
                mob.func_70604_c(null);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        VillagerEntity villager;
        VillagerData villagerdata;
        if (EGConfig.villagerSummonChance() > 0 && event.getEntityLiving() instanceof VillagerEntity && event.getEntityLiving().func_70613_aW() && !event.getEntityLiving().func_70608_bn() && event.getEntityLiving().field_70173_aa % 50 == 0 && (villagerdata = (villager = (VillagerEntity)event.getEntityLiving()).func_213700_eh()) != null && !villager.func_70631_g_() && villagerdata.func_221130_b() != VillagerProfession.field_221162_l) {
            GolemBase golem;
            long time = villager.func_130014_f_().func_82737_E();
            int minNumVillagers = 3;
            AxisAlignedBB aabb = villager.func_174813_aQ().func_186662_g(10.0);
            List nearbyVillagers = villager.func_130014_f_().func_175647_a(VillagerEntity.class, aabb, v -> v.func_223350_a(time) && v.func_70089_S());
            List nearbyGolems = villager.func_130014_f_().func_217357_a(IronGolemEntity.class, aabb.func_186662_g(10.0));
            if (nearbyVillagers.size() >= 3 && nearbyGolems.isEmpty() && villager.func_70681_au().nextInt(100) < EGConfig.villagerSummonChance() && (golem = EGForgeEvents.summonGolem(villager)) != null) {
                ExtraGolems.LOGGER.info("Villager summoned a golem! " + golem.toString());
                nearbyVillagers.forEach(GolemLastSeenSensor::func_242312_a);
            }
        }
    }

    @Nullable
    private static GolemBase summonGolem(@Nonnull VillagerEntity villager) {
        ServerWorld world = (ServerWorld)villager.func_130014_f_();
        BlockPos blockpos = villager.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos2;
            ResourceLocation typeName;
            Optional<GolemContainer> type;
            double d0 = world.func_201674_k().nextInt(16) - 8;
            double d1 = world.func_201674_k().nextInt(16) - 8;
            double d2 = 6.0;
            for (int j = 0; j >= -12; --j) {
                BlockPos blockpos1 = blockpos.func_177963_a(d0, d2 + (double)j, d1);
                if (!world.func_175623_d(blockpos1) && !world.func_180495_p(blockpos1).func_185904_a().func_76224_d() || !world.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76218_k()) continue;
                d2 += (double)j;
                break;
            }
            if (!(type = ExtraGolems.GOLEM_CONTAINERS.get(typeName = EGForgeEvents.getGolemToSpawn((World)world, blockpos2 = blockpos.func_177963_a(d0, d2, d1)))).isPresent()) continue;
            GolemBase golem = GolemBase.create((World)world, typeName);
            if (golem.getTextureCount() > 0) {
                golem.randomizeTexture((World)world, blockpos2);
            }
            if (golem.func_213380_a((IWorld)world, SpawnReason.MOB_SUMMONED) && golem.func_205019_a((IWorldReader)world)) {
                golem.func_70107_b(blockpos2.func_177958_n(), blockpos2.func_177956_o(), blockpos2.func_177952_p());
                world.func_217376_c((Entity)golem);
                golem.func_213386_a((IServerWorld)world, world.func_175649_E(blockpos2), SpawnReason.MOB_SUMMONED, null, null);
                return golem;
            }
            golem.func_70106_y();
        }
        return null;
    }

    @Nullable
    private static ResourceLocation getGolemToSpawn(World world, BlockPos pos) {
        List<ResourceLocation> options = EGConfig.getVillagerGolems();
        ResourceLocation choice = options.isEmpty() ? null : options.get(world.func_201674_k().nextInt(options.size()));
        return choice;
    }
}

