/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.event;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.event.AoeFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public final class GolemModifyBlocksEvent
extends Event {
    private List<BlockPos> affectedBlocks;
    private AoeFunction function;
    public final GolemBase entity;
    public final BlockPos center;
    public final int range;
    public final boolean sphere;
    public int updateFlag;

    public GolemModifyBlocksEvent(GolemBase golem, BlockPos center, int radius, boolean sphere, AoeFunction function) {
        this.setResult(Event.Result.ALLOW);
        this.entity = golem;
        this.center = center;
        this.range = Math.min(radius, 16);
        this.sphere = sphere;
        this.updateFlag = 3;
        this.setFunction(function, true);
    }

    public void initAffectedBlockList(int range) {
        this.affectedBlocks = new ArrayList<BlockPos>(range * range * 2 * 4);
        int maxDis = range * range;
        int dY = this.sphere ? range : 1;
        for (int i = -range; i <= range; ++i) {
            for (int j = -dY; j <= dY; ++j) {
                for (int k = -range; k <= range; ++k) {
                    BlockState state;
                    BlockState replace;
                    BlockPos currentPos = this.center.func_177982_a(i, j, k);
                    if (!(this.center.func_177951_i((Vector3i)currentPos) <= (double)maxDis) || (replace = this.function.map((LivingEntity)this.entity, currentPos, state = this.entity.field_70170_p.func_180495_p(currentPos))) == state) continue;
                    this.affectedBlocks.add(currentPos);
                }
            }
        }
    }

    public AoeFunction getFunction() {
        return this.function;
    }

    public void setFunction(AoeFunction toSet, boolean refresh) {
        this.function = toSet;
        if (refresh) {
            this.initAffectedBlockList(this.range);
        }
    }

    public List<BlockPos> getAffectedPositions() {
        return this.affectedBlocks;
    }

    public boolean add(BlockPos pos) {
        return this.affectedBlocks.add(pos);
    }

    public boolean remove(BlockPos toRemove) {
        return this.affectedBlocks.remove(toRemove);
    }
}

