/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_stats.AttributeSettings;
import com.mcmoddev.golems.golem_stats.MultitextureSettings;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehaviors;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraftforge.registries.ForgeRegistries;

public final class GolemContainer {
    public static final GolemContainer EMPTY = new GolemContainer(AttributeSettings.EMPTY, SwimMode.SINK, 0, 0, true, SoundEvents.field_187902_gb, Optional.empty(), (List<ResourcePair>)ImmutableList.of((Object)new ResourcePair(Blocks.field_150350_a.getRegistryName(), false)), (Map<ResourcePair, Double>)ImmutableMap.of(), Optional.empty(), (List<CompoundNBT>)ImmutableList.of());
    public static final Codec<GolemContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AttributeSettings.CODEC.fieldOf("attributes").forGetter(GolemContainer::getAttributes), (App)SwimMode.CODEC.optionalFieldOf("swim_ability", (Object)SwimMode.SINK).forGetter(GolemContainer::getSwimAbility), (App)Codec.INT.optionalFieldOf("glow", (Object)0).forGetter(GolemContainer::getMaxLightLevel), (App)Codec.INT.optionalFieldOf("power", (Object)0).forGetter(GolemContainer::getMaxPowerLevel), (App)Codec.BOOL.optionalFieldOf("hidden", (Object)false).forGetter(GolemContainer::isHidden), (App)SoundEvent.field_232678_a_.optionalFieldOf("sound", (Object)SoundEvents.field_187902_gb).forGetter(GolemContainer::getSound), (App)ParticleEffectAmbience.field_235041_a_.optionalFieldOf("particle").forGetter(GolemContainer::getParticle), (App)Codec.either(ResourcePair.CODEC, (Codec)ResourcePair.CODEC.listOf()).xmap(either -> (List)either.map(ImmutableList::of, Function.identity()), list -> list.size() == 1 ? Either.left(list.get(0)) : Either.right((Object)list)).optionalFieldOf("blocks", (Object)Lists.newArrayList()).forGetter(GolemContainer::getBlocksRaw), (App)Codec.unboundedMap(ResourcePair.CODEC, (Codec)Codec.DOUBLE).optionalFieldOf("heal_items", (Object)Maps.newHashMap()).forGetter(GolemContainer::getHealItemsRaw), (App)MultitextureSettings.CODEC.optionalFieldOf("multitexture").forGetter(GolemContainer::getMultitexture), (App)CompoundNBT.field_240597_a_.listOf().optionalFieldOf("behavior", (Object)Lists.newArrayList((Object[])new CompoundNBT[]{new CompoundNBT()})).forGetter(GolemContainer::getBehaviorsRaw)).apply((Applicative)instance, GolemContainer::new));
    private final AttributeSettings attributes;
    private final SwimMode swimAbility;
    private final int glow;
    private final int power;
    private final boolean hidden;
    private final SoundEvent sound;
    private final Optional<ParticleEffectAmbience> particle;
    private final List<ResourcePair> blocksRaw;
    private final ImmutableSet<ResourceLocation> blocks;
    private final ImmutableSet<ResourceLocation> blockTags;
    private final Map<ResourcePair, Double> healItemsRaw;
    private final ImmutableMap<ResourceLocation, Double> healItems;
    private final ImmutableMap<ResourceLocation, Double> healItemTags;
    private final List<CompoundNBT> behaviorsRaw;
    private final ImmutableMap<ResourceLocation, ImmutableList<GolemBehavior>> behaviors;
    private final Optional<MultitextureSettings> multitexture;
    private final ImmutableList<ITextComponent> descriptions;

    private GolemContainer(AttributeSettings attributes, SwimMode swimAbility, int glow, int power, boolean hidden, SoundEvent sound, Optional<ParticleEffectAmbience> particle, List<ResourcePair> blocksRaw, Map<ResourcePair, Double> healItemsRaw, Optional<MultitextureSettings> multitexture, List<CompoundNBT> goalsRaw) {
        this.attributes = attributes;
        this.swimAbility = swimAbility;
        this.glow = glow;
        this.power = power;
        this.hidden = hidden;
        this.sound = sound;
        this.particle = particle;
        this.blocksRaw = blocksRaw;
        this.healItemsRaw = healItemsRaw;
        this.multitexture = multitexture;
        this.behaviorsRaw = goalsRaw;
        ImmutableSet.Builder bblocks = ImmutableSet.builder();
        ImmutableSet.Builder bblockTags = ImmutableSet.builder();
        if (this.multitexture.isPresent()) {
            this.multitexture.get().getBlockMap().keySet().forEach(pair -> {
                if (pair.flag()) {
                    bblockTags.add((Object)pair.resource());
                } else {
                    bblocks.add((Object)pair.resource());
                }
            });
        } else {
            this.blocksRaw.forEach(pair -> {
                if (pair.flag()) {
                    bblockTags.add((Object)pair.resource());
                } else {
                    bblocks.add((Object)pair.resource());
                }
            });
        }
        this.blocks = bblocks.build();
        this.blockTags = bblockTags.build();
        ImmutableMap.Builder bhealItems = ImmutableMap.builder();
        ImmutableMap.Builder bhealItemTags = ImmutableMap.builder();
        this.healItemsRaw.forEach((s, d) -> {
            if (s.flag()) {
                bhealItemTags.put((Object)s.resource(), d);
            } else {
                bhealItems.put((Object)s.resource(), d);
            }
        });
        this.healItems = bhealItems.build();
        this.healItemTags = bhealItemTags.build();
        HashMap<ResourceLocation, List> bbehaviors = new HashMap<ResourceLocation, List>();
        for (CompoundNBT goalTag : goalsRaw) {
            if (!goalTag.func_150297_b("type", 8)) continue;
            ResourceLocation goalId = new ResourceLocation(goalTag.func_74779_i("type"));
            Optional<? extends GolemBehavior> behavior = GolemBehaviors.create(goalId, goalTag);
            if (behavior.isPresent()) {
                bbehaviors.putIfAbsent(goalId, Lists.newArrayList());
                ((List)bbehaviors.get(goalId)).add(behavior.get());
                continue;
            }
            ExtraGolems.LOGGER.warn("GolemContainer: behavior '" + goalId + "' does not exist!");
        }
        ImmutableMap.Builder bbehaviors2 = ImmutableMap.builder();
        bbehaviors.forEach((id, list) -> bbehaviors2.put(id, (Object)ImmutableList.copyOf((Collection)list)));
        this.behaviors = bbehaviors2.build();
        this.descriptions = ImmutableList.copyOf(this.createDescriptions());
    }

    public AttributeSettings getAttributes() {
        return this.attributes;
    }

    public SwimMode getSwimAbility() {
        return this.swimAbility;
    }

    public boolean canSwim() {
        return this.swimAbility == SwimMode.FLOAT;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public Optional<ParticleEffectAmbience> getParticle() {
        return this.particle;
    }

    private List<ResourcePair> getBlocksRaw() {
        return this.blocksRaw;
    }

    public ImmutableSet<ResourceLocation> getBlocks() {
        return this.blocks;
    }

    public ImmutableSet<ResourceLocation> getBlockTags() {
        return this.blockTags;
    }

    private Map<ResourcePair, Double> getHealItemsRaw() {
        return this.healItemsRaw;
    }

    public ImmutableMap<ResourceLocation, Double> getHealItems() {
        return this.healItems;
    }

    public ImmutableMap<ResourceLocation, Double> getHealItemTags() {
        return this.healItemTags;
    }

    private List<CompoundNBT> getBehaviorsRaw() {
        return this.behaviorsRaw;
    }

    public ImmutableMap<ResourceLocation, ImmutableList<GolemBehavior>> getBehaviors() {
        return this.behaviors;
    }

    public Optional<MultitextureSettings> getMultitexture() {
        return this.multitexture;
    }

    public int getMaxLightLevel() {
        return this.glow;
    }

    public int getMaxPowerLevel() {
        return this.power;
    }

    public ImmutableList<ITextComponent> getDescriptions() {
        return this.descriptions;
    }

    public ResourceLocation getLootTable(GolemBase entity) {
        ResourceLocation lootTable = entity.getMaterial();
        if (this.multitexture.isPresent()) {
            lootTable = this.multitexture.get().getLootTable(entity);
        }
        return new ResourceLocation(lootTable.func_110624_b(), "entities/golem/" + lootTable.func_110623_a());
    }

    public boolean hasBlocks() {
        if (this.blocks.size() > 0) {
            return true;
        }
        for (ResourceLocation tagId : this.blockTags) {
            if (BlockTags.func_199896_a().func_199910_a(tagId).func_230236_b_().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public Set<Block> getAllBlocks() {
        return GolemContainer.getAllBlocks(this.blocks, this.blockTags);
    }

    public boolean matches(Block body, Block legs, Block arm1, Block arm2) {
        Set<Block> blocks = this.getAllBlocks();
        return blocks.contains(body) && blocks.contains(legs) && blocks.contains(arm1) && blocks.contains(arm2);
    }

    public double getHealAmount(Item item) {
        ResourceLocation id = item.getRegistryName();
        if (this.healItems.containsKey((Object)id)) {
            return (Double)this.healItems.get((Object)id);
        }
        for (ResourceLocation tag : item.getTags()) {
            if (!this.healItemTags.containsKey((Object)tag)) continue;
            return (Double)this.healItemTags.get((Object)tag);
        }
        return 0.0;
    }

    public boolean hasBehavior(ResourceLocation name) {
        return !((ImmutableList)this.getBehaviors().getOrDefault((Object)name, (Object)ImmutableList.of())).isEmpty();
    }

    public <T extends GolemBehavior> List<T> getBehaviors(ResourceLocation name) {
        List behaviorList = (List)this.behaviors.get((Object)name);
        if (!behaviorList.isEmpty() && ((GolemBehavior)behaviorList.get(0)).getClass().isAssignableFrom(GolemBehaviors.CLASS_MAP.get(name))) {
            return behaviorList;
        }
        return ImmutableList.of();
    }

    public Supplier<AttributeModifierMap.MutableAttribute> getAttributeSupplier() {
        return () -> GolemBase.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, this.attributes.getHealth()).func_233815_a_(Attributes.field_233821_d_, this.attributes.getSpeed()).func_233815_a_(Attributes.field_233820_c_, this.attributes.getKnockbackResist()).func_233815_a_(Attributes.field_233824_g_, this.attributes.getAttackKnockback()).func_233815_a_(Attributes.field_233826_i_, this.attributes.getArmor()).func_233815_a_(Attributes.field_233819_b_, 8.0).func_233815_a_(Attributes.field_233823_f_, this.attributes.getAttack());
    }

    public String toString() {
        StringBuilder b = new StringBuilder("GolemContainer: ");
        b.append("attributes[").append(this.attributes).append("] ");
        b.append("swim_ability[").append((Object)this.swimAbility).append("] ");
        b.append("hidden[").append(this.hidden).append("] ");
        b.append("sound[").append(this.sound.func_187503_a()).append("] ");
        b.append("particle[").append(this.particle).append("] ");
        b.append("blocks[").append(this.blocksRaw).append("] ");
        b.append("healItems[").append(this.healItemsRaw).append("] ");
        b.append("behavior[").append(this.behaviors).append("] ");
        b.append("multitexture[").append(this.multitexture).append("] ");
        return b.toString();
    }

    public static Set<Block> getAllBlocks(Collection<ResourceLocation> blocks, Collection<ResourceLocation> blockTags) {
        HashSet<Block> all = new HashSet<Block>();
        for (ResourceLocation blockId : blocks) {
            Block tmpBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
            if (tmpBlock == null) continue;
            all.add(tmpBlock);
        }
        for (ResourceLocation tagId : blockTags) {
            all.addAll(BlockTags.func_199896_a().func_199910_a(tagId).func_230236_b_());
        }
        return all;
    }

    private List<ITextComponent> createDescriptions() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (this.attributes.hasFireImmunity()) {
            list.add((ITextComponent)new TranslationTextComponent("enchantment.minecraft.fire_protection").func_240699_a_(TextFormatting.GOLD));
        }
        if (this.attributes.hasExplosionImmunity()) {
            list.add((ITextComponent)new TranslationTextComponent("enchantment.minecraft.blast_protection").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
        }
        if (this.glow > 0) {
            list.add((ITextComponent)new TranslationTextComponent("entitytip.provides_light").func_240699_a_(TextFormatting.RED));
        }
        if (this.power > 0) {
            list.add((ITextComponent)new TranslationTextComponent("entitytip.provides_power").func_240699_a_(TextFormatting.RED));
        }
        if (this.attributes.getAttackKnockback() > 0.39) {
            list.add((ITextComponent)new TranslationTextComponent("entitytip.has_knockback").func_240699_a_(TextFormatting.DARK_RED));
        }
        if (this.multitexture.isPresent() && this.multitexture.get().canCycle()) {
            list.add((ITextComponent)new TranslationTextComponent("entitytip.click_change_texture").func_240699_a_(TextFormatting.BLUE));
        }
        if (this.swimAbility == SwimMode.SWIM) {
            list.add((ITextComponent)new TranslationTextComponent("entitytip.advanced_swim").func_240699_a_(TextFormatting.DARK_AQUA));
        }
        this.behaviors.values().forEach(l -> l.forEach(b -> b.onAddDescriptions(list)));
        return list;
    }

    public static enum SwimMode implements IStringSerializable
    {
        SINK("sink"),
        FLOAT("float"),
        SWIM("swim");

        private static final Map<String, SwimMode> valueMap;
        public static final Codec<SwimMode> CODEC;
        private final String name;

        private SwimMode(String nameIn) {
            this.name = nameIn;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static SwimMode getByName(String nameIn) {
            return valueMap.getOrDefault(nameIn, SINK);
        }

        static {
            valueMap = new HashMap<String, SwimMode>();
            for (SwimMode t : SwimMode.values()) {
                valueMap.put(t.func_176610_l(), t);
            }
            CODEC = Codec.STRING.comapFlatMap(s -> DataResult.success((Object)((Object)SwimMode.getByName(s))), SwimMode::func_176610_l).stable();
        }
    }
}

