/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.ChangeTextureGoal;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import com.mcmoddev.golems.golem_stats.behavior.parameter.ChangeIdBehaviorParameter;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

@Immutable
public class ChangeTextureBehavior
extends GolemBehavior {
    private final Optional<ChangeIdBehaviorParameter> tickTextures;
    private final Optional<ChangeIdBehaviorParameter> wetTextures;
    private final Optional<ChangeIdBehaviorParameter> dryTextures;
    private final Optional<ChangeIdBehaviorParameter> fueledTextures;
    private final Optional<ChangeIdBehaviorParameter> emptyTextures;
    private final Optional<ChangeIdBehaviorParameter> itemTextures;

    public ChangeTextureBehavior(CompoundNBT tag) {
        super(tag);
        this.tickTextures = tag.func_74764_b("tick") ? Optional.of(new ChangeIdBehaviorParameter(tag.func_74775_l("tick"), "textures")) : Optional.empty();
        this.wetTextures = tag.func_74764_b("wet") ? Optional.of(new ChangeIdBehaviorParameter(tag.func_74775_l("wet"), "textures")) : Optional.empty();
        this.dryTextures = tag.func_74764_b("dry") ? Optional.of(new ChangeIdBehaviorParameter(tag.func_74775_l("dry"), "textures")) : Optional.empty();
        this.fueledTextures = tag.func_74764_b("fuel") ? Optional.of(new ChangeIdBehaviorParameter(tag.func_74775_l("fuel"), "textures")) : Optional.empty();
        this.emptyTextures = tag.func_74764_b("fuel_empty") ? Optional.of(new ChangeIdBehaviorParameter(tag.func_74775_l("fuel_empty"), "textures")) : Optional.empty();
        this.itemTextures = tag.func_74764_b("use_item") ? Optional.of(new ChangeIdBehaviorParameter(tag.func_74775_l("use_item"), "items", "texture")) : Optional.empty();
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        if (entity.getContainer().getMultitexture().isPresent()) {
            entity.field_70714_bg.func_75776_a(1, new ChangeTextureGoal<GolemBase>(entity, this.tickTextures, this.wetTextures, this.dryTextures, this.fueledTextures, this.emptyTextures));
        }
    }

    @Override
    public void onMobInteract(GolemBase entity, PlayerEntity player, Hand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (this.itemTextures.isPresent() && !item.func_190926_b()) {
            if (ChangeTextureBehavior.processKey(entity, player, item, this.itemTextures.get(), item.func_77973_b().getRegistryName().toString())) {
                return;
            }
            for (ResourceLocation r : item.func_77973_b().getTags()) {
                System.out.println("process #" + r.toString());
                if (!ChangeTextureBehavior.processKey(entity, player, item, this.itemTextures.get(), "#".concat(r.toString()))) continue;
                System.out.println("Success");
                return;
            }
        }
    }

    private static boolean processKey(GolemBase entity, PlayerEntity player, ItemStack held, ChangeIdBehaviorParameter itemTextures, String key) {
        String currentId = String.valueOf(entity.getTextureId());
        String textureId = itemTextures.getId(key, currentId);
        double chance = itemTextures.getChance(key);
        boolean consume = itemTextures.consume(key);
        if ((double)entity.field_70170_p.func_201674_k().nextFloat() < chance && textureId != null && !textureId.isEmpty() && !currentId.equals(textureId)) {
            entity.setTextureId(Byte.parseByte(textureId));
            if (consume) {
                ItemStack cont = held.getContainerItem();
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                    if (!cont.func_190926_b()) {
                        player.func_191521_c(cont);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

