/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.ExplodeGoal;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

@Immutable
public class ExplodeBehavior
extends GolemBehavior {
    protected final double range;
    protected final int fuse;
    protected final double chanceOnHurt;
    protected final double chanceOnAttack;

    public ExplodeBehavior(CompoundNBT tag) {
        super(tag);
        this.range = tag.func_74769_h("range");
        this.fuse = tag.func_74762_e("fuse");
        this.chanceOnHurt = tag.func_74769_h("chance_on_hurt");
        this.chanceOnAttack = tag.func_74769_h("chance_on_attack");
    }

    public int getFuseLen() {
        return this.fuse;
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        entity.field_70714_bg.func_75776_a(0, new ExplodeGoal<GolemBase>(entity, (float)this.range));
    }

    @Override
    public void onHurtTarget(GolemBase entity, Entity target) {
        if (target.func_70027_ad() || (double)entity.field_70170_p.func_201674_k().nextFloat() < this.chanceOnAttack) {
            entity.lightFuse();
        }
    }

    @Override
    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
        if (source.func_76347_k() || (double)entity.field_70170_p.func_201674_k().nextFloat() < this.chanceOnHurt) {
            entity.lightFuse();
        }
    }

    @Override
    public void onDie(GolemBase entity, DamageSource source) {
        entity.explode((float)this.range);
    }

    @Override
    public void onMobInteract(GolemBase entity, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151033_d) {
            Vector3d pos = entity.func_213303_ch();
            entity.field_70170_p.func_184148_a(player, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187649_bu, entity.func_184176_by(), 1.0f, entity.field_70170_p.func_201674_k().nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            entity.func_70015_d(Math.floorDiv(this.getFuseLen(), 20));
            entity.lightFuse();
            itemstack.func_222118_a(1, (LivingEntity)player, c -> c.func_213334_d(hand));
        }
    }

    @Override
    public void onWriteData(GolemBase entity, CompoundNBT tag) {
        entity.saveFuse(tag);
    }

    @Override
    public void onReadData(GolemBase entity, CompoundNBT tag) {
        entity.loadFuse(tag);
    }

    @Override
    public void onAddDescriptions(List<ITextComponent> list) {
        list.add((ITextComponent)new TranslationTextComponent("entitytip.explode").func_240699_a_(TextFormatting.RED));
    }
}

