/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import com.mcmoddev.golems.golem_stats.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.golem_stats.behavior.parameter.FireBehaviorParameter;
import com.mcmoddev.golems.golem_stats.behavior.parameter.MobEffectBehaviorParameter;
import com.mcmoddev.golems.golem_stats.behavior.parameter.SummonEntityBehaviorParameter;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;

@Immutable
public class OnActuallyHurtBehavior
extends GolemBehavior {
    protected final Optional<FireBehaviorParameter> fire;
    protected final Optional<MobEffectBehaviorParameter> effect;
    protected final Optional<SummonEntityBehaviorParameter> summon;

    public OnActuallyHurtBehavior(CompoundNBT tag) {
        super(tag);
        this.fire = tag.func_74764_b("fire") ? Optional.of(new FireBehaviorParameter(tag.func_74775_l("fire"))) : Optional.empty();
        this.effect = tag.func_74764_b("effect") ? Optional.of(new MobEffectBehaviorParameter(tag.func_74775_l("effect"))) : Optional.empty();
        this.summon = tag.func_74764_b("summon") ? Optional.of(new SummonEntityBehaviorParameter(tag.func_74775_l("summon"))) : Optional.empty();
    }

    @Override
    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
        if (!entity.func_70631_g_()) {
            this.fire.ifPresent(p -> p.apply(entity, source.func_76364_f()));
            if (source.func_76364_f() instanceof LivingEntity) {
                this.effect.ifPresent(p -> p.apply(entity, (LivingEntity)source.func_76364_f()));
            }
            this.summon.ifPresent(p -> p.apply(entity, source.func_76364_f()));
        }
    }

    @Override
    public void onAddDescriptions(List<ITextComponent> list) {
        this.fire.ifPresent(p -> {
            if (p.getTarget() == BehaviorParameter.Target.ENEMY && !list.contains(FIRE_DESC)) {
                list.add((ITextComponent)FIRE_DESC);
            }
        });
        this.effect.ifPresent(p -> {
            if (p.getTarget() == BehaviorParameter.Target.SELF && !list.contains(EFFECTS_SELF_DESC)) {
                list.add((ITextComponent)EFFECTS_SELF_DESC);
            } else if (p.getTarget() == BehaviorParameter.Target.ENEMY && !list.contains(EFFECTS_ENEMY_DESC)) {
                list.add((ITextComponent)EFFECTS_ENEMY_DESC);
            }
        });
        this.summon.ifPresent(p -> {
            if (!list.contains(p.getDescription())) {
                list.add(p.getDescription());
            }
        });
    }
}

