/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.PassiveEffectsGoal;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import com.mcmoddev.golems.golem_stats.behavior.parameter.BehaviorParameter;
import com.mcmoddev.golems.golem_stats.behavior.parameter.MobEffectBehaviorParameter;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

@Immutable
public class PassiveEffectBehavior
extends GolemBehavior {
    protected final boolean nightOnly;
    protected final Optional<MobEffectBehaviorParameter> effect;

    public PassiveEffectBehavior(CompoundNBT tag) {
        super(tag);
        this.nightOnly = tag.func_74767_n("night_only");
        this.effect = tag.func_74764_b("effect") ? Optional.of(new MobEffectBehaviorParameter(tag.func_74775_l("effect"))) : Optional.empty();
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        this.effect.ifPresent(e -> entity.field_70714_bg.func_75776_a(4, (Goal)new PassiveEffectsGoal(entity, e.getEffects(), this.nightOnly, e.getTarget() == BehaviorParameter.Target.SELF, (float)e.getChance())));
    }

    @Override
    public void onAddDescriptions(List<ITextComponent> list) {
        this.effect.ifPresent(p -> {
            if (p.getTarget() == BehaviorParameter.Target.SELF && !list.contains(EFFECTS_SELF_DESC)) {
                list.add((ITextComponent)EFFECTS_SELF_DESC);
            } else if (p.getTarget() == BehaviorParameter.Target.ENEMY && !list.contains(EFFECTS_ENEMY_DESC)) {
                list.add((ITextComponent)EFFECTS_ENEMY_DESC);
            }
        });
    }
}

