/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.PlaceBlocksGoal;
import com.mcmoddev.golems.golem_stats.GolemContainer;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import com.mcmoddev.golems.util.ResourcePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

@Immutable
public class PlaceBlocksBehavior
extends GolemBehavior {
    private final int interval;
    private final List<ResourceLocation> blocks = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> blockTags = new ArrayList<ResourceLocation>();

    public PlaceBlocksBehavior(CompoundNBT tag) {
        super(tag);
        this.interval = tag.func_74762_e("interval");
        ListNBT blocksTag = (ListNBT)tag.func_74781_a("blocks");
        int l = blocksTag.size();
        for (int i = 0; i < l; ++i) {
            Optional result = ResourcePair.read(blocksTag.func_150307_f(i)).resultOrPartial(s -> ExtraGolems.LOGGER.error("Error reading 'blocks' from NBT\n" + s));
            result.ifPresent(p -> {
                if (p.flag()) {
                    this.blockTags.add(p.resource());
                } else {
                    this.blocks.add(p.resource());
                }
            });
        }
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        blockList.addAll(GolemContainer.getAllBlocks(this.blocks, this.blockTags));
        entity.field_70714_bg.func_75776_a(2, (Goal)new PlaceBlocksGoal(entity, this.interval, blockList.toArray(new Block[0])));
    }

    @Override
    public void onAddDescriptions(List<ITextComponent> list) {
    }
}

