/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.MoveToItemGoal;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import com.mcmoddev.golems.menu.PortableDispenserMenu;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

@Immutable
public class ShootArrowsBehavior
extends GolemBehavior {
    protected final double damage;
    protected final AttributeModifier rangeModifier = new AttributeModifier("Ranged attack bonus", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public ShootArrowsBehavior(CompoundNBT tag) {
        super(tag);
        this.damage = tag.func_74769_h("damage");
    }

    public double getDamage() {
        return this.damage;
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        entity.func_110148_a(Attributes.field_233819_b_).func_233769_c_(this.rangeModifier);
        entity.field_70714_bg.func_75776_a(4, (Goal)new MoveToItemGoal((MobEntity)entity, 10.0, 30, 1.0));
    }

    @Override
    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
        if (source instanceof IndirectEntityDamageSource && source.func_76346_g() instanceof LivingEntity) {
            entity.func_70624_b((LivingEntity)source.func_76346_g());
        }
        boolean forceMelee = entity.func_70638_az() != null && entity.func_70638_az().func_70068_e((Entity)entity) < 8.0;
        entity.updateCombatTask(forceMelee);
    }

    @Override
    public void onMobInteract(GolemBase entity, PlayerEntity player, Hand hand) {
        if (!player.func_213453_ef() && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new PortableDispenserMenu.Provider(entity.getArrowInventory()));
            player.func_184609_a(hand);
        }
    }

    @Override
    public void onWriteData(GolemBase entity, CompoundNBT tag) {
        entity.saveArrowInventory(tag);
    }

    @Override
    public void onReadData(GolemBase entity, CompoundNBT tag) {
        entity.loadArrowInventory(tag);
    }

    @Override
    public void onAddDescriptions(List<ITextComponent> list) {
        list.add((ITextComponent)new TranslationTextComponent("entitytip.shoot_arrows").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        list.add((ITextComponent)new TranslationTextComponent("entitytip.click_refill").func_240699_a_(TextFormatting.GRAY));
    }
}

