/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;

@Immutable
public class SplitBehavior
extends GolemBehavior {
    protected final int children;

    public SplitBehavior(CompoundNBT tag) {
        super(tag);
        this.children = tag.func_74762_e("children");
    }

    public int getChildren() {
        return this.children;
    }

    @Override
    public void onDie(GolemBase entity, DamageSource source) {
        this.attemptAddChildren(entity, this.children);
    }

    protected Collection<GolemBase> attemptAddChildren(GolemBase entity, int count) {
        ArrayList<GolemBase> children = new ArrayList<GolemBase>();
        if (entity.field_70170_p instanceof ServerWorld && !entity.func_70631_g_() && count > 0) {
            DifficultyInstance diff = entity.field_70170_p.func_175649_E(entity.func_233580_cy_());
            for (int i = 0; i < count; ++i) {
                GolemBase child = GolemBase.create(entity.field_70170_p, entity.getMaterial());
                child.setBaby(true);
                child.setTextureId((byte)entity.getTextureId());
                if (entity.func_70638_az() != null) {
                    child.func_70624_b(entity.func_70638_az());
                }
                child.func_82149_j((Entity)entity);
                entity.field_70170_p.func_217376_c((Entity)child);
                child.func_213386_a((IServerWorld)((ServerWorld)entity.field_70170_p), diff, SpawnReason.MOB_SUMMONED, null, null);
                children.add(child);
            }
        }
        return children;
    }

    @Override
    public void onAddDescriptions(List<ITextComponent> list) {
        list.add((ITextComponent)new TranslationTextComponent("entitytip.split_on_death").func_240699_a_(TextFormatting.LIGHT_PURPLE));
    }
}

