/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.RandomTeleportGoal;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

@Immutable
public class TeleportBehavior
extends GolemBehavior {
    protected final double range;
    protected final double chanceOnIdle;
    protected final double chanceOnHurt;
    protected final double chanceOnTarget;

    public TeleportBehavior(CompoundNBT tag) {
        super(tag);
        this.range = tag.func_74769_h("range");
        this.chanceOnIdle = tag.func_74769_h("chance_on_idle");
        this.chanceOnHurt = tag.func_74769_h("chance_on_hurt");
        this.chanceOnTarget = tag.func_74769_h("chance_on_target");
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        entity.field_70714_bg.func_75776_a(1, new RandomTeleportGoal<GolemBase>(entity, this.range, this.chanceOnIdle, this.chanceOnTarget));
    }

    @Override
    public void onActuallyHurt(GolemBase entity, DamageSource source, float amount) {
        block4: {
            block3: {
                if (!(source instanceof IndirectEntityDamageSource)) break block3;
                if (source.func_76346_g() instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)source.func_76346_g();
                    entity.func_130011_c((Entity)target);
                    entity.func_70624_b(target);
                }
                for (int i = 0; i < 16; ++i) {
                    if (!entity.teleportRandomly((MobEntity)entity, this.range)) continue;
                    return;
                }
                break block4;
            }
            if (!(entity.field_70170_p.func_201674_k().nextDouble() < this.chanceOnHurt || entity.func_70638_az() == null && entity.field_70170_p.func_201674_k().nextBoolean()) && (!entity.getContainer().getAttributes().isHurtByWater() || source != DamageSource.field_76369_e)) break block4;
            for (int i = 0; i < 16; ++i) {
                if (!entity.teleportRandomly((MobEntity)entity, this.range)) continue;
                return;
            }
        }
    }

    @Override
    public void onAddDescriptions(List<ITextComponent> list) {
        list.add((ITextComponent)new TranslationTextComponent("entitytip.teleport").func_240699_a_(TextFormatting.LIGHT_PURPLE));
    }
}

