/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.entity.goal.InertGoal;
import com.mcmoddev.golems.entity.goal.LookAtWhenActiveGoal;
import com.mcmoddev.golems.entity.goal.LookRandomlyWhenActiveGoal;
import com.mcmoddev.golems.entity.goal.UseFuelGoal;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehavior;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

@Immutable
public class UseFuelBehavior
extends GolemBehavior {
    protected final int maxFuel;
    protected final int interval;

    public UseFuelBehavior(CompoundNBT tag) {
        super(tag);
        this.maxFuel = tag.func_74762_e("max_fuel");
        this.interval = tag.func_74762_e("burn_interval");
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public int getInterval() {
        return this.interval;
    }

    @Override
    public void onRegisterGoals(GolemBase entity) {
        UseFuelBehavior.removeGoal(entity, LookAtGoal.class);
        UseFuelBehavior.removeGoal(entity, LookRandomlyGoal.class);
        entity.field_70714_bg.func_75776_a(0, new InertGoal<GolemBase>(entity));
        entity.field_70714_bg.func_75776_a(1, new UseFuelGoal<GolemBase>(entity, this.interval));
        entity.field_70714_bg.func_75776_a(7, new LookAtWhenActiveGoal<GolemBase>(entity, PlayerEntity.class, 6.0f));
        entity.field_70714_bg.func_75776_a(8, new LookRandomlyWhenActiveGoal<GolemBase>(entity));
    }

    @Override
    public void onMobInteract(GolemBase entity, PlayerEntity player, Hand hand) {
        if (!player.func_213453_ef() && !player.func_184586_b(hand).func_190926_b()) {
            entity.consumeFuel(player, hand);
        }
    }

    @Override
    public void onWriteData(GolemBase entity, CompoundNBT tag) {
        entity.saveFuel(tag);
    }

    @Override
    public void onReadData(GolemBase entity, CompoundNBT tag) {
        entity.loadFuel(tag);
    }

    @Override
    public void onAddDescriptions(List<ITextComponent> list) {
        list.add((ITextComponent)new TranslationTextComponent("entitytip.use_fuel").func_240699_a_(TextFormatting.GRAY));
    }

    protected static boolean removeGoal(GolemBase entity, Class<? extends Goal> goalToRemove) {
        ArrayList goalsToRemove = new ArrayList();
        entity.field_70714_bg.field_220892_d.forEach(g -> {
            if (g.func_220772_j().getClass() == goalToRemove) {
                goalsToRemove.add(g.func_220772_j());
            }
        });
        goalsToRemove.forEach(g -> entity.field_70714_bg.func_85156_a(g));
        return !goalsToRemove.isEmpty();
    }
}

