/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior.parameter;

import com.google.common.collect.ImmutableMap;
import com.mcmoddev.golems.golem_stats.behavior.parameter.BehaviorParameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;

public class ChangeIdBehaviorParameter
extends BehaviorParameter {
    private final Map<String, ChangeIdData> idMap;
    private final Optional<Double> chance;
    private final Optional<Boolean> consume;

    public ChangeIdBehaviorParameter(CompoundNBT tag, String mapName) {
        this(tag, mapName, mapName);
    }

    public ChangeIdBehaviorParameter(CompoundNBT tag, String mapName, String dataName) {
        this.chance = tag.func_74764_b("chance") ? Optional.of(tag.func_74769_h("chance")) : Optional.empty();
        this.consume = tag.func_74764_b("consume") ? Optional.of(tag.func_74767_n("consume")) : Optional.empty();
        this.idMap = ImmutableMap.copyOf(this.readStringDataMap(tag.func_74775_l(mapName), dataName));
    }

    public double getChance() {
        return this.chance.orElse(1.0);
    }

    public double getChance(String input) {
        return this.idMap.containsKey(input) ? this.idMap.get(input).getChance() : this.getChance();
    }

    public boolean consume() {
        return this.consume.orElse(false);
    }

    public boolean consume(String input) {
        return this.idMap.containsKey(input) ? this.idMap.get(input).consume() : this.consume();
    }

    public String getId(String input, String fallback) {
        return this.idMap.containsKey(input) ? this.idMap.get(input).getId() : fallback;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ChangeId:");
        this.chance.ifPresent(c -> b.append(" chance[").append(c).append("]"));
        this.consume.ifPresent(c -> b.append(" consume[").append(c).append("]"));
        b.append(" map[").append(this.idMap.toString()).append("]");
        return b.toString();
    }

    protected Map<String, ChangeIdData> readStringDataMap(CompoundNBT tag, String dataKey) {
        HashMap<String, ChangeIdData> map = new HashMap<String, ChangeIdData>();
        for (String key : tag.func_150296_c()) {
            if (tag.func_150297_b(key, 10)) {
                map.put(key, new ChangeIdData(tag.func_74775_l(key), dataKey));
                continue;
            }
            map.put(key, new ChangeIdData(this.getChance(), this.consume(), tag.func_74779_i(key)));
        }
        return map;
    }

    private static class ChangeIdData
    extends BehaviorParameter {
        private final double chance;
        private final boolean consume;
        private final String id;

        private ChangeIdData(CompoundNBT tag, String idName) {
            this.chance = tag.func_74764_b("chance") ? tag.func_74769_h("chance") : 1.0;
            this.consume = tag.func_74767_n("consume");
            this.id = tag.func_150297_b(idName, 99) ? String.valueOf(tag.func_74762_e(idName)) : tag.func_74779_i(idName);
        }

        private ChangeIdData(double chanceIn, boolean consumeIn, String idIn) {
            this.chance = chanceIn;
            this.consume = consumeIn;
            this.id = idIn;
        }

        public double getChance() {
            return this.chance;
        }

        public boolean consume() {
            return this.consume;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return "ChangeIdData: chance[" + this.chance + "] consume[" + this.consume + "] id[" + this.id + "]";
        }
    }
}

