/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.golem_stats.behavior.parameter;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_stats.behavior.parameter.BehaviorParameter;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@Immutable
public class SummonEntityBehaviorParameter
extends BehaviorParameter {
    private final BehaviorParameter.Target target;
    private final BehaviorParameter.Target targetPos;
    private final ResourceLocation entityId;
    private final CompoundNBT compoundTag;
    private final double chance;
    private final double bonusChanceInRain;
    private final ITextComponent component;

    public SummonEntityBehaviorParameter(CompoundNBT tag) {
        this.target = BehaviorParameter.Target.getByName(tag.func_74779_i("target"));
        this.targetPos = tag.func_74764_b("summon_pos") ? BehaviorParameter.Target.getByName(tag.func_74779_i("summon_pos")) : this.target;
        this.compoundTag = tag.func_74775_l("entity");
        this.entityId = new ResourceLocation(this.compoundTag.func_74779_i("id"));
        this.chance = tag.func_74769_h("chance");
        this.bonusChanceInRain = tag.func_74769_h("bonus_chance_in_rain");
        this.component = new TranslationTextComponent("entitytip.summon_x", new Object[]{new TranslationTextComponent("entity." + this.entityId.func_110624_b() + "." + this.entityId.func_110623_a())});
    }

    public BehaviorParameter.Target getTarget() {
        return this.target;
    }

    public BehaviorParameter.Target getSummonPos() {
        return this.targetPos;
    }

    public ResourceLocation getEntityId() {
        return this.entityId;
    }

    public double getChance() {
        return this.chance;
    }

    public double getBonusChanceInRain() {
        return this.bonusChanceInRain;
    }

    public CompoundNBT getCompoundNBT() {
        return this.compoundTag;
    }

    public ITextComponent getDescription() {
        return this.component;
    }

    public void apply(GolemBase self, @Nullable Entity angerTarget) {
        double chanceApply = this.chance;
        if (self.field_70170_p.func_175727_C(self.func_233580_cy_())) {
            chanceApply += this.bonusChanceInRain;
        }
        if (!self.field_70170_p.func_201670_d() && (double)self.field_70170_p.func_201674_k().nextFloat() < chanceApply) {
            Optional entity = EntityType.func_220330_a((CompoundNBT)this.compoundTag, (World)self.field_70170_p);
            if (entity.isPresent() && self.field_70170_p instanceof ServerWorld) {
                ((Entity)entity.get()).func_70020_e(this.compoundTag);
                Vector3d pos = this.targetPos == BehaviorParameter.Target.SELF || angerTarget == null ? self.func_213303_ch() : angerTarget.func_213303_ch();
                ((Entity)entity.get()).func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                self.field_70170_p.func_217376_c((Entity)entity.get());
                if (entity.get() instanceof MobEntity) {
                    ((MobEntity)entity.get()).func_213386_a((IServerWorld)((ServerWorld)self.field_70170_p), self.field_70170_p.func_175649_E(new BlockPos(pos)), SpawnReason.MOB_SUMMONED, null, null);
                    if (this.target == BehaviorParameter.Target.ENEMY && angerTarget != null) {
                        ((MobEntity)entity.get()).func_70624_b(self.func_70638_az());
                    }
                }
                if (entity.get() instanceof IAngerable && this.target == BehaviorParameter.Target.ENEMY && angerTarget != null) {
                    ((IAngerable)entity.get()).func_230259_a_(angerTarget.func_110124_au());
                    ((IAngerable)entity.get()).func_230258_H__();
                }
            } else {
                ExtraGolems.LOGGER.warn("GolemBehavior failed to create entity of type " + this.entityId);
            }
        }
    }
}

