/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehaviors;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GolemDescriptionManager {
    protected boolean showSpecial = true;
    protected boolean showSpecialChild = false;
    protected boolean showAttack = true;
    protected boolean extended = false;

    public List<ITextComponent> getEntityDescription(GolemBase golem) {
        LinkedList<ITextComponent> list = new LinkedList<ITextComponent>();
        if (this.showAttack) {
            double attack = golem.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            list.add((ITextComponent)new TranslationTextComponent("entitytip.attack").func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(Double.toString(attack)).func_240699_a_(TextFormatting.WHITE)));
        }
        if (this.showSpecial) {
            if (golem.getContainer().hasBehavior(GolemBehaviors.USE_FUEL)) {
                this.addFuelInfo(golem, list);
            }
            if (golem.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
                this.addArrowsInfo(golem, list);
            }
        }
        if (!golem.func_70631_g_() && this.showSpecial || golem.func_70631_g_() && this.showSpecialChild) {
            list.addAll((Collection<ITextComponent>)golem.getContainer().getDescriptions());
        }
        return list;
    }

    protected void addFuelInfo(GolemBase g, List<ITextComponent> list) {
        float percentFuel = g.getFuelPercentage() * 100.0f;
        TextFormatting color = percentFuel < 6.0f ? TextFormatting.RED : (percentFuel < 16.0f ? TextFormatting.YELLOW : TextFormatting.WHITE);
        String fuelString = this.extended ? String.format("%d / %d", g.getFuel(), g.getMaxFuel()) : String.format("%.1f", Float.valueOf(percentFuel)) + "%";
        list.add((ITextComponent)new TranslationTextComponent("entitytip.fuel").func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(fuelString).func_240699_a_(color)));
    }

    protected void addArrowsInfo(GolemBase g, List<ITextComponent> list) {
        int arrows = g.getArrowsInInventory();
        if (arrows > 0 && this.extended) {
            TextFormatting color = TextFormatting.WHITE;
            String arrowString = String.valueOf(arrows);
            list.add((ITextComponent)new TranslationTextComponent("entitytip.arrows").func_240699_a_(TextFormatting.GRAY).func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(arrowString).func_240699_a_(color)));
        }
    }

    protected static boolean isShiftDown() {
        return Screen.func_231173_s_();
    }
}

