/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehaviors;
import com.mcmoddev.golems.integration.GolemDescriptionManager;
import java.util.List;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

@WailaPlugin(value="golems")
public final class HwylaDescriptionManager
extends GolemDescriptionManager
implements IEntityComponentProvider,
IWailaPlugin,
IServerDataProvider<Entity> {
    public static final HwylaDescriptionManager INSTANCE = new HwylaDescriptionManager();

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        this.showAttack = HwylaDescriptionManager.isShiftDown();
        if (accessor.getEntity() instanceof GolemBase) {
            GolemBase golem = (GolemBase)accessor.getEntity();
            golem.setMaterial(new ResourceLocation(accessor.getServerData().func_74779_i("Material")));
            golem.loadFuel(accessor.getServerData());
            tooltip.addAll(this.getEntityDescription(golem));
        }
    }

    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, Entity entity) {
        if (entity instanceof GolemBase) {
            GolemBase golem = (GolemBase)entity;
            data.func_74778_a("Material", golem.getMaterial().toString());
            if (golem.getContainer().hasBehavior(GolemBehaviors.USE_FUEL)) {
                data.func_74768_a("Fuel", golem.getFuel());
            }
            if (golem.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
                data.func_74768_a("Arrows", golem.getArrowsInInventory());
            }
        }
    }

    public void register(IRegistrar register) {
        register.registerComponentProvider((IEntityComponentProvider)INSTANCE, TooltipPosition.BODY, GolemBase.class);
        register.registerEntityDataProvider((IServerDataProvider)INSTANCE, GolemBase.class);
    }
}

