/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.item;

import com.mcmoddev.golems.EGConfig;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_stats.GolemContainer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class SpawnGolemItem
extends Item {
    public static final ResourceLocation BEDROCK_GOLEM = new ResourceLocation("golems", "bedrock");

    public SpawnGolemItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        if (EGConfig.bedrockGolemCreativeOnly() && !player.func_184812_l_() || facing == Direction.DOWN) {
            return ActionResultType.FAIL;
        }
        Optional<GolemContainer> container = ExtraGolems.GOLEM_CONTAINERS.get(BEDROCK_GOLEM);
        if (container.isPresent()) {
            BlockState state = worldIn.func_180495_p(pos);
            BlockPos spawnPos = state.func_196951_e((IBlockReader)context.func_195991_k(), context.func_195995_a()).func_197766_b() ? pos : pos.func_177972_a(context.func_196000_l());
            if (worldIn instanceof ServerWorld) {
                GolemBase entity = GolemBase.create((World)((ServerWorld)worldIn), BEDROCK_GOLEM);
                entity.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
                worldIn.func_217376_c((Entity)entity);
                entity.func_213386_a((IServerWorld)((ServerWorld)worldIn), worldIn.func_175649_E(spawnPos), SpawnReason.SPAWN_EGG, null, null);
            }
            SpawnGolemItem.spawnParticles(worldIn, spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p(), 0.12);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity entity, Hand hand) {
        GolemBase golem;
        if (entity instanceof GolemBase && (golem = (GolemBase)entity).getMaterial().equals((Object)BEDROCK_GOLEM)) {
            if (!entity.field_70170_p.func_201670_d()) {
                golem.func_70106_y();
            }
            SpawnGolemItem.spawnParticles(playerIn.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_(), 0.12);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void spawnParticles(World world, double x, double y, double z, double motion) {
        SpawnGolemItem.spawnParticles(world, x, y, z, motion, (IParticleData)ParticleTypes.field_197594_E, 60);
    }

    public static void spawnParticles(World world, double x, double y, double z, double motion, IParticleData type, int num) {
        if (world.field_72995_K) {
            for (int i = num + world.field_73012_v.nextInt(Math.max(1, num / 2)); i > 0; --i) {
                world.func_195594_a(type, x + world.field_73012_v.nextDouble() - 0.5, y + world.field_73012_v.nextDouble() - 0.5, z + world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() * motion - motion * 0.5, world.field_73012_v.nextDouble() * motion * 0.5, world.field_73012_v.nextDouble() * motion - motion * 0.5);
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IFormattableTextComponent loreCreativeOnly = new TranslationTextComponent("tooltip.creative_only_item").func_240699_a_(TextFormatting.RED);
        IFormattableTextComponent lorePressShift = new TranslationTextComponent("tooltip.press").func_240699_a_(TextFormatting.GRAY).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.shift").func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.for_more_details").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)loreCreativeOnly);
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.use_to_spawn", new Object[]{new TranslationTextComponent("entity.golems.golem.bedrock")}));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.use_on_existing", new Object[]{new TranslationTextComponent("entity.golems.golem.bedrock")}));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.to_remove_it"));
        } else {
            tooltip.add((ITextComponent)lorePressShift);
        }
    }
}

