/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.network;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.golem_stats.GolemContainer;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SGolemContainerPacket {
    protected ResourceLocation key;
    protected GolemContainer golemContainer;

    public SGolemContainerPacket(ResourceLocation key, GolemContainer golemContainerIn) {
        this.key = key;
        this.golemContainer = golemContainerIn;
    }

    public static SGolemContainerPacket fromBytes(PacketBuffer buf) {
        ResourceLocation sKey = buf.func_192575_l();
        CompoundNBT sNBT = buf.func_150793_b();
        Optional sCont = ExtraGolems.GOLEM_CONTAINERS.readObject((INBT)sNBT).resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to read GolemContainer from NBT for packet\n" + error));
        return new SGolemContainerPacket(sKey, sCont.orElse(GolemContainer.EMPTY));
    }

    public static void toBytes(SGolemContainerPacket msg, PacketBuffer buf) {
        DataResult<INBT> nbtResult = ExtraGolems.GOLEM_CONTAINERS.writeObject(msg.golemContainer);
        INBT tag = (INBT)nbtResult.resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to write GolemContainer to NBT for packet\n" + error)).get();
        buf.func_192572_a(msg.key);
        buf.func_150786_a((CompoundNBT)tag);
    }

    public static void handlePacket(SGolemContainerPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> ExtraGolems.GOLEM_CONTAINERS.put(message.key, message.golemContainer));
        }
        context.setPacketHandled(true);
    }
}

