/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.network;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.golem_models.GolemRenderSettings;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SGolemModelPacket {
    protected ResourceLocation key;
    protected GolemRenderSettings golemModel;

    public SGolemModelPacket(ResourceLocation key, GolemRenderSettings golemModelIn) {
        this.key = key;
        this.golemModel = golemModelIn;
    }

    public static SGolemModelPacket fromBytes(PacketBuffer buf) {
        ResourceLocation sKey = buf.func_192575_l();
        CompoundNBT sNBT = buf.func_150793_b();
        Optional sCont = ExtraGolems.GOLEM_RENDER_SETTINGS.readObject((INBT)sNBT).resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to read GolemRenderSettings from NBT for packet\n" + error));
        return new SGolemModelPacket(sKey, sCont.orElse(GolemRenderSettings.EMPTY));
    }

    public static void toBytes(SGolemModelPacket msg, PacketBuffer buf) {
        DataResult<INBT> nbtResult = ExtraGolems.GOLEM_RENDER_SETTINGS.writeObject(msg.golemModel);
        INBT tag = (INBT)nbtResult.resultOrPartial(error -> ExtraGolems.LOGGER.error("Failed to write GolemRenderSettings to NBT for packet\n" + error)).get();
        buf.func_192572_a(msg.key);
        buf.func_150786_a((CompoundNBT)tag);
    }

    public static void handlePacket(SGolemModelPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                ExtraGolems.GOLEM_RENDER_SETTINGS.put(message.key, message.golemModel);
                message.golemModel.load();
            });
        }
        context.setPacketHandled(true);
    }
}

