/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.render;

import com.mcmoddev.golems.ExtraGolems;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class DynamicTextureState {
    public static final int TILES = 8;
    public ResourceLocation location;
    public ResourceLocation sourceImage;
    public ResourceLocation templateImage;
    public RenderState.TextureState state;
    public DynamicTexture texture;

    public DynamicTextureState(ResourceLocation id, ResourceLocation blockName, ResourceLocation templateName) {
        this.location = id;
        this.sourceImage = blockName;
        this.templateImage = templateName;
        try {
            IResource blockResource = Minecraft.func_71410_x().func_195551_G().func_199002_a(blockName);
            IResource templateResource = Minecraft.func_71410_x().func_195551_G().func_199002_a(templateName);
            NativeImage block = NativeImage.func_195713_a((InputStream)blockResource.func_199027_b());
            NativeImage template = NativeImage.func_195713_a((InputStream)templateResource.func_199027_b());
            int blockWidth = block.func_195702_a();
            int outputWidth = 8 * blockWidth;
            int outputHeight = 8 * blockWidth;
            int templateWidth = template.func_195702_a();
            int templateHeight = template.func_195714_b();
            float scale = outputWidth / templateWidth;
            this.texture = new DynamicTexture(outputWidth, outputHeight, true);
            NativeImage outputImg = this.texture.func_195414_e();
            for (int j = 0; j < outputHeight; ++j) {
                for (int i = 0; i < outputWidth; ++i) {
                    byte alpha = template.func_211675_e((int)((float)i / scale) % templateWidth, (int)((float)j / scale) % templateHeight);
                    outputImg.func_195700_a(i, j, block.func_195709_a(i % blockWidth, j % blockWidth) & alpha);
                }
            }
        }
        catch (IOException e) {
            ExtraGolems.LOGGER.error("Error trying to make dynamic texture for " + blockName + " with template " + templateName);
            this.texture = new DynamicTexture(128, 128, true);
            this.texture.func_195414_e().func_195715_a(0, 0, 128, 128, -1);
            e.printStackTrace();
        }
        this.texture.func_110564_a();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_229263_a_(this.location, (Texture)this.texture);
        this.state = new RenderState.TextureState(this.location, false, false);
    }
}

