/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.render;

import com.mcmoddev.golems.EGConfig;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_models.GolemRenderSettings;
import com.mcmoddev.golems.render.GolemModel;
import com.mcmoddev.golems.render.GolemRenderType;
import com.mcmoddev.golems.render.layer.ColoredTextureLayer;
import com.mcmoddev.golems.render.layer.GolemBannerLayer;
import com.mcmoddev.golems.render.layer.GolemCrackinessLayer;
import com.mcmoddev.golems.render.layer.GolemFlowerLayer;
import com.mcmoddev.golems.render.layer.GolemKittyLayer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;

public class GolemRenderer<T extends GolemBase>
extends MobRenderer<T, GolemModel<T>> {
    protected static final ResourceLocation boneTexture = new ResourceLocation("golems", "textures/entity/golem/bone_skeleton.png");
    protected static final ResourceLocation specialTexture = new ResourceLocation("golems", "textures/entity/golem/special.png");
    protected static final ResourceLocation specialTexture2 = new ResourceLocation("golems", "textures/entity/golem/special2.png");
    private static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    protected boolean isAlphaLayer;

    public GolemRenderer(EntityRendererManager rendererManagerIn) {
        super(rendererManagerIn, new GolemModel(), 0.5f);
        this.func_177094_a(new ColoredTextureLayer(this));
        this.func_177094_a(new GolemCrackinessLayer(this));
        this.func_177094_a(new GolemFlowerLayer(this));
        this.func_177094_a(new GolemKittyLayer(this));
        this.func_177094_a(new GolemBannerLayer(this));
    }

    public void render(T golem, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (golem.func_82150_aj()) {
            return;
        }
        Optional<GolemRenderSettings> settings = ExtraGolems.GOLEM_RENDER_SETTINGS.get(((GolemBase)golem).getMaterial());
        if (!settings.isPresent()) {
            ResourceLocation m = ((GolemBase)golem).getMaterial();
            ExtraGolems.LOGGER.error("Missing GolemRenderSettings at data/" + m.func_110624_b() + "/golem_models/" + m.func_110623_a() + ".json");
            ExtraGolems.GOLEM_RENDER_SETTINGS.put(((GolemBase)golem).getMaterial(), GolemRenderSettings.EMPTY);
            settings = Optional.of(GolemRenderSettings.EMPTY);
        }
        matrixStackIn.func_227860_a_();
        if (((GolemBase)golem).func_70631_g_()) {
            float scaleChild = 0.5f;
            matrixStackIn.func_227862_a_(scaleChild, scaleChild, scaleChild);
        }
        Vector3f colors = settings.get().getBaseColor().isPresent() && settings.get().getBaseColor().get() > 0 ? GolemRenderSettings.unpackColor(settings.get().getBaseColor().get()) : (settings.get().useBiomeColor() ? GolemRenderSettings.unpackColor(((GolemBase)golem).getBiomeColor()) : ONE);
        ((GolemModel)this.func_217764_d()).setColor(colors.func_195899_a(), colors.func_195900_b(), colors.func_195902_c());
        this.isAlphaLayer = settings.get().isTranslucent();
        if (this.isAlphaLayer) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        int packedLight = settings.get().getBaseLight().orElse(settings.get().getBaseLight().orElse(false)) != false ? 0xF000F0 : packedLightIn;
        super.func_225623_a_(golem, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLight);
        if (this.isAlphaLayer) {
            RenderSystem.disableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(T golem) {
        GolemRenderSettings settings = ExtraGolems.GOLEM_RENDER_SETTINGS.get(((GolemBase)golem).getMaterial()).orElse(GolemRenderSettings.EMPTY);
        ResourceLocation texture = settings.getBase((GolemBase)golem).resource();
        boolean disableLayers = false;
        if (EGConfig.halloween() && GolemRenderer.isNightTime(golem)) {
            texture = boneTexture;
            disableLayers = true;
        } else if (golem.func_145818_k_()) {
            String s = TextFormatting.func_110646_a((String)golem.func_200200_C_().getString());
            if ("Ganondorf".equals(s)) {
                texture = specialTexture;
                disableLayers = true;
            }
            if ("Cookie".equals(s)) {
                texture = specialTexture2;
                disableLayers = true;
            }
        }
        ((GolemModel)this.func_217764_d()).disableLayers(disableLayers);
        return texture;
    }

    @Nullable
    protected RenderType func_230496_a_(T golem, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        boolean dynamic;
        ResourceLocation template;
        ResourceLocation texture;
        GolemRenderSettings settings = ExtraGolems.GOLEM_RENDER_SETTINGS.get(((GolemBase)golem).getMaterial()).orElse(GolemRenderSettings.EMPTY);
        try {
            texture = this.getEntityTexture(golem);
            template = settings.getBaseTemplate();
            dynamic = GolemRenderer.isDynamic(golem, texture, settings);
        }
        catch (NullPointerException e) {
            texture = GolemRenderSettings.FALLBACK_BLOCK;
            template = GolemRenderSettings.BASE_TEMPLATE;
            dynamic = true;
        }
        if (isVisible || isVisibleToPlayer || this.isAlphaLayer) {
            return GolemRenderType.getGolemTranslucent(texture, template, dynamic);
        }
        if (isGlowing) {
            return GolemRenderType.getGolemOutline(texture, template, dynamic);
        }
        return GolemRenderType.getGolemCutout(texture, template, dynamic);
    }

    protected static boolean isSpecial(ResourceLocation texture) {
        return texture == boneTexture || texture == specialTexture || texture == specialTexture2;
    }

    protected static <T extends GolemBase> boolean isDynamic(T entity, ResourceLocation texture, GolemRenderSettings settings) {
        return !GolemRenderer.isSpecial(texture) && !settings.getBase(entity).flag();
    }

    public static boolean isNightTime(GolemBase golem) {
        long time = golem.field_70170_p.func_72820_D() % 24000L;
        return time > 13000L && time < 23000L;
    }
}

