/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.render.layer;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_models.GolemRenderSettings;
import com.mcmoddev.golems.golem_models.LayerRenderSettings;
import com.mcmoddev.golems.render.GolemModel;
import com.mcmoddev.golems.render.GolemRenderType;
import com.mcmoddev.golems.util.ResourcePair;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.util.math.vector.Vector3f;

public class ColoredTextureLayer<T extends GolemBase>
extends LayerRenderer<T, GolemModel<T>> {
    private static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    private final GolemModel<T> layerModel = new GolemModel();

    public ColoredTextureLayer(IEntityRenderer<T, GolemModel<T>> renderParent) {
        super(renderParent);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        GolemRenderSettings settings = ExtraGolems.GOLEM_RENDER_SETTINGS.get(((GolemBase)entity).getMaterial()).orElse(GolemRenderSettings.EMPTY);
        if (!(entity.func_82150_aj() || ((GolemModel)this.func_215332_c()).disableLayers() || settings.getLayers().isEmpty())) {
            ((GolemModel)this.func_215332_c()).func_217111_a((EntityModel)this.layerModel);
            this.layerModel.func_212843_a_((IronGolemEntity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.layerModel.setRotationAngles(entity, limbSwing, limbSwingAmount, partialTicks, netHeadYaw, headPitch);
            settings.getLayers().forEach(l -> ColoredTextureLayer.renderTexture(this.layerModel, settings, l, matrixStackIn, bufferIn, packedLightIn, entity));
        }
    }

    protected static <G extends GolemBase> void renderTexture(GolemModel<G> model, GolemRenderSettings settings, LayerRenderSettings layer, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, G entity) {
        int packedLight;
        matrixStackIn.func_227860_a_();
        ResourcePair texture = layer.getTexture();
        int n = packedLight = layer.getLight().orElse(settings.getBaseLight().orElse(false)) != false ? 0xF000F0 : packedLightIn;
        RenderType renderType = layer.isTranslucent() ? GolemRenderType.getGolemTranslucent(texture.resource(), layer.getTemplate(), !texture.flag()) : GolemRenderType.getGolemCutout(texture.resource(), layer.getTemplate(), !texture.flag());
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(renderType);
        if (layer.isTranslucent()) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        Vector3f colors = layer.getColor().isPresent() && layer.getColor().get() >= 0 ? GolemRenderSettings.unpackColor(layer.getColor().get()) : (settings.getBaseColor().isPresent() && settings.getBaseColor().get() >= 0 ? GolemRenderSettings.unpackColor(settings.getBaseColor().get()) : ONE);
        model.setColor(colors.func_195899_a(), colors.func_195900_b(), colors.func_195902_c());
        model.func_225598_a_(matrixStackIn, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (layer.isTranslucent()) {
            RenderSystem.disableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStackIn.func_227865_b_();
    }
}

