/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.screen;

import com.mcmoddev.golems.golem_stats.GolemContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GolemBookEntry {
    private final Block[] buildingBlocks;
    private final String nameString;
    private ResourceLocation imageLoc = null;
    private final int health;
    private final float attack;
    private final IFormattableTextComponent name;
    private final IFormattableTextComponent page;
    private final List<ITextComponent> specials = new ArrayList<ITextComponent>();

    public GolemBookEntry(@Nonnull ResourceLocation golemName, @Nonnull GolemContainer container) {
        this.nameString = "entity." + golemName.func_110624_b() + ".golem." + golemName.func_110623_a();
        this.health = (int)container.getAttributes().getHealth();
        this.attack = (float)container.getAttributes().getAttack();
        this.specials.addAll((Collection<ITextComponent>)container.getDescriptions());
        this.buildingBlocks = container.getAllBlocks().toArray(new Block[0]);
        String modid = golemName.func_110624_b();
        String name = golemName.func_110623_a();
        String img = (modid + ":textures/gui/info_book/").concat(name).concat(".png");
        try {
            this.imageLoc = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(img)).func_199029_a();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.name = new TranslationTextComponent(this.nameString);
        this.page = this.makePage();
    }

    public String getGolemNameRaw() {
        return this.nameString;
    }

    public boolean hasBlocks() {
        return this.buildingBlocks != null && this.buildingBlocks.length > 0;
    }

    public Block getBlock(int index) {
        return this.hasBlocks() ? this.buildingBlocks[index % this.buildingBlocks.length] : Blocks.field_150350_a;
    }

    public Block[] getBlocks() {
        return this.buildingBlocks;
    }

    public float getAttack() {
        return this.attack;
    }

    public int getDescriptionSize() {
        return this.specials.size();
    }

    public IFormattableTextComponent getGolemName() {
        return this.name;
    }

    public IFormattableTextComponent getDescriptionPage() {
        return this.page;
    }

    public boolean hasImage() {
        return this.imageLoc != null;
    }

    @Nullable
    public ResourceLocation getImageResource() {
        return this.imageLoc;
    }

    private IFormattableTextComponent makePage() {
        StringTextComponent page = new StringTextComponent("");
        page.func_240702_b_("\n").func_230529_a_((ITextComponent)new TranslationTextComponent("entitytip.health").func_240702_b_(": ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.health)).func_240699_a_(TextFormatting.BLACK)).func_230529_a_((ITextComponent)new StringTextComponent(" \u2764").func_240699_a_(TextFormatting.DARK_RED));
        page.func_240702_b_("\n").func_230529_a_((ITextComponent)new TranslationTextComponent("entitytip.attack").func_240702_b_(": ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.attack)).func_240699_a_(TextFormatting.BLACK)).func_240702_b_(" \u2694").func_240702_b_("\n");
        for (ITextComponent s : this.specials) {
            page.func_240702_b_("\n").func_230529_a_(s);
        }
        return page;
    }
}

