/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.blocks;

import java.util.Random;
import lily.golemist.GolemistItems;
import lily.golemist.common.blocks.BlockBase;
import lily.golemist.common.entity.EntityIronGolemMerchant;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CircleBase
extends BlockBase {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool RED = PropertyBool.func_177716_a((String)"red");
    public static final PropertyInteger MODEL = PropertyInteger.func_177719_a((String)"model", (int)0, (int)3);
    protected static final AxisAlignedBB AABB_CIRCLE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.01, 1.0);

    public CircleBase(String name, Material material) {
        super(name, material);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)RED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(null);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_CIRCLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack main = playerIn.func_184614_ca();
        ItemStack off = playerIn.func_184592_cb();
        if (main.func_190926_b()) {
            return true;
        }
        int i = (Integer)state.func_177229_b((IProperty)MODEL);
        if (i == 0 && main.func_77973_b() == GolemistItems.BLAZE_CHALK) {
            if (off.func_77973_b() == GolemistItems.PUMPKIN_MEDAL) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    main.func_77964_b(main.func_77952_i() - 1);
                    off.func_190918_g(1);
                }
                this.setModel(worldIn, pos, state, 1);
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void setModel(World worldIn, BlockPos pos, IBlockState state, int model) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)model, (int)0, (int)3))));
    }

    public void setRed(World worldIn, BlockPos pos, IBlockState state, int red) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)RED, (Comparable)Boolean.valueOf(true)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(meta));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        Random rnd;
        int i;
        super.func_180650_b(worldIn, pos, state, rand);
        if ((Integer)state.func_177229_b((IProperty)MODEL) == 1 && (i = (rnd = new Random()).nextInt(100)) <= this.getSummonigChance(this, worldIn, pos, state) && !worldIn.field_72995_K) {
            EntityIronGolemMerchant golem = new EntityIronGolemMerchant(worldIn);
            golem.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            golem.field_70759_as = golem.field_70177_z;
            golem.field_70761_aq = golem.field_70177_z;
            worldIn.func_175698_g(pos);
            worldIn.func_72838_d((Entity)golem);
        }
    }

    private int getSummonigChance(Block blockIn, World worldIn, BlockPos pos, IBlockState state) {
        ItemStack flower4;
        ItemStack flower3;
        ItemStack flower2;
        ItemStack flower1;
        int i = 2;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)this.func_176201_c(state));
        BlockPos back = pos.func_177972_a(enumfacing);
        BlockPos pos1 = pos.func_177978_c().func_177976_e();
        BlockPos pos2 = pos.func_177978_c().func_177974_f();
        BlockPos pos3 = pos.func_177968_d().func_177976_e();
        BlockPos pos4 = pos.func_177968_d().func_177974_f();
        if (worldIn.func_180495_p(back).func_177230_c() == Blocks.field_150486_ae) {
            i += 10;
        }
        if (worldIn.func_180495_p(pos1).func_177230_c() == Blocks.field_150457_bL && (flower1 = ((TileEntityFlowerPot)worldIn.func_175625_s(pos1)).func_184403_b()).func_77952_i() == 0) {
            i += 2;
        }
        if (worldIn.func_180495_p(pos2).func_177230_c() == Blocks.field_150457_bL && (flower2 = ((TileEntityFlowerPot)worldIn.func_175625_s(pos2)).func_184403_b()).func_77952_i() == 0) {
            i += 2;
        }
        if (worldIn.func_180495_p(pos3).func_177230_c() == Blocks.field_150457_bL && (flower3 = ((TileEntityFlowerPot)worldIn.func_175625_s(pos3)).func_184403_b()).func_77952_i() == 0) {
            i += 2;
        }
        if (worldIn.func_180495_p(pos4).func_177230_c() == Blocks.field_150457_bL && (flower4 = ((TileEntityFlowerPot)worldIn.func_175625_s(pos4)).func_184403_b()).func_77952_i() == 0) {
            i += 2;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)RED, (Comparable)Boolean.valueOf((meta & 8) > 0)).func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(meta >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        i |= (Integer)state.func_177229_b((IProperty)MODEL) << 2;
        if (((Boolean)state.func_177229_b((IProperty)RED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODEL, FACING, RED});
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canBePlacedOn(worldIn, pos.func_177977_b());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBePlacedOn(worldIn, pos.func_177977_b())) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBePlacedOn(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_185896_q() && worldIn.func_180495_p(pos).func_185914_p();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.updateNeighbors(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    protected void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177977_b(), (Block)this, false);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

