/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import lily.golemist.GolemistItems;
import lily.golemist.common.GolemProfessions;
import lily.golemist.common.entity.EntityHorseGolem;
import lily.golemist.common.entity.EntityStandardGolem;
import lily.golemist.common.entity.EntityStoneGolem;
import lily.golemist.common.entity.EntityUniqueGolem;
import lily.golemist.common.entity.EntityWolfGolem;
import lily.golemist.common.entity.ai.GolemAIDown;
import lily.golemist.common.entity.ai.GolemAIFollowOwner;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtByTarget;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtTarget;
import lily.golemist.common.entity.ai.GolemAISit;
import lily.golemist.common.items.runes.RuneBase;
import lily.golemist.util.handlers.ConfigHandler;
import lily.golemist.util.handlers.GolemsUtils;
import lily.golemist.util.handlers.IRune;
import lily.golemist.util.handlers.Runes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGolemBase
extends EntityCreature
implements IEntityOwnable {
    private static final DataParameter<Boolean> INITIAL = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> TAMED = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Optional<UUID>> PARTNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> RECOGNITION = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<BlockPos> HOME_POINT = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> HOME_DISTANCE = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CARRIED = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RUNES_1 = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RUNES_2 = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RUNES_3 = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RUNES_4 = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RUNES_5 = EntityDataManager.func_187226_a(EntityGolemBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int homeCheckTimer;
    protected int attackTimer;
    protected int yrHealingTime = 0;
    protected int sigelHealingTime = 0;
    protected int beorcMarchantTime = 0;
    protected GolemAIDown aiDown;
    protected EntityAISwimming aiSwim;
    protected GolemAISit aiSit;
    protected EntityAIAttackMelee aiMelee;
    protected EntityAIAttackRanged aiRenge;
    protected EntityAIAvoidEntity aiAvoid;
    protected GolemAIFollowOwner aiFollowOwner;
    protected EntityAIWanderAvoidWater aiWander;
    protected EntityAIWatchClosest aiWatch;
    protected EntityAILookIdle aiLook;
    protected GolemAIOwnerHurtByTarget aiOwnerHurtByTarget;
    protected GolemAIOwnerHurtTarget aiOwnerHurtTarget;
    protected EntityAIHurtByTarget aiHurtByTarget;
    protected EntityAINearestAttackableTarget aiAttackSlime;
    protected EntityAINearestAttackableTarget aiAttackMob;
    private boolean human;
    public static ConfigHandler config;

    public EntityGolemBase(World worldIn) {
        super(worldIn);
        this.setupTamedAI();
        this.setTamed(false);
    }

    protected void func_184651_r() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INITIAL, (Object)false);
        this.field_70180_af.func_187214_a(STATE, (Object)0);
        this.field_70180_af.func_187214_a(TAMED, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(PARTNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(RECOGNITION, (Object)false);
        this.field_70180_af.func_187214_a(HOME_POINT, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(HOME_DISTANCE, (Object)10);
        this.field_70180_af.func_187214_a(CARRIED, (Object)0);
        this.field_70180_af.func_187214_a(RUNES_1, (Object)0);
        this.field_70180_af.func_187214_a(RUNES_2, (Object)0);
        this.field_70180_af.func_187214_a(RUNES_3, (Object)0);
        this.field_70180_af.func_187214_a(RUNES_4, (Object)0);
        this.field_70180_af.func_187214_a(RUNES_5, (Object)0);
    }

    protected void func_70619_bc() {
        EntityPlayer owner;
        if (this.getHomeRecognition()) {
            BlockPos homePoint = this.getHomePoint();
            if (--this.homeCheckTimer <= 0) {
                this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
                if (homePoint != null) {
                    int x = this.func_180425_c().func_177958_n();
                    int y = this.func_180425_c().func_177956_o();
                    int z = this.func_180425_c().func_177952_p();
                    if (x < 0) {
                        x *= -1;
                    }
                    if (y < 0) {
                        y *= -1;
                    }
                    if (z < 0) {
                        z *= -1;
                    }
                    if (x >= this.getHomeDistance() || y >= this.getHomeDistance() || z >= this.getHomeDistance()) {
                        this.func_70661_as().func_75492_a((double)homePoint.func_177958_n(), (double)homePoint.func_177956_o(), (double)homePoint.func_177952_p(), this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b());
                    }
                }
            }
        }
        if ((owner = (EntityPlayer)this.getOwner()) != null && this.getState() == 0) {
            ItemStack mainHand = owner.func_184614_ca();
            if (owner.func_70093_af() && mainHand.func_77973_b() == GolemistItems.PUMPKIN_ROD) {
                Vec3d vec3d = owner.func_70676_i(1.0f).func_72432_b();
                Vec3d vec3d1 = new Vec3d(this.field_70165_t - owner.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (owner.field_70163_u + (double)owner.func_70047_e()), this.field_70161_v - owner.field_70161_v);
                double d0 = vec3d1.func_72433_c();
                double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
                if (d1 > 1.0 - 0.025 / d0 && owner.func_70685_l((Entity)this)) {
                    this.func_70661_as().func_75497_a((Entity)owner, 1.0);
                }
            }
        }
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188792_h);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setInitial(true);
        if (!(this instanceof EntityUniqueGolem && this instanceof EntityWolfGolem && this instanceof EntityHorseGolem)) {
            int numbers = 0;
            int difficultyBonus = this.field_70170_p.func_175659_aa().func_151525_a() * 5;
            for (int n = 0; n < 6; ++n) {
                if (this.field_70146_Z.nextInt(100) >= 10 + difficultyBonus) continue;
                ++numbers;
            }
            for (int slot = 0; slot < numbers; ++slot) {
                int runeNumber = this.field_70146_Z.nextInt(24);
                if (++runeNumber == 7 || runeNumber == 23) {
                    --slot;
                    continue;
                }
                this.setRunes(slot, runeNumber);
                Runes.chengeRune(this, runeNumber, true);
            }
        }
        if (this instanceof EntityStoneGolem) {
            EntityStoneGolem stonegolem = (EntityStoneGolem)this;
            if (stonegolem.isCaptain()) {
                int rankBonus = this.field_70170_p.func_175659_aa().func_151525_a() * ConfigHandler.upperRankChanceBonus;
                if (this.field_70146_Z.nextInt(100) < ConfigHandler.upperRankChance + rankBonus) {
                    if (this.field_70146_Z.nextInt(100) < ConfigHandler.upperRankChance + rankBonus) {
                        stonegolem.setRank(3);
                    } else {
                        stonegolem.setRank(2);
                    }
                }
                if (ConfigHandler.corpsLimit >= 1) {
                    int limit = 1;
                    while (true) {
                        if (limit >= ConfigHandler.corpsLimit) break;
                        EntityStoneGolem golem = new EntityStoneGolem(this.field_70170_p);
                        golem.func_70012_b(stonegolem.field_70165_t + 0.1, stonegolem.field_70163_u, stonegolem.field_70161_v + 0.1, stonegolem.field_70177_z, stonegolem.field_70125_A);
                        golem.setCaptainId(stonegolem.func_110124_au());
                        golem.setCaptain(false);
                        golem.setRank(stonegolem.getRank() - 1);
                        golem.setInitial(true);
                        this.field_70170_p.func_72838_d((Entity)golem);
                        stonegolem.setMembers(stonegolem.getMembers() + 1);
                        ++limit;
                    }
                }
            }
            double healthRankBonus = ConfigHandler.stoneGolemHealthBonus * (double)stonegolem.getRank();
            double attackRankBonus = ConfigHandler.stoneGolemAttackBonus * (double)stonegolem.getRank();
            stonegolem.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.stoneGolemHealth + healthRankBonus);
            stonegolem.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.stoneGolemBaseAttack + attackRankBonus);
        }
        return livingdata;
    }

    public boolean getInitial() {
        return (Boolean)this.field_70180_af.func_187225_a(INITIAL);
    }

    public void setInitial(boolean initial) {
        this.field_70180_af.func_187227_b(INITIAL, (Object)initial);
    }

    public int getState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public boolean isTamed() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (tamed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 | 4)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
        this.setupTamedAI();
    }

    protected void setupTamedAI() {
    }

    public boolean isSitting() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & 1) != 0;
    }

    public void setSitting(boolean sitting) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (sitting) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void setTamedBy(EntityPlayer player) {
        this.setTamed(true);
        this.setOwnerId(player.func_110124_au());
    }

    public GolemAISit getAISit() {
        return this.aiSit;
    }

    public boolean shouldAttackEntity(EntityLivingBase target, EntityLivingBase owner) {
        return true;
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase;
        if (this.isTamed() && (entitylivingbase = this.getOwner()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.isTamed()) {
            EntityLivingBase entitylivingbase = this.getOwner();
            if (entityIn == entitylivingbase) {
                return true;
            }
            if (entitylivingbase != null) {
                return entitylivingbase.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    @Nullable
    public UUID getPartnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(PARTNER_UNIQUE_ID)).orNull();
    }

    @Nullable
    public EntityLivingBase getPartner() {
        try {
            UUID uuid = this.getPartnerId();
            if (uuid != null) {
                EntityPlayer player = this.field_70170_p.func_152378_a(uuid);
                if (player != null) {
                    return player;
                }
                EntityLivingBase entity = EntityGolemBase.getEntityUUID(uuid, this.field_70170_p);
                if (entity != null) {
                    return entity;
                }
                return null;
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static EntityLivingBase getEntityUUID(UUID uuid, World world) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!uuid.equals(entity.func_110124_au())) continue;
            if (entity instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
            return null;
        }
        return null;
    }

    public void setPartnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(PARTNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public boolean getHomeRecognition() {
        return (Boolean)this.field_70180_af.func_187225_a(RECOGNITION);
    }

    public void setHomeRecognition(boolean recognition) {
        this.field_70180_af.func_187227_b(RECOGNITION, (Object)recognition);
    }

    public BlockPos getHomePoint() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME_POINT);
    }

    public void setHomePoint(BlockPos pos) {
        this.field_70180_af.func_187227_b(HOME_POINT, (Object)pos);
    }

    public int getHomeDistance() {
        return (Integer)this.field_70180_af.func_187225_a(HOME_DISTANCE);
    }

    public void setHomeDistance(int h_distance) {
        this.field_70180_af.func_187227_b(HOME_DISTANCE, (Object)h_distance);
    }

    public int getCarried() {
        return (Integer)this.field_70180_af.func_187225_a(CARRIED);
    }

    public void setCarried(int carried) {
        this.field_70180_af.func_187227_b(CARRIED, (Object)carried);
    }

    public boolean canCarried() {
        List<EntityGolemBase> nearEntities = GolemsUtils.getNearbyEntities(this, EntityGolemBase.class, null, 10.0);
        for (EntityGolemBase entityObj : nearEntities) {
            if (entityObj == this || entityObj.getCarried() <= 0) continue;
            return false;
        }
        return true;
    }

    public int getRunes(int slot) {
        int s = 0;
        if (slot == 1) {
            s = (Integer)this.field_70180_af.func_187225_a(RUNES_1);
        } else if (slot == 2) {
            s = (Integer)this.field_70180_af.func_187225_a(RUNES_2);
        } else if (slot == 3) {
            s = (Integer)this.field_70180_af.func_187225_a(RUNES_3);
        } else if (slot == 4) {
            s = (Integer)this.field_70180_af.func_187225_a(RUNES_4);
        } else if (slot == 5) {
            s = (Integer)this.field_70180_af.func_187225_a(RUNES_5);
        }
        return s;
    }

    public void setRunes(int slot, int rune) {
        if (slot == 1) {
            this.field_70180_af.func_187227_b(RUNES_1, (Object)rune);
        } else if (slot == 2) {
            this.field_70180_af.func_187227_b(RUNES_2, (Object)rune);
        } else if (slot == 3) {
            this.field_70180_af.func_187227_b(RUNES_3, (Object)rune);
        } else if (slot == 4) {
            this.field_70180_af.func_187227_b(RUNES_4, (Object)rune);
        } else if (slot == 5) {
            this.field_70180_af.func_187227_b(RUNES_5, (Object)rune);
        }
    }

    public int getEmptySlot() {
        int i = 0;
        for (int slot = 1; slot < 6; ++slot) {
            if (this.getRunes(slot) != 0) continue;
            i = slot;
            return i;
        }
        return i;
    }

    public int getFillSlot() {
        int i = 0;
        for (int slot = 6; slot > 0; --slot) {
            if (this.getRunes(slot) <= 0) continue;
            i = slot;
            return i;
        }
        return i;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Initial", this.getInitial());
        compound.func_74768_a("State", this.getState());
        compound.func_74757_a("Tame", this.isTamed());
        compound.func_74757_a("Sitting", this.isSitting());
        compound.func_74757_a("Recognition", this.getHomeRecognition());
        compound.func_74772_a("HomePos", this.getHomePoint().func_177986_g());
        compound.func_74768_a("HomeDistance", this.getHomeDistance());
        compound.func_74768_a("Carried", this.getCarried());
        if (this.func_184753_b() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
        if (this.getPartnerId() == null) {
            compound.func_74778_a("PartnerUUID", "");
        } else {
            compound.func_74778_a("PartnerUUID", this.getPartnerId().toString());
        }
        for (int slot = 1; slot < 6; ++slot) {
            compound.func_74768_a("Rune_" + slot, this.getRunes(slot));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String p;
        String o;
        super.func_70037_a(compound);
        this.setInitial(compound.func_74767_n("Initial"));
        this.setState(compound.func_74762_e("State"));
        this.setHomeRecognition(compound.func_74767_n("Recognition"));
        if (compound.func_74764_b("HomePos")) {
            this.setHomePoint(BlockPos.func_177969_a((long)compound.func_74763_f("homePos")));
        }
        this.setHomeDistance(compound.func_74762_e("HomeDistance"));
        this.setCarried(compound.func_74762_e("Carried"));
        if (compound.func_150297_b("OwnerUUID", 8)) {
            o = compound.func_74779_i("OwnerUUID");
        } else {
            String o1 = compound.func_74779_i("Owner");
            o = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)o1);
        }
        if (!o.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(o));
                this.setTamed(true);
            }
            catch (Throwable var4) {
                this.setTamed(false);
            }
        }
        if (compound.func_150297_b("PartnerUUID", 8)) {
            p = compound.func_74779_i("PartnerUUID");
        } else {
            String p1 = compound.func_74779_i("Partner");
            p = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)p1);
        }
        if (!p.isEmpty()) {
            try {
                this.setPartnerId(UUID.fromString(p));
            }
            catch (Throwable p1) {
                // empty catch block
            }
        }
        if (this.aiSit != null) {
            this.aiSit.setSitting(compound.func_74767_n("Sitting"));
        }
        this.setSitting(compound.func_74767_n("Sitting"));
        for (int slot = 1; slot < 6; ++slot) {
            this.setRunes(slot, compound.func_74762_e("Rune_" + slot));
        }
    }

    protected void playTameEffect(boolean play) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!play) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        } else if (id == 7) {
            this.playTameEffect(true);
        } else if (id == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!ConfigHandler.otherGolemAllowDown) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.getOwner() instanceof EntityPlayerMP) {
                this.getOwner().func_145747_a(this.func_110142_aN().func_151521_b());
            }
            super.func_70645_a(cause);
        } else {
            this.setState(1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void func_70636_d() {
        int lagu;
        int sigel;
        int yr;
        super.func_70636_d();
        if (this.isTamed()) {
            this.setInitial(true);
        } else if (!this.getInitial()) {
            // empty if block
        }
        if (this.func_110143_aJ() <= 0.0f && !(this instanceof EntityStandardGolem)) {
            List<EntityLiving> nearEntities = GolemsUtils.getNearbyEntities(this, EntityLiving.class, null, 10.0);
            for (EntityLiving entityObj : nearEntities) {
                if (entityObj == this || entityObj instanceof EntityGolemBase) continue;
                ((EntityLivingBase)entityObj).func_70604_c(null);
                entityObj.func_70624_b(null);
                entityObj.func_70661_as().func_75499_g();
            }
            this.func_70624_b(null);
            this.func_70604_c(null);
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
            if (this instanceof EntityStoneGolem) {
                EntityStoneGolem stoneGolem = (EntityStoneGolem)this;
                if (stoneGolem.isCaptain()) {
                    stoneGolem.setFightingSpirits(0);
                    stoneGolem.setAchievements(0);
                } else if (stoneGolem.getCaptain() != null) {
                    EntityStoneGolem captain = (EntityStoneGolem)stoneGolem.getCaptain();
                    captain.setFightingSpirits(captain.getFightingSpirits() - 1);
                }
            }
        }
        if (this.getState() != 0) {
            if (this.func_110143_aJ() == this.func_110138_aP()) {
                if (ConfigHandler.autoRecovery) {
                    this.setState(0);
                }
            }
            if (ConfigHandler.autoRecoveryTime >= 1) {
                if (this.field_70173_aa % ConfigHandler.autoRecoveryTime == 0) {
                    this.setState(0);
                }
            }
        } else {
            int k;
            int j;
            int i;
            IBlockState iblockstate;
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
        if ((yr = Runes.getRuneInSlot(this, 13)) >= 1) {
            ++this.yrHealingTime;
            if (this.yrHealingTime >= 6000 / yr) {
                this.func_70691_i(1.0f);
                this.yrHealingTime = 0;
            }
        }
        if ((sigel = Runes.getRuneInSlot(this, 16)) >= 1 && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            ++this.sigelHealingTime;
            if (this.sigelHealingTime >= 6000 / sigel) {
                this.func_70691_i(1.0f);
                this.sigelHealingTime = 0;
            }
        }
        if ((lagu = Runes.getRuneInSlot(this, 21)) >= 1 && this.field_70171_ac) {
            List<EntityLiving> nearEntities = GolemsUtils.getNearbyEntities(this, EntityLiving.class, null, 10 * lagu);
            for (EntityLiving entityObj : nearEntities) {
                if (entityObj == this) continue;
                if (entityObj instanceof EntityGolemBase || entityObj instanceof EntityPlayer) {
                    if (!((EntityLivingBase)entityObj).func_70027_ad()) continue;
                    ((EntityLivingBase)entityObj).func_70066_B();
                    continue;
                }
                if (lagu < 5 || !((Entity)entityObj).func_70045_F()) continue;
                ((Entity)entityObj).func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityPlayer owner = (EntityPlayer)this.getOwner();
        if (owner != null) {
            ItemStack itemstack = owner.func_184592_cb();
            if (this.getCarried() >= 1) {
                if (itemstack.func_77973_b() == GolemistItems.PUMPKIN_MEDAL) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    if (!this.updateBlocked) {
                        Vec3d vec3d;
                        if (this.getCarried() == 1) {
                            vec3d = new Vec3d(0.9, 0.0, 0.0).func_178785_b(-owner.field_70177_z * ((float)Math.PI / 180) + 1.5707964f);
                            this.func_70107_b(owner.field_70165_t + vec3d.field_72450_a, owner.field_70163_u + 0.9, owner.field_70161_v + vec3d.field_72449_c);
                        } else if (this.getCarried() == 2) {
                            vec3d = new Vec3d(0.9, 0.0, 0.0).func_178785_b(-owner.field_70177_z * ((float)Math.PI / 180) + 1.5707964f);
                            this.func_70107_b(owner.field_70165_t + vec3d.field_72450_a, owner.field_70163_u + 0.7, owner.field_70161_v + vec3d.field_72449_c);
                        }
                    }
                } else {
                    this.setCarried(0);
                }
            }
        } else {
            this.setCarried(0);
            if (this.func_184218_aH()) {
                this.func_110145_l(this.func_184187_bx());
            }
        }
        int geofu = Runes.getRuneInSlot(this, 7);
        if (geofu >= 1) {
            ++this.beorcMarchantTime;
            if (this.beorcMarchantTime >= 12000) {
                if (this.field_70146_Z.nextInt(100) <= geofu * 2) {
                    EntityVillager villager = new EntityVillager(this.field_70170_p);
                    int x = this.func_180425_c().func_177958_n();
                    int y = this.func_180425_c().func_177956_o();
                    int z = this.func_180425_c().func_177952_p();
                    if (!this.field_70170_p.field_72995_K) {
                        villager.func_70012_b((double)x + 0.2, (double)y, (double)z + 0.2, MathHelper.func_76142_g((float)(this.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                        villager.field_70759_as = villager.field_70177_z;
                        villager.field_70761_aq = villager.field_70177_z;
                        villager.func_70938_b(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)GolemProfessions.GOLEM_MERCHANT));
                        this.field_70170_p.func_72838_d((Entity)villager);
                        villager.func_70642_aH();
                    }
                }
                this.beorcMarchantTime = 0;
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        int daeg;
        int is;
        int ken;
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float daegBonus = 0.0f;
        int ur = Runes.getRuneInSlot(this, 2);
        if (ur >= 1) {
            entityIn.field_70172_ad *= 1 - ur / 10;
        }
        if ((ken = Runes.getRuneInSlot(this, 6)) >= 1) {
            entityIn.func_70015_d(ken * 2);
        }
        if ((is = Runes.getRuneInSlot(this, 11)) >= 1) {
            int t = 10;
            int level = 0;
            if (is >= 3) {
                ++level;
            }
            if (is >= 5) {
                ++level;
            }
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, t * is, level, true, true));
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, t * is, level, true, true));
        }
        if ((daeg = Runes.getRuneInSlot(this, 24)) >= 1 && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            daegBonus = 3.0f * (float)daeg;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.getDamage(this, entityIn)) + daegBonus);
        return flag;
    }

    public double getDamage(EntityGolemBase golem, Entity entityIn) {
        int peorth;
        double d = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int sigel = Runes.getRuneInSlot(this, 16);
        if (sigel >= 1 && this.field_70170_p.func_72935_r() && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            d += (double)sigel * 1.0;
        }
        if ((peorth = Runes.getRuneInSlot(this, 14)) >= 1 && this.field_70146_Z.nextInt(100) <= peorth * 10) {
            d *= 1.5;
        }
        return d;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        int eolh;
        int thorn;
        Entity entityprojectile = source.func_76364_f();
        Entity entity = source.func_76346_g();
        if (this.isTamed() && this.getOwner() == null) {
            return false;
        }
        if (entity == this.getOwner()) {
            return false;
        }
        if (this.getCarried() >= 1 && source == DamageSource.field_76379_h) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getState() != 0) {
            if (entity != null && !(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase) {
                ((EntityLiving)entity).func_70604_c(null);
                ((EntityLiving)entity).func_70624_b(null);
            }
            return false;
        }
        int peorth = Runes.getRuneInSlot(this, 14);
        if (peorth >= 1 && this.field_70146_Z.nextInt(100) <= peorth * 10) {
            return false;
        }
        if (this.aiSit != null) {
            this.aiSit.setSitting(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        if ((thorn = Runes.getRuneInSlot(this, 3)) >= 1 && entity != null) {
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), (float)thorn);
        }
        if ((eolh = Runes.getRuneInSlot(this, 15)) >= 1 && (amount -= (float)eolh) < 1.0f) {
            amount = 1.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        Potion potion = potioneffectIn.func_188419_a();
        return potion != MobEffects.field_76436_u;
    }

    public boolean func_145773_az() {
        return false;
    }

    protected void playItemPickUpSound() {
        this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playChestEquipSound() {
        this.func_184185_a(SoundEvents.field_187584_ax, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playEquipWeaponSound() {
        this.func_184185_a(SoundEvents.field_187698_i, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playShieldBlockSound() {
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playEquipBreakSound() {
        this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public void setSwingingArms(boolean swingingArms) {
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean tamed = this.isTamed();
        boolean sitting = this.isSitting();
        boolean damaged = this.func_110143_aJ() < this.func_110138_aP();
        boolean defeated = this.getState() == 1;
        boolean unique = this instanceof EntityUniqueGolem || this instanceof EntityWolfGolem || this instanceof EntityHorseGolem;
        boolean owner = this.isOwner((EntityLivingBase)player);
        boolean sneaking = player.func_70093_af();
        boolean boreHands = player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b();
        boolean noRemote = !this.field_70170_p.field_72995_K;
        ItemStack itemstackHand = player.func_184586_b(hand);
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        boolean healingItems = GolemsUtils.isHealingItems(itemstackHand);
        boolean bottledItems = GolemsUtils.isBottled(itemstackHand);
        boolean revivalItems = GolemsUtils.isRevivalItems(itemstackHand);
        if (boreHands && !sneaking && noRemote) {
            int x = player.func_180425_c().func_177958_n();
            int y = player.func_180425_c().func_177956_o();
            int z = player.func_180425_c().func_177952_p();
            this.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
            return true;
        }
        if (damaged && healingItems && !player.func_70093_af()) {
            if (noRemote) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstackHand.func_190918_g(1);
                }
                float healAmount = GolemsUtils.getHealingAmount(itemstackHand);
                this.func_70691_i(healAmount);
                if (bottledItems) {
                    ItemStack bottle = new ItemStack(Items.field_151069_bo);
                    if (itemstackHand.func_190926_b()) {
                        player.func_184611_a(hand, bottle);
                    } else if (!player.field_71071_by.func_70441_a(bottle)) {
                        player.func_71019_a(bottle, false);
                    } else if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                    }
                }
                if (this.getState() == 1 && revivalItems) {
                    this.setState(0);
                }
            }
            return true;
        }
        if (tamed) {
            if (owner) {
                if (offHand.func_77973_b() == GolemistItems.PUMPKIN_MEDAL && this.canCarried()) {
                    if (noRemote) {
                        this.setCarried(1);
                    }
                    return true;
                }
                if (!defeated && itemstackHand.func_77973_b() == GolemistItems.PUMPKIN_ROD) {
                    if (noRemote) {
                        this.aiSit.setSitting(!this.isSitting());
                        this.field_70703_bu = false;
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        int ansur = Runes.getRuneInSlot(this, 4);
                        if (ansur >= 1) {
                            this.func_184185_a(SoundEvents.field_193807_ew, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                        }
                    }
                    return true;
                }
                if (sneaking) {
                    if (!unique) {
                        if (itemstackHand.func_77973_b() instanceof RuneBase) {
                            if (noRemote) {
                                int s = this.getEmptySlot();
                                if (s == 0) {
                                    return false;
                                }
                                this.setRunes(s, ((IRune)itemstackHand.func_77973_b()).getRuneNumber());
                                Runes.chengeRune(this, ((IRune)itemstackHand.func_77973_b()).getRuneNumber(), true);
                                if (!player.field_71075_bZ.field_75098_d) {
                                    itemstackHand.func_190918_g(1);
                                }
                            }
                            return true;
                        }
                        if (itemstackHand.func_77973_b() == Items.field_151123_aH) {
                            if (noRemote) {
                                int f = this.getFillSlot();
                                if (f == 0) {
                                    return false;
                                }
                                int r = this.getRunes(f);
                                ItemStack rune = Runes.checkRuneName(this.getRunes(f));
                                this.setRunes(f, 0);
                                Runes.chengeRune(this, r, false);
                                if (!player.field_71075_bZ.field_75098_d) {
                                    itemstackHand.func_190918_g(1);
                                }
                                if (itemstackHand.func_190926_b()) {
                                    player.func_184611_a(hand, rune);
                                } else if (!player.field_71071_by.func_70441_a(rune)) {
                                    player.func_71019_a(rune, false);
                                } else if (player instanceof EntityPlayerMP) {
                                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                                }
                            }
                            return true;
                        }
                    }
                    if (noRemote) {
                        this.aiSit.setSitting(!this.isSitting());
                        this.field_70703_bu = false;
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        int ansur = Runes.getRuneInSlot(this, 4);
                        if (ansur >= 1) {
                            this.func_184185_a(SoundEvents.field_193807_ew, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                        }
                    }
                    return true;
                }
            }
        } else if (this.tamingItem(itemstackHand)) {
            if (noRemote) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstackHand.func_190918_g(1);
                }
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.setTamedBy(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.aiSit.setSitting(true);
                    this.playTameEffect(true);
                    this.func_70606_j(this.func_110138_aP());
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (defeated && !unique && (owner || !tamed) && mainHand.func_77973_b() == GolemistItems.PUMPKIN_ROD && offHand.func_77973_b() == Items.field_151069_bo) {
            if (noRemote) {
                ItemStack soul = new ItemStack(GolemistItems.BOTTLED_PUMPKIN_SOUL);
                if (!player.field_71075_bZ.field_75098_d) {
                    offHand.func_190918_g(1);
                }
                if (itemstackHand.func_190926_b()) {
                    player.func_184611_a(hand, soul);
                } else if (!player.field_71071_by.func_70441_a(soul)) {
                    player.func_71019_a(soul, false);
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
                this.func_70106_y();
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean tamingItem(ItemStack itemstack) {
        int enumflowercolor;
        return itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150328_O) && (enumflowercolor = itemstack.func_77952_i()) == 0;
    }

    public void func_70108_f(Entity entityIn) {
        if (this.getOwner() != null) {
            int lagu = Runes.getRuneInSlot(this, 21);
            if (lagu >= 1 && entityIn.func_70027_ad()) {
                entityIn.func_70066_B();
            }
            if (lagu >= 2 && entityIn.func_70045_F()) {
                entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)lagu);
            }
        }
        if (!(entityIn instanceof EntityPlayer)) {
            super.func_70108_f(entityIn);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), EntitySelectors.func_188442_a((Entity)this));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_180263_c("maxEntityCramming");
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (entity == this.getOwner()) continue;
                this.func_82167_n(entity);
            }
        }
    }
}

