/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import javax.annotation.Nullable;
import lily.golemist.common.entity.EntityGolemBase;
import lily.golemist.common.entity.EntityUniqueGolem;
import lily.golemist.common.entity.ai.GolemAIDown;
import lily.golemist.common.entity.ai.GolemAIFollowOwner;
import lily.golemist.common.entity.ai.GolemAIFollowPartner;
import lily.golemist.common.entity.ai.GolemAISit;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHorseGolem
extends EntityGolemBase {
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(EntityHorseGolem.class, (DataSerializer)DataSerializers.field_187191_a);
    private int eatingCounter;
    private int openMouthCounter;
    private int jumpRearingCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean horseJumping;
    protected ContainerHorseChest horseChest;
    protected int temper;
    protected float jumpPower;
    private boolean allowStandSliding;
    private float headLean;
    private float prevHeadLean;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;
    protected boolean canGallop = true;
    protected int gallopTime;
    protected GolemAIFollowPartner aiFollowPartner;

    public EntityHorseGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.55f);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        this.aiDown = new GolemAIDown(this);
        this.aiSwim = new EntityAISwimming((EntityLiving)this);
        this.aiSit = new GolemAISit(this);
        this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2);
        this.aiFollowPartner = new GolemAIFollowPartner(this, 2.0, 10.0f, 1.5f);
        this.aiFollowOwner = new GolemAIFollowOwner(this, 1.0, 10.0f, 2.0f);
        this.aiWander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.aiWatch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.aiLook = new EntityAILookIdle((EntityLiving)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowPartner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
    }

    @Override
    protected void func_70619_bc() {
        EntityUniqueGolem partner = (EntityUniqueGolem)this.getPartner();
        EntityPlayer owner = (EntityPlayer)this.getOwner();
        if (this.getState() != 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiDown);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiLook);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
            this.field_70126_B = this.field_70177_z;
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiDown);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiLook);
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.aiWander);
            if (partner != null && owner != null && partner.getState() == 0) {
                if (partner.getState() == 0) {
                    this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowPartner);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowOwner);
                    if (owner.func_184218_aH() && !partner.func_184218_aH()) {
                        this.func_70661_as().func_75497_a((Entity)partner, 1.5);
                    }
                } else {
                    this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowPartner);
                }
            } else {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowPartner);
            }
        }
        super.func_70619_bc();
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (this.getOwner() != null && this.getPartner() != null && this.getOwner().func_184218_aH() && !this.getPartner().func_184218_aH() && entityIn instanceof EntityUniqueGolem && entityIn == this.getPartner()) {
            entityIn.func_184220_m((Entity)this);
        }
    }

    protected boolean getHorseWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & p_110233_1_) != 0;
    }

    protected void setHorseWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        if (p_110208_2_) {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public float getHorseSize() {
        return 0.5f;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return super.func_184652_a(player);
    }

    protected void func_142017_o(float p_142017_1_) {
        if (p_142017_1_ > 6.0f && this.isEatingHaystack()) {
            this.setEatingHaystack(false);
        }
    }

    public boolean isEatingHaystack() {
        return this.getHorseWatchableBoolean(16);
    }

    public boolean isRearing() {
        return this.getHorseWatchableBoolean(32);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        return this.func_184207_aI() && entity != null && this.func_184215_y(entity) ? false : super.func_70097_a(source, amount);
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    private void eatingHorse() {
        this.openHorseMouth();
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187711_cp, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i;
        if (distance > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((i = MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier))) > 0) {
            this.func_70097_a(DamageSource.field_76379_h, i);
            if (this.func_184207_aI()) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, (float)i);
                }
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v));
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() != Material.field_151579_a && !this.func_174814_R()) {
                SoundType soundtype = block.func_185467_w();
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        this.openHorseMouth();
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.openHorseMouth();
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.makeHorseRear();
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        this.openHorseMouth();
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.makeHorseRear();
        }
        return null;
    }

    @Nullable
    protected SoundEvent getAngrySound() {
        this.openHorseMouth();
        this.makeHorseRear();
        return null;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (!blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            SoundType soundtype = blockIn.func_185467_w();
            if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                soundtype = Blocks.field_150431_aC.func_185467_w();
            }
            if (this.func_184207_aI() && this.canGallop) {
                ++this.gallopTime;
                if (this.gallopTime > 5 && this.gallopTime % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopTime <= 5) {
                    this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                }
            } else if (soundtype == SoundType.field_185848_a) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            } else {
                this.func_184185_a(SoundEvents.field_187729_cv, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    protected void playGallopSound(SoundType p_190680_1_) {
        this.func_184185_a(SoundEvents.field_187714_cq, p_190680_1_.func_185843_a() * 0.15f, p_190680_1_.func_185847_b());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3249999940395355);
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() || this.isEatingHaystack() || this.isRearing();
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184614_ca();
        ItemStack itemstack2 = player.func_184592_cb();
        EntityGolemBase partner = (EntityGolemBase)this.getPartner();
        if (this.isTamed() && player == this.getOwner()) {
            if (!itemstack.func_190926_b()) {
                // empty if block
            }
            if (player.func_70093_af()) {
                if (partner != null && partner.func_184223_x((Entity)this)) {
                    partner.func_184210_p();
                    return true;
                }
            } else if (partner != null) {
                partner.func_184220_m((Entity)this);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.canEatGrass()) {
            if (!this.isEatingHaystack() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) - 1, MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == Blocks.field_150349_c) {
                this.setEatingHaystack(true);
            }
            if (this.isEatingHaystack() && ++this.eatingCounter > 50) {
                this.eatingCounter = 0;
                this.setEatingHaystack(false);
            }
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.setHorseWatchableBoolean(64, false);
        }
        if (this.func_184186_bw()) {
            this.setRearing(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingHaystack()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.prevHeadLean = this.headLean = 0.0f;
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getHorseWatchableBoolean(64)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    private void openHorseMouth() {
        if (!this.field_70170_p.field_72995_K) {
            this.openMouthCounter = 1;
            this.setHorseWatchableBoolean(64, true);
        }
    }

    public void setEatingHaystack(boolean p_110227_1_) {
        this.setHorseWatchableBoolean(16, p_110227_1_);
    }

    public void setRearing(boolean rearing) {
        if (rearing) {
            this.setEatingHaystack(false);
        }
        this.setHorseWatchableBoolean(32, rearing);
    }

    private void makeHorseRear() {
        if (this.func_184186_bw()) {
            this.setRearing(true);
        }
    }

    public void makeMad() {
        this.makeHorseRear();
        SoundEvent soundevent = this.getAngrySound();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
                this.gallopTime = 0;
            }
            if (this.field_70122_E && this.isRearing() && !this.allowStandSliding) {
                strafe = 0.0f;
                forward = 0.0f;
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 2.0f);
                super.func_191986_a(strafe, vertical, forward);
            } else if (entitylivingbase instanceof EntityGolemBase) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E) {
                // empty if block
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public static void registerFixesEntityHorseGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityHorseGolem.class);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    @SideOnly(value=Side.CLIENT)
    public float getGrassEatingAmount(float p_110258_1_) {
        return this.prevHeadLean + (this.headLean - this.prevHeadLean) * p_110258_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRearingAmount(float p_110223_1_) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * p_110223_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMouthOpennessAngle(float p_110201_1_) {
        return this.prevMouthOpenness + (this.mouthOpenness - this.prevMouthOpenness) * p_110201_1_;
    }

    @Override
    protected void playChestEquipSound() {
        this.func_184185_a(SoundEvents.field_187696_ck, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
        float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = 0.7f * this.prevRearingAmount;
        float f2 = 0.15f * this.prevRearingAmount;
        passenger.func_70107_b(this.field_70165_t + (double)(f1 * f3), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() + (double)f2, this.field_70161_v - (double)(f1 * f));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70146_Z.nextInt(5) == 0) {
            // empty if block
        }
        return livingdata;
    }
}

