/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import java.util.List;
import javax.annotation.Nullable;
import lily.golemist.GolemistItems;
import lily.golemist.common.entity.EntityGolemBase;
import lily.golemist.common.entity.ai.GolemAIDown;
import lily.golemist.common.entity.ai.GolemAIFollowOwner;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtByTarget;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtTarget;
import lily.golemist.common.entity.ai.GolemAISit;
import lily.golemist.common.entity.ai.IronGolemAIProvoke;
import lily.golemist.util.handlers.ConfigHandler;
import lily.golemist.util.handlers.Runes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;

public class EntityIronGolem
extends EntityGolemBase {
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityIronGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PROVOKE_ABILITY = EntityDataManager.func_187226_a(EntityIronGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> PROVOKE_DURATION = EntityDataManager.func_187226_a(EntityIronGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityIronGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SIDE_SHIELD = EntityDataManager.func_187226_a(EntityIronGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SIDE_SHIELD_DURABILITY = EntityDataManager.func_187226_a(EntityIronGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ENEMY_DETECTOR = EntityDataManager.func_187226_a(EntityIronGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityLivingBase targetedEntity;
    private int clientProvokeTime;
    private int tickCounter;
    private IronGolemAIProvoke aiProvoke;

    public EntityIronGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.35f);
    }

    @Override
    protected void func_184651_r() {
        this.aiDown = new GolemAIDown(this);
        this.aiSwim = new EntityAISwimming((EntityLiving)this);
        this.aiSit = new GolemAISit(this);
        this.aiMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.aiProvoke = new IronGolemAIProvoke(this);
        this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2);
        this.aiFollowOwner = new GolemAIFollowOwner(this, 1.0, 10.0f, 2.0f);
        this.aiWander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.aiWatch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.aiLook = new EntityAILookIdle((EntityLiving)this);
        this.aiOwnerHurtByTarget = new GolemAIOwnerHurtByTarget(this);
        this.aiOwnerHurtTarget = new GolemAIOwnerHurtTarget(this);
        this.aiHurtByTarget = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]);
        this.aiAttackSlime = new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiMelee);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(PROVOKE_ABILITY, (Object)false);
        this.field_70180_af.func_187214_a(PROVOKE_DURATION, (Object)80);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(SIDE_SHIELD, (Object)false);
        this.field_70180_af.func_187214_a(SIDE_SHIELD_DURABILITY, (Object)0);
        this.field_70180_af.func_187214_a(ENEMY_DETECTOR, (Object)false);
    }

    @Override
    protected void func_70619_bc() {
        if (this.getState() != 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiDown);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiLook);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
            this.field_70126_B = this.field_70177_z;
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtByTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiHurtByTarget);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiDown);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiLook);
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.aiWander);
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiOwnerHurtByTarget);
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiOwnerHurtTarget);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.aiHurtByTarget);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.field_70715_bh.func_75776_a(5, (EntityAIBase)this.aiAttackSlime);
            } else {
                this.field_70715_bh.func_85156_a((EntityAIBase)this.aiAttackSlime);
            }
            if (this.getProvokeAbility()) {
                if (this.func_70638_az() != null && !(this.func_70638_az() instanceof EntityGolemBase)) {
                    EntityLivingBase enemy = this.func_70638_az();
                    EntityLivingBase targeted = ((EntityLiving)enemy).func_70638_az();
                    int nied = Runes.getRuneInSlot(this, 10);
                    if (nied >= 1) {
                        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMelee);
                        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiProvoke);
                    } else {
                        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiProvoke);
                        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiMelee);
                    }
                } else {
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiProvoke);
                    this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiMelee);
                }
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.ironGolemHealth);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.ironGolemBaseAttack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(ConfigHandler.ironGolemBaseArmor);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(ConfigHandler.ironGolemBaseArmor);
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public boolean getProvokeAbility() {
        return (Boolean)this.field_70180_af.func_187225_a(PROVOKE_ABILITY);
    }

    public int getProvokeDuration() {
        return (Integer)this.field_70180_af.func_187225_a(PROVOKE_DURATION);
    }

    public boolean getSideShield() {
        return (Boolean)this.field_70180_af.func_187225_a(SIDE_SHIELD);
    }

    public int getSideShieldDurability() {
        return (Integer)this.field_70180_af.func_187225_a(SIDE_SHIELD_DURABILITY);
    }

    public boolean getEnemyDetector() {
        return (Boolean)this.field_70180_af.func_187225_a(ENEMY_DETECTOR);
    }

    @Nullable
    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientProvokeTime = 0;
            this.targetedEntity = null;
        }
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.ironGolemBaseAttack + 1.0);
    }

    public void hasProvokeAbility(boolean p_ability) {
        this.field_70180_af.func_187227_b(PROVOKE_ABILITY, (Object)p_ability);
    }

    public void setProvokeDuration(int p_duration) {
        this.field_70180_af.func_187227_b(PROVOKE_DURATION, (Object)p_duration);
    }

    public void hasSideShield(boolean side_shield) {
        this.field_70180_af.func_187227_b(SIDE_SHIELD, (Object)side_shield);
    }

    public void setSideShieldDurability(int side_durability) {
        this.field_70180_af.func_187227_b(SIDE_SHIELD_DURABILITY, (Object)side_durability);
    }

    public void setEnemyDetector(boolean e_detector) {
        this.field_70180_af.func_187227_b(ENEMY_DETECTOR, (Object)e_detector);
    }

    public void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public static void registerFixesIronGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityIronGolem.class);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74757_a("Provoke", this.getProvokeAbility());
        compound.func_74768_a("ProvokeDuration", this.getProvokeDuration());
        compound.func_74757_a("SideShield", this.getSideShield());
        compound.func_74768_a("SideShieldDurability", this.getSideShieldDurability());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        this.hasProvokeAbility(compound.func_74767_n("Provoke"));
        this.setProvokeDuration(compound.func_74762_e("ProvokeDuration"));
        this.hasSideShield(compound.func_74767_n("SideShield"));
        this.setSideShieldDurability(compound.func_74762_e("SideShieldDurability"));
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184614_ca();
        ItemStack itemstack2 = player.func_184592_cb();
        if (this.isTamed() && !itemstack.func_190926_b() && player.func_70093_af()) {
            if (itemstack.func_77973_b() == GolemistItems.GUARDIAN_EYE) {
                if (!this.getProvokeAbility()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.hasProvokeAbility(true);
                        this.playChestEquipSound();
                        return true;
                    }
                }
                return false;
            }
            if (itemstack.func_77973_b() == Items.field_185159_cQ && itemstack2.func_77973_b() == Items.field_185159_cQ) {
                if (!this.getSideShield()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        itemstack2.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.hasSideShield(true);
                        this.setSideShieldDurability(672);
                        this.playChestEquipSound();
                        return true;
                    }
                }
                return false;
            }
            if (itemstack.func_77973_b() == Items.field_151061_bv) {
                if (!this.getEnemyDetector()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.setEnemyDetector(true);
                        this.playChestEquipSound();
                        return true;
                    }
                }
                return false;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getSideShield() && this.getSideShieldDurability() <= 0) {
            this.hasSideShield(false);
            this.playEquipBreakSound();
        }
        if (this.func_70027_ad() && this.getState() == 0) {
            this.func_70066_B();
        }
        if (this.getEnemyDetector() && this.func_70638_az() == null) {
            List<EntityLiving> nearEntities = this.getNearbyEntities(EntityLiving.class, null, 20.0);
            for (EntityLiving entityObj : nearEntities) {
                int mann;
                if (this.func_70638_az() != null || entityObj instanceof EntityPlayer) continue;
                EntityLiving entity = entityObj;
                if (entity.func_70638_az() == this.getOwner()) {
                    this.func_70624_b((EntityLivingBase)entity);
                    continue;
                }
                int nied = Runes.getRuneInSlot(this, 10);
                if (nied < 1 || (mann = Runes.getRuneInSlot(this, 20)) < 1) continue;
                if (entity.func_70638_az() instanceof EntityGolemBase) {
                    int mann2;
                    EntityGolemBase golem = (EntityGolemBase)entity.func_70638_az();
                    if (golem instanceof EntityIronGolem || golem.getOwner() == null || this.getOwner() != golem.getOwner() || (mann2 = Runes.getRuneInSlot(golem, 20)) < 1) continue;
                    this.func_70624_b((EntityLivingBase)entity);
                    continue;
                }
                if (mann >= 1 && entity.func_70638_az() instanceof EntityVillager) {
                    this.func_70624_b((EntityLivingBase)entity);
                    continue;
                }
                int feoh = Runes.getRuneInSlot(this, 1);
                if (feoh < 1 || !(entity.func_70638_az() instanceof EntityAnimal)) continue;
                this.func_70624_b((EntityLivingBase)entity);
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.getSideShield()) {
            this.setSideShieldDurability(this.getSideShieldDurability() - 1);
            this.playShieldBlockSound();
        }
        return super.func_70652_k(entityIn);
    }

    public double getDamage() {
        double d = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.getSideShield()) {
            d += 0.5;
        }
        return d;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (this.getState() == 0 && this.getSideShield() && entity != null) {
            double d1 = this.field_70177_z;
            double d2 = entity.field_70177_z;
            double d3 = d1 - d2;
            if (d3 < 0.0) {
                d3 *= -1.0;
            }
            if (d3 <= 135.0 && d3 >= 315.0) {
                this.setSideShieldDurability(this.getSideShieldDurability() - (int)amount);
                this.playShieldBlockSound();
                this.field_70172_ad = this.field_70771_an;
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public float func_70047_e() {
        return 0.8f;
    }

    public int func_70641_bl() {
        return 3;
    }

    public void func_70074_a(EntityLivingBase target) {
        if (this.getPowered()) {
            ItemStack stack;
            if (target instanceof EntitySkeleton) {
                stack = new ItemStack(Items.field_151144_bL, 1, 0);
                this.func_70099_a(stack, 0.0f);
            }
            if (target instanceof EntityWitherSkeleton) {
                stack = new ItemStack(Items.field_151144_bL, 1, 1);
                this.func_70099_a(stack, 0.0f);
            }
            if (target instanceof EntityZombie) {
                stack = new ItemStack(Items.field_151144_bL, 1, 2);
                this.func_70099_a(stack, 0.0f);
            }
            if (target instanceof EntityCreeper) {
                stack = new ItemStack(Items.field_151144_bL, 1, 4);
                this.func_70099_a(stack, 0.0f);
            }
        }
    }

    public float getProvokeAnimationScale(float p_175477_1_) {
        return ((float)this.clientProvokeTime + p_175477_1_) / (float)this.getProvokeDuration();
    }

    public <T extends Entity> List<T> getNearbyEntities(Class<? extends T> clazz, Class filterClass, double range) {
        return this.func_130014_f_().func_175647_a(clazz, this.func_174813_aQ().func_72314_b(range, range, range), entity -> {
            if (filterClass == null) {
                return true;
            }
            return filterClass.isAssignableFrom(entity.getClass());
        });
    }
}

