/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import lily.golemist.common.entity.EntityGolemBase;
import lily.golemist.common.entity.ai.GolemAIDown;
import lily.golemist.common.entity.ai.GolemAIFollowOwner;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtByTarget;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtTarget;
import lily.golemist.common.entity.ai.GolemAISit;
import lily.golemist.util.handlers.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;

public class EntitySandstoneGolem
extends EntityGolemBase {
    private static final DataParameter<Integer> ARMS = EntityDataManager.func_187226_a(EntitySandstoneGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GUNPOWDERS = EntityDataManager.func_187226_a(EntitySandstoneGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> TRIGGER = EntityDataManager.func_187226_a(EntitySandstoneGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private int onSandHealingTick = 0;

    public EntitySandstoneGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.35f);
    }

    @Override
    protected void func_184651_r() {
        this.aiDown = new GolemAIDown(this);
        this.aiSwim = new EntityAISwimming((EntityLiving)this);
        this.aiSit = new GolemAISit(this);
        this.aiMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2);
        this.aiFollowOwner = new GolemAIFollowOwner(this, 1.0, 10.0f, 2.0f);
        this.aiWander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.aiWatch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.aiLook = new EntityAILookIdle((EntityLiving)this);
        this.aiOwnerHurtByTarget = new GolemAIOwnerHurtByTarget(this);
        this.aiOwnerHurtTarget = new GolemAIOwnerHurtTarget(this);
        this.aiHurtByTarget = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]);
        this.aiAttackSlime = new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiMelee);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ARMS, (Object)2);
        this.field_70180_af.func_187214_a(GUNPOWDERS, (Object)0);
        this.field_70180_af.func_187214_a(TRIGGER, (Object)false);
    }

    @Override
    protected void func_70619_bc() {
        if (this.getState() != 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiDown);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiLook);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
            this.field_70126_B = this.field_70177_z;
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtByTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiHurtByTarget);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiDown);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiLook);
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.aiWander);
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiOwnerHurtByTarget);
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiOwnerHurtTarget);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.aiHurtByTarget);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.field_70715_bh.func_75776_a(5, (EntityAIBase)this.aiAttackSlime);
            } else {
                this.field_70715_bh.func_85156_a((EntityAIBase)this.aiAttackSlime);
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.40000001192092893);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.sandstoneGolemHealth);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.sandstoneGolemBaseAttack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(ConfigHandler.sandstoneGolemBaseArmor);
    }

    public int getArms() {
        return (Integer)this.field_70180_af.func_187225_a(ARMS);
    }

    public void setArms(int arms) {
        this.field_70180_af.func_187227_b(ARMS, (Object)arms);
    }

    public int getGunpowders() {
        return (Integer)this.field_70180_af.func_187225_a(GUNPOWDERS);
    }

    public void setGunpowders(int gunpowders) {
        this.field_70180_af.func_187227_b(GUNPOWDERS, (Object)gunpowders);
    }

    public boolean getTrigger() {
        return (Boolean)this.field_70180_af.func_187225_a(TRIGGER);
    }

    public void hasTrigger(boolean trigger) {
        this.field_70180_af.func_187227_b(TRIGGER, (Object)trigger);
    }

    public static void registerFixesSandstoneGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySandstoneGolem.class);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Arms", this.getArms());
        compound.func_74768_a("Gunpowders", this.getGunpowders());
        compound.func_74757_a("Trigger", this.getTrigger());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setArms(compound.func_74762_e("Arms"));
        this.setGunpowders(compound.func_74762_e("Gunpowders"));
        this.hasTrigger(compound.func_74767_n("Trigger"));
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184614_ca();
        ItemStack itemstack2 = player.func_184592_cb();
        if (this.isTamed() && !itemstack.func_190926_b() && player.func_70093_af()) {
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150430_aB)) {
                if (!this.getTrigger()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.hasTrigger(true);
                        this.playChestEquipSound();
                        return true;
                    }
                }
                return false;
            }
            if (itemstack.func_77973_b() == Items.field_151016_H && this.getArms() == 2) {
                if (this.getGunpowders() < 1) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.setGunpowders(this.getGunpowders() + 1);
                        this.playChestEquipSound();
                        return true;
                    }
                }
                return false;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        Block underBlock = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
        if (underBlock == Blocks.field_150354_m) {
            ++this.onSandHealingTick;
            if (this.onSandHealingTick >= ConfigHandler.sandstoneGolemHealTicks) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(1.0f);
                } else if (this.getArms() < 2) {
                    this.setArms(2);
                }
                this.onSandHealingTick = 0;
            }
        }
        if (this.getState() == 0 && this.func_70027_ad()) {
            this.func_70066_B();
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    @Override
    public double getDamage(EntityGolemBase golem, Entity entityIn) {
        double d = super.getDamage(this, entityIn);
        if (this.getTrigger() && this.getGunpowders() >= 1) {
            d += 10.0;
            this.setArms(1);
            this.setGunpowders(this.getGunpowders() - 1);
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, true);
        }
        return d;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (this.getState() == 0) {
            // empty if block
        }
        return super.func_70097_a(source, amount);
    }

    public float func_70047_e() {
        return 0.8f;
    }

    public int func_70641_bl() {
        return 3;
    }
}

