/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import javax.annotation.Nullable;
import lily.golemist.common.entity.EntityGolemBase;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtByTarget;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtTarget;
import lily.golemist.util.handlers.ConfigHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityStandardGolem
extends EntityGolemBase {
    private static final DataParameter<Integer> QUALITY = EntityDataManager.func_187226_a(EntityStandardGolem.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityStandardGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.35f);
    }

    @Override
    protected void func_184651_r() {
        this.aiMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiMelee);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new GolemAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new GolemAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(QUALITY, (Object)0);
    }

    @Override
    protected void func_70619_bc() {
        BlockPos homePoint = this.getHomePoint();
        if (--this.homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
            if (homePoint == null) {
                this.func_110177_bN();
            } else {
                this.func_175449_a(homePoint, this.getHomeDistance());
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.standardGolemHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.standardGolemBaseAttack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(ConfigHandler.standardGolemBaseArmor);
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int upperQualityChanceBonus = this.field_70170_p.func_175659_aa().func_151525_a() * ConfigHandler.upperQualityChanceBonus;
        boolean loop = true;
        int i = 0;
        while (true) {
            if (i >= ConfigHandler.upperQualitylimit) break;
            if (this.field_70146_Z.nextInt(100) < ConfigHandler.upperQualityChance + upperQualityChanceBonus && loop) {
                this.setQuality(this.getQuality() + 1);
            } else {
                loop = false;
            }
            ++i;
        }
        double healthBonus = ConfigHandler.standradGolemHealthBonus * (double)this.getQuality();
        double speedBonus = ConfigHandler.standradGolemSpeedBonus * (double)this.getQuality();
        double attackBonus = ConfigHandler.standardGolemAttackBonus * (double)this.getQuality();
        double armorBonus = ConfigHandler.standardGolemArmorBonus * (double)this.getQuality();
        double knockbackResistanceBonus = ConfigHandler.standardGolemKnockbackResistanceBonus * (double)this.getQuality();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.standardGolemHealth + healthBonus);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2 + speedBonus);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.standardGolemBaseAttack + attackBonus);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(ConfigHandler.standardGolemBaseArmor + armorBonus);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0 + knockbackResistanceBonus);
        return livingdata;
    }

    public int getQuality() {
        return (Integer)this.field_70180_af.func_187225_a(QUALITY);
    }

    public void setQuality(int quality) {
        this.field_70180_af.func_187227_b(QUALITY, (Object)quality);
    }

    public static void registerFixesStandardGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityStandardGolem.class);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Quality", this.getQuality());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setQuality(compound.func_74762_e("Quality"));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    public double getDamage() {
        double d = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return d;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }
}

