/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import lily.golemist.common.entity.EntityGolemBase;
import lily.golemist.common.entity.ai.GolemAIDown;
import lily.golemist.common.entity.ai.GolemAIFollowOwner;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtByTarget;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtTarget;
import lily.golemist.common.entity.ai.GolemAISit;
import lily.golemist.common.entity.ai.StoneGolemAIFollowCaptain;
import lily.golemist.util.handlers.ConfigHandler;
import lily.golemist.util.handlers.Runes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityStoneGolem
extends EntityGolemBase {
    private static final DataParameter<Integer> RANK = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ACHIEVEMENTS = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FIGHTING_SPIRITS = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> CAPTAIN_UNIQUE_ID = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> CAPTAIN = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MEMBERS = EntityDataManager.func_187226_a(EntityStoneGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected StoneGolemAIFollowCaptain aiFollowCaptain;

    public EntityStoneGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.35f);
    }

    @Override
    protected void func_184651_r() {
        this.aiDown = new GolemAIDown(this);
        this.aiSwim = new EntityAISwimming((EntityLiving)this);
        this.aiSit = new GolemAISit(this);
        this.aiMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2);
        this.aiFollowOwner = new GolemAIFollowOwner(this, 1.0, 10.0f, 2.0f);
        this.aiFollowCaptain = new StoneGolemAIFollowCaptain(this, 1.0, 10.0f, 2.0f);
        this.aiWander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.aiWatch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.aiLook = new EntityAILookIdle((EntityLiving)this);
        this.aiOwnerHurtByTarget = new GolemAIOwnerHurtByTarget(this);
        this.aiOwnerHurtTarget = new GolemAIOwnerHurtTarget(this);
        this.aiHurtByTarget = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]);
        this.aiAttackSlime = new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, false);
        this.aiAttackMob = new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiMelee);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RANK, (Object)1);
        this.field_70180_af.func_187214_a(ACHIEVEMENTS, (Object)0);
        this.field_70180_af.func_187214_a(FIGHTING_SPIRITS, (Object)0);
        this.field_70180_af.func_187214_a(CAPTAIN_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(CAPTAIN, (Object)true);
        this.field_70180_af.func_187214_a(MEMBERS, (Object)0);
    }

    @Override
    protected void func_70619_bc() {
        if (this.getState() != 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiDown);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiLook);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
            this.field_70126_B = this.field_70177_z;
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtByTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiHurtByTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiAttackMob);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiDown);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiLook);
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.aiWander);
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiOwnerHurtByTarget);
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiOwnerHurtTarget);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.aiHurtByTarget);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.field_70715_bh.func_75776_a(5, (EntityAIBase)this.aiAttackSlime);
            } else {
                this.field_70715_bh.func_85156_a((EntityAIBase)this.aiAttackSlime);
            }
            if (this.getOwner() != null) {
                this.field_70715_bh.func_75776_a(5, (EntityAIBase)this.aiAttackMob);
            }
            if (this.isCaptain() || this.getCaptain() == null) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiOwnerHurtByTarget);
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiOwnerHurtTarget);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowCaptain);
            } else {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowCaptain);
                this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtByTarget);
                this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtTarget);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowOwner);
            }
            if (this.isCaptain()) {
                int rank = this.getRank();
                if (rank >= 2 && this.func_70638_az() != null) {
                    this.field_70159_w /= 4.0;
                    this.field_70179_y /= 4.0;
                }
                if (rank >= 3) {
                    List<EntityMob> nearEntities = this.getNearbyEntities(EntityMob.class, null, 20.0);
                    float targetHealth = 0.0f;
                    float lastTargetHealth = 0.0f;
                    EntityMob comparisonTarget = null;
                    EntityMob target = null;
                    Iterator<EntityMob> iterator = nearEntities.iterator();
                    while (iterator.hasNext()) {
                        EntityMob entityObj;
                        comparisonTarget = entityObj = iterator.next();
                        if (lastTargetHealth > 0.0f) {
                            targetHealth = comparisonTarget.func_110143_aJ();
                            if (!(targetHealth < lastTargetHealth) || !this.func_70685_l((Entity)comparisonTarget)) continue;
                            lastTargetHealth = targetHealth;
                            target = comparisonTarget;
                            continue;
                        }
                        lastTargetHealth = comparisonTarget.func_110143_aJ();
                    }
                    if (target != null) {
                        this.func_70624_b((EntityLivingBase)target);
                    }
                }
            } else if (this.getCaptain() != null) {
                int ansur;
                EntityStoneGolem captain = (EntityStoneGolem)this.getCaptain();
                if (this.func_70638_az() != null && captain.func_70638_az() == null && (ansur = Runes.getRuneInSlot(this, 4)) >= 1) {
                    this.func_184185_a(SoundEvents.field_193807_ew, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    captain.func_70624_b(this.func_70638_az());
                }
                if (captain.func_70638_az() != null) {
                    this.func_70624_b(captain.func_70638_az());
                } else if (captain.func_70643_av() != null) {
                    this.func_70604_c(captain.func_70643_av());
                }
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.stoneGolemHealth);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.stoneGolemBaseAttack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(ConfigHandler.stoneGolemBaseArmor);
    }

    public int getRank() {
        return (Integer)this.field_70180_af.func_187225_a(RANK);
    }

    public int getAchievements() {
        return (Integer)this.field_70180_af.func_187225_a(ACHIEVEMENTS);
    }

    public int getFightingSpirits() {
        return (Integer)this.field_70180_af.func_187225_a(FIGHTING_SPIRITS);
    }

    @Nullable
    public UUID getCaptainId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(CAPTAIN_UNIQUE_ID)).orNull();
    }

    @Nullable
    public EntityLivingBase getCaptain() {
        try {
            UUID uuid = this.getCaptainId();
            if (uuid != null) {
                EntityPlayer player = this.field_70170_p.func_152378_a(uuid);
                if (player != null) {
                    return player;
                }
                EntityLivingBase entity = EntityStoneGolem.getEntityUUID(uuid, this.field_70170_p);
                if (entity != null) {
                    return entity;
                }
                return null;
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isCaptain() {
        return (Boolean)this.field_70180_af.func_187225_a(CAPTAIN);
    }

    public int getMembers() {
        return (Integer)this.field_70180_af.func_187225_a(MEMBERS);
    }

    public void setRank(int rank) {
        this.field_70180_af.func_187227_b(RANK, (Object)rank);
    }

    public void setAchievements(int achievements) {
        this.field_70180_af.func_187227_b(ACHIEVEMENTS, (Object)achievements);
    }

    public void setFightingSpirits(int fighting_spirits) {
        this.field_70180_af.func_187227_b(FIGHTING_SPIRITS, (Object)fighting_spirits);
    }

    public void setCaptainId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(CAPTAIN_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public void setCaptain(boolean captain) {
        this.field_70180_af.func_187227_b(CAPTAIN, (Object)captain);
    }

    public void setMembers(int members) {
        this.field_70180_af.func_187227_b(MEMBERS, (Object)members);
    }

    public static void registerFixesStoneGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityStoneGolem.class);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Rank", this.getRank());
        compound.func_74768_a("Achievements", this.getAchievements());
        compound.func_74768_a("FightingSpirits", this.getFightingSpirits());
        if (this.getCaptainId() == null) {
            compound.func_74778_a("CaptainUUID", "");
        } else {
            compound.func_74778_a("CaptainUUID", this.getCaptainId().toString());
        }
        compound.func_74757_a("Captain", this.isCaptain());
        compound.func_74768_a("Members", this.getMembers());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        this.setRank(compound.func_74762_e("Rank"));
        this.setAchievements(compound.func_74762_e("Achievements"));
        this.setFightingSpirits(compound.func_74762_e("FightingSpirits"));
        if (compound.func_150297_b("CaptainUUID", 8)) {
            s = compound.func_74779_i("CaptainUUID");
        } else {
            String s1 = compound.func_74779_i("Captain");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setCaptainId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setCaptain(compound.func_74767_n("Captain"));
        this.setMembers(compound.func_74762_e("Members"));
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        return livingdata;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        EntityStoneGolem captain;
        super.func_70636_d();
        if (this.getCaptain() != null && (captain = (EntityStoneGolem)this.getCaptain()).isTamed() && !this.isTamed()) {
            this.setTamedBy((EntityPlayer)captain.getOwner());
            this.playTameEffect(true);
        }
        if (this.func_70027_ad() && this.getState() == 0) {
            this.func_70066_B();
        }
        if (this.isCaptain()) {
            if (this.getFightingSpirits() < ConfigHandler.upperFightingSpiritLimit) {
                int f = this.getFightingSpirits();
                int a = this.getAchievements();
                int r = ConfigHandler.increaseFightingSpiritiRatio;
                if ((f + 1) * r <= a) {
                    this.setFightingSpirits(this.getFightingSpirits() + 1);
                    this.setAchievements(0);
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    public double getDamage() {
        double d = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.isCaptain()) {
            d += (double)(this.getFightingSpirits() * 2);
        } else if (this.getCaptain() != null) {
            EntityStoneGolem captain = (EntityStoneGolem)this.getCaptain();
            d += (double)captain.getFightingSpirits();
        }
        return d;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public float func_70047_e() {
        return 0.8f;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70074_a(EntityLivingBase target) {
        if (this.isCaptain()) {
            this.setAchievements(this.getAchievements() + 1);
        } else if (this.getCaptain() != null) {
            EntityStoneGolem captain = (EntityStoneGolem)this.getCaptain();
            captain.setAchievements(captain.getAchievements() + 1);
        }
    }

    public <T extends Entity> List<T> getNearbyEntities(Class<? extends T> clazz, Class filterClass, double range) {
        return this.func_130014_f_().func_175647_a(clazz, this.func_174813_aQ().func_72314_b(range, range, range), entity -> {
            if (filterClass == null) {
                return true;
            }
            return filterClass.isAssignableFrom(entity.getClass());
        });
    }
}

