/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lily.golemist.GolemistItems;
import lily.golemist.common.entity.EntityGolemBase;
import lily.golemist.common.entity.EntityWolfGolem;
import lily.golemist.common.entity.Projectile.EntityThrownItem;
import lily.golemist.common.entity.ai.GolemAIFollowOwner;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtByTarget;
import lily.golemist.common.entity.ai.GolemAIOwnerHurtTarget;
import lily.golemist.common.entity.ai.GolemAISit;
import lily.golemist.common.entity.ai.UniqueGolemAIAttackRanged;
import lily.golemist.common.entity.ai.UniqueGolemAIDown;
import lily.golemist.common.entity.ai.UniqueGolemAIMelee;
import lily.golemist.common.entity.ai.UniqueGolemAIOpenDoor;
import lily.golemist.common.items.UniqueGolem.ShieldBase;
import lily.golemist.common.items.UniqueGolem.WeaponBase;
import lily.golemist.util.handlers.ConfigHandler;
import lily.golemist.util.handlers.UniqueGolemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityUniqueGolem
extends EntityGolemBase
implements IRangedAttackMob {
    private static final DataParameter<String> KILL_COUNT = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> IDEAS = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> TOTAL_KILL_COUNT = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> INFO = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WEAPON_TYPE = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WEAPON_MATERIAL = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WEAPON_DURABILITY = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STICK_SKILL = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THROWING_SKILL = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHIELD_TYPE = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHIELD_DURABILITY = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHIELD_SKILL = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEAD = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEAD_DURABILITY = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> OFF_HAND_SWING = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FIGHT = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CUSHION = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PARACHUTE = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PARACHUTE_JUMP = EntityDataManager.func_187226_a(EntityUniqueGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    public UniqueGolemAIMelee aiMelee;
    public UniqueGolemAIAttackRanged aiRange;
    public UniqueGolemAIDown aiDown;
    private final InventoryBasic golemInventory = new InventoryBasic("Items", false, 9);
    public float rangedDistance = 15.0f;

    public EntityUniqueGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.9f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    @Override
    protected void func_184651_r() {
        this.aiDown = new UniqueGolemAIDown(this);
        this.aiSwim = new EntityAISwimming((EntityLiving)this);
        this.aiSit = new GolemAISit(this);
        this.aiMelee = new UniqueGolemAIMelee(this, 1.0, true);
        this.aiRange = new UniqueGolemAIAttackRanged(this, 1.0, 20, 10.0f);
        this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2);
        this.aiFollowOwner = new GolemAIFollowOwner(this, 1.0, 10.0f, 2.0f);
        this.aiWander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.aiWatch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.aiLook = new EntityAILookIdle((EntityLiving)this);
        this.aiOwnerHurtByTarget = new GolemAIOwnerHurtByTarget(this);
        this.aiOwnerHurtTarget = new GolemAIOwnerHurtTarget(this);
        this.aiHurtByTarget = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]);
        this.aiAttackSlime = new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new UniqueGolemAIOpenDoor(this, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(KILL_COUNT, (Object)String.valueOf(""));
        this.field_70180_af.func_187214_a(IDEAS, (Object)String.valueOf(""));
        this.field_70180_af.func_187214_a(TOTAL_KILL_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(INFO, (Object)false);
        this.field_70180_af.func_187214_a(WEAPON_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(WEAPON_MATERIAL, (Object)0);
        this.field_70180_af.func_187214_a(WEAPON_DURABILITY, (Object)0);
        this.field_70180_af.func_187214_a(STICK_SKILL, (Object)0);
        this.field_70180_af.func_187214_a(THROWING_SKILL, (Object)0);
        this.field_70180_af.func_187214_a(SHIELD_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(SHIELD_DURABILITY, (Object)0);
        this.field_70180_af.func_187214_a(SHIELD_SKILL, (Object)0);
        this.field_70180_af.func_187214_a(HEAD, (Object)0);
        this.field_70180_af.func_187214_a(HEAD_DURABILITY, (Object)0);
        this.field_70180_af.func_187214_a(OFF_HAND_SWING, (Object)true);
        this.field_70180_af.func_187214_a(FIGHT, (Object)false);
        this.field_70180_af.func_187214_a(CUSHION, (Object)false);
        this.field_70180_af.func_187214_a(PARACHUTE, (Object)false);
        this.field_70180_af.func_187214_a(PARACHUTE_JUMP, (Object)false);
    }

    @Override
    protected void func_70619_bc() {
        EntityPlayer owner = (EntityPlayer)this.getOwner();
        EntityLivingBase target = this.func_70638_az();
        if (this.getState() != 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiDown);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiLook);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
            this.field_70126_B = this.field_70177_z;
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtByTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiOwnerHurtTarget);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiHurtByTarget);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiDown);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiLook);
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.aiWander);
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiOwnerHurtByTarget);
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.aiOwnerHurtTarget);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.aiHurtByTarget);
            if (owner != null && target != null) {
                UniqueGolemUtils.ChangeAttackMode(this, UniqueGolemUtils.IndirectAble(this, owner, target));
            }
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.field_70715_bh.func_75776_a(5, (EntityAIBase)this.aiAttackSlime);
            } else {
                this.field_70715_bh.func_85156_a((EntityAIBase)this.aiAttackSlime);
            }
            if (this.func_70638_az() != null && !this.isSitting()) {
                this.setFight(true);
            } else {
                this.setFight(false);
            }
            if (!this.func_184218_aH()) {
                // empty if block
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.firstGolemHealth);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.firstGolemBaseAttack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(ConfigHandler.firstGolemBaseArmor);
    }

    public int getTotalKillCount() {
        return (Integer)this.field_70180_af.func_187225_a(TOTAL_KILL_COUNT);
    }

    public boolean getInfo() {
        return (Boolean)this.field_70180_af.func_187225_a(INFO);
    }

    public int getWeaponType() {
        return (Integer)this.field_70180_af.func_187225_a(WEAPON_TYPE);
    }

    public int getWeaponMaterial() {
        return (Integer)this.field_70180_af.func_187225_a(WEAPON_MATERIAL);
    }

    public float getWeaponDamage() {
        if (this.getWeaponMaterial() == 1) {
            return 1.0f;
        }
        if (this.getWeaponMaterial() == 2) {
            return 2.0f;
        }
        if (this.getWeaponMaterial() == 3) {
            return 3.0f;
        }
        if (this.getWeaponMaterial() == 4) {
            return 4.0f;
        }
        return 0.0f;
    }

    public int getWeaponDurability() {
        return (Integer)this.field_70180_af.func_187225_a(WEAPON_DURABILITY);
    }

    public int getStickSkill() {
        return (Integer)this.field_70180_af.func_187225_a(STICK_SKILL);
    }

    public int getThrowingSkill() {
        return (Integer)this.field_70180_af.func_187225_a(THROWING_SKILL);
    }

    public int getShieldType() {
        return (Integer)this.field_70180_af.func_187225_a(SHIELD_TYPE);
    }

    public int getShieldDurability() {
        return (Integer)this.field_70180_af.func_187225_a(SHIELD_DURABILITY);
    }

    public int getShieldSkill() {
        return (Integer)this.field_70180_af.func_187225_a(SHIELD_SKILL);
    }

    public int wearHead() {
        return (Integer)this.field_70180_af.func_187225_a(HEAD);
    }

    public int getHeadDurability() {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_DURABILITY);
    }

    public String getKillCount() {
        return ((String)this.field_70180_af.func_187225_a(KILL_COUNT)).toString();
    }

    public String getIdeas() {
        return ((String)this.field_70180_af.func_187225_a(IDEAS)).toString();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean swingOffHand() {
        return (Boolean)this.field_70180_af.func_187225_a(OFF_HAND_SWING);
    }

    public boolean fighting() {
        return (Boolean)this.field_70180_af.func_187225_a(FIGHT);
    }

    public boolean hasCushion() {
        return (Boolean)this.field_70180_af.func_187225_a(CUSHION);
    }

    public boolean hasParachute() {
        return (Boolean)this.field_70180_af.func_187225_a(PARACHUTE);
    }

    public boolean getParachuteJump() {
        return (Boolean)this.field_70180_af.func_187225_a(PARACHUTE_JUMP);
    }

    public void setTotalKillCount(int t_kill_count) {
        this.field_70180_af.func_187227_b(TOTAL_KILL_COUNT, (Object)t_kill_count);
    }

    public void setInfo(boolean info) {
        this.field_70180_af.func_187227_b(INFO, (Object)info);
    }

    public void setWeaponType(int w_type) {
        this.field_70180_af.func_187227_b(WEAPON_TYPE, (Object)w_type);
    }

    public void setWeaponMaterial(int w_material) {
        this.field_70180_af.func_187227_b(WEAPON_MATERIAL, (Object)w_material);
    }

    public void setWeaponDurability(int w_durability) {
        this.field_70180_af.func_187227_b(WEAPON_DURABILITY, (Object)w_durability);
    }

    public void setStickSkill(int stick_skill) {
        this.field_70180_af.func_187227_b(STICK_SKILL, (Object)stick_skill);
    }

    public void setThrowingSkill(int throwing_skill) {
        this.field_70180_af.func_187227_b(THROWING_SKILL, (Object)throwing_skill);
    }

    public void setShieldType(int s_type) {
        this.field_70180_af.func_187227_b(SHIELD_TYPE, (Object)s_type);
    }

    public void setShieldDurability(int s_durability) {
        this.field_70180_af.func_187227_b(SHIELD_DURABILITY, (Object)s_durability);
    }

    public void setShieldSkill(int shield_skill) {
        this.field_70180_af.func_187227_b(SHIELD_SKILL, (Object)shield_skill);
    }

    public void setHead(int head) {
        this.field_70180_af.func_187227_b(HEAD, (Object)head);
        if (head == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)this.func_70658_aO() + 1.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)this.func_70658_aO() - 1.0);
        }
    }

    public void setHeadDurability(int h_durability) {
        this.field_70180_af.func_187227_b(HEAD_DURABILITY, (Object)h_durability);
    }

    public void setSwingOffHand(boolean swing) {
        this.field_70180_af.func_187227_b(OFF_HAND_SWING, (Object)swing);
    }

    public void setFight(boolean fight) {
        this.field_70180_af.func_187227_b(FIGHT, (Object)fight);
    }

    public void setCushion(boolean cushion) {
        this.field_70180_af.func_187227_b(CUSHION, (Object)cushion);
    }

    public void setParachute(boolean parachute) {
        this.field_70180_af.func_187227_b(PARACHUTE, (Object)parachute);
    }

    public void setParachuteJump(boolean parachute_jump) {
        this.field_70180_af.func_187227_b(PARACHUTE_JUMP, (Object)parachute_jump);
    }

    public void setKillCount(String k_count) {
        this.field_70180_af.func_187227_b(KILL_COUNT, (Object)k_count);
    }

    public void setIdeas(String ideas) {
        this.field_70180_af.func_187227_b(IDEAS, (Object)ideas);
    }

    public static void registerFixesUniqueGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityUniqueGolem.class);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("TotalKillCount", this.getTotalKillCount());
        compound.func_74757_a("Info", this.getInfo());
        compound.func_74768_a("WeaponType", this.getWeaponType());
        compound.func_74768_a("WeaponMaterial", this.getWeaponMaterial());
        compound.func_74768_a("WeaponDurability", this.getWeaponDurability());
        compound.func_74768_a("StickSkill", this.getStickSkill());
        compound.func_74768_a("ThrowingSkill", this.getThrowingSkill());
        compound.func_74768_a("ShieldType", this.getShieldType());
        compound.func_74768_a("ShieldDurability", this.getShieldDurability());
        compound.func_74768_a("ShieldSkill", this.getShieldSkill());
        compound.func_74768_a("Head", this.wearHead());
        compound.func_74768_a("HeadDurability", this.getHeadDurability());
        compound.func_74757_a("Cushion", this.hasCushion());
        compound.func_74757_a("Parachute", this.hasParachute());
        compound.func_74757_a("ParachuteJump", this.getParachuteJump());
        compound.func_74778_a("KillCounts", this.getKillCount());
        compound.func_74778_a("Ideas", this.getIdeas());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.golemInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.golemInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            nbttaglist.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (NBTBase)nbttaglist);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setTotalKillCount(compound.func_74762_e("TotalKillCount"));
        this.setInfo(compound.func_74767_n("Info"));
        this.setWeaponType(compound.func_74762_e("WeaponType"));
        this.setWeaponMaterial(compound.func_74762_e("WeaponMaterial"));
        this.setWeaponDurability(compound.func_74762_e("WeaponDurability"));
        this.setStickSkill(compound.func_74762_e("StickSkill"));
        this.setThrowingSkill(compound.func_74762_e("ThrowingSkill"));
        this.setShieldType(compound.func_74762_e("ShieldType"));
        this.setShieldDurability(compound.func_74762_e("ShieldDurability"));
        this.setShieldSkill(compound.func_74762_e("ShieldSkill"));
        this.setHead(compound.func_74762_e("Head"));
        this.setHeadDurability(compound.func_74762_e("HeadDurability"));
        this.setCushion(compound.func_74767_n("Cushion"));
        this.setParachute(compound.func_74767_n("Parachute"));
        this.setParachuteJump(compound.func_74767_n("ParachuteJump"));
        this.setKillCount(compound.func_74779_i("KillCounts"));
        this.setIdeas(compound.func_74779_i("Ideas"));
        NBTTagList nbttaglist = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            ItemStack itemstack = new ItemStack(nbttaglist.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.golemInventory.func_174894_a(itemstack);
        }
    }

    public InventoryBasic getGolemInventory() {
        return this.golemInventory;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        EntityWolfGolem wolf = (EntityWolfGolem)this.getPartner();
        ItemStack itemstack = player.func_184614_ca();
        ItemStack itemstack2 = player.func_184592_cb();
        UUID uuid = this.func_110124_au();
        System.out.println(uuid);
        if (this.isTamed() && !itemstack.func_190926_b() && this.getState() == 0 && player.func_70093_af()) {
            if (this.func_184614_ca().func_190926_b()) {
                if (itemstack.func_77973_b() == Items.field_151055_y) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GolemistItems.WEAPON_STICK));
                        this.setWeaponType(2);
                        this.playChestEquipSound();
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        return true;
                    }
                } else if (itemstack.func_77973_b() == Items.field_151103_aS) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GolemistItems.WEAPON_BONE));
                        this.setWeaponType(2);
                        this.playChestEquipSound();
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        return true;
                    }
                } else if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150411_aY)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GolemistItems.WEAPON_IRON_BAR));
                        this.setWeaponType(2);
                        this.playChestEquipSound();
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        return true;
                    }
                } else if (itemstack.func_77973_b() == Items.field_151072_bj) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GolemistItems.WEAPON_BLAZE_ROD));
                        this.setWeaponType(2);
                        this.playChestEquipSound();
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        return true;
                    }
                } else if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_185764_cQ) && !this.field_70170_p.field_72995_K) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GolemistItems.WEAPON_END_ROD));
                    this.setWeaponType(2);
                    this.playChestEquipSound();
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (this.func_184592_cb().func_190926_b()) {
                if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150452_aw)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GolemistItems.SHILED_WOOD));
                        this.setShieldType(1);
                        this.setSwingOffHand(false);
                        this.playChestEquipSound();
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        return true;
                    }
                } else if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150456_au)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GolemistItems.SHILED_STONE));
                        this.setShieldType(1);
                        this.setSwingOffHand(false);
                        this.playChestEquipSound();
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        return true;
                    }
                } else if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150443_bT) && !this.field_70170_p.field_72995_K) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GolemistItems.SHILED_IRON));
                    this.setShieldType(1);
                    this.setSwingOffHand(false);
                    this.playChestEquipSound();
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (this.getShieldType() == 1 && itemstack.func_77973_b() == Items.field_151100_aR && itemstack2.func_77973_b() == Items.field_151100_aR) {
                int enumdyecolor = itemstack.func_77952_i();
                int enumdyecolor2 = itemstack2.func_77952_i();
                if (enumdyecolor == 4 && enumdyecolor2 == 15 || enumdyecolor == 15 && enumdyecolor2 == 4) {
                    this.setShieldType(2);
                    this.setShieldDurability(this.getShieldDurability() + 150);
                    this.playChestEquipSound();
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        itemstack2.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (!this.hasCushion() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                this.setCushion(true);
                this.playChestEquipSound();
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (!this.hasParachute()) {
                if (ConfigHandler.parachute && (itemstack.func_77973_b() == Items.field_151058_ca && itemstack2.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg) && itemstack2.func_77973_b() == Items.field_151058_ca)) {
                    this.setParachute(true);
                    this.playChestEquipSound();
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        itemstack2.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (this.wearHead() == 0 && itemstack.func_77973_b() == Items.field_151024_Q) {
                this.setHead(1);
                this.setHeadDurability(this.getHeadDurability() + 50);
                this.playChestEquipSound();
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_77973_b() == GolemistItems.PUMPKIN_ROD) {
                if (ConfigHandler.golemInfo) {
                    if (this.getInfo()) {
                        this.setInfo(false);
                        return true;
                    }
                    this.setInfo(true);
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getState() == 0) {
            for (Object entityitem : this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                if (((EntityItem)entityitem).field_70128_L || entityitem.func_92059_d().func_190926_b() || entityitem.func_174874_s()) continue;
                ItemStack itemStack = entityitem.func_92059_d();
                Item item = itemStack.func_77973_b();
                if (!UniqueGolemUtils.isThrowableItems(itemStack) || this.field_70170_p.field_72995_K) continue;
                ItemStack itemstack1 = this.golemInventory.func_174894_a(itemStack);
                this.func_71001_a((Entity)entityitem, 0);
                this.playItemPickUpSound();
                if (itemstack1.func_190926_b()) {
                    entityitem.func_70106_y();
                    continue;
                }
                itemStack.func_190920_e(itemstack1.func_190916_E());
            }
        }
        if (!this.isTamed()) {
            this.func_70106_y();
        }
        if (this.getOwner() == null && this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (this.func_110143_aJ() <= 0.0f && this.isTamed()) {
            List<EntityLiving> nearEntities = this.getNearbyEntities(EntityLiving.class, null, 10.0);
            for (Object e : nearEntities) {
                if (e == this || e instanceof EntityGolemBase) continue;
                ((EntityLivingBase)e).func_70604_c(null);
                ((EntityLiving)e).func_70624_b(null);
                ((EntityLiving)e).func_70661_as().func_75499_g();
            }
            if (this.func_184218_aH()) {
                this.func_184210_p();
            }
            this.func_70624_b(null);
            this.func_70604_c(null);
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (this.func_70027_ad() && this.getState() == 0) {
            this.func_70066_B();
        }
        if (this.wearHead() >= 1 && this.getHeadDurability() <= 0) {
            this.setHead(0);
            this.playEquipBreakSound();
        }
        if (this.getWeaponType() >= 2 || this.getShieldType() >= 1) {
            this.setSwingOffHand(false);
        } else {
            this.setSwingOffHand(true);
        }
        if (this.hasParachute() && this.field_70143_R >= 3.0f && !this.field_70122_E) {
            this.setParachuteJump(true);
            this.field_70181_x *= 0.75;
        }
        if (ConfigHandler.cushionHealingTick >= 1 && this.hasCushion() && this.isSitting()) {
            if (this.field_70173_aa % ConfigHandler.cushionHealingTick == 0) {
                this.func_70691_i(ConfigHandler.cushionHealingAmount);
            }
        }
        if (this.getWeaponMaterial() >= 1) {
            int m = this.getWeaponMaterial();
            ItemStack convert = null;
            switch (m) {
                case 1: {
                    convert = new ItemStack(GolemistItems.WEAPON_STICK);
                    break;
                }
                case 2: {
                    convert = new ItemStack(GolemistItems.WEAPON_BONE);
                    break;
                }
                case 4: {
                    convert = new ItemStack(GolemistItems.WEAPON_IRON_BAR);
                    break;
                }
                case 8: {
                    convert = new ItemStack(GolemistItems.WEAPON_BLAZE_ROD);
                }
            }
            if (!this.field_70170_p.field_72995_K && convert != null) {
                this.setWeaponType(2);
                this.setWeaponMaterial(0);
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, convert);
            }
        }
        if (this.getShieldDurability() >= 1) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GolemistItems.SHILED_IRON));
            this.setShieldDurability(0);
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)UniqueGolemUtils.getDamage(this, entityIn)));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        if (this.getWeaponType() == 2) {
            this.setStickSkill(this.getStickSkill() + 1);
        }
        if (this.func_184614_ca().func_77973_b() instanceof WeaponBase) {
            ItemStack weapon = this.func_184614_ca();
            if (!this.field_70170_p.field_72995_K) {
                if (weapon.func_77973_b() == GolemistItems.WEAPON_BONE) {
                    if (this.field_70146_Z.nextInt(100) < 3) {
                        ItemStack boneMeal = new ItemStack(Items.field_151100_aR);
                        boneMeal.func_77964_b(15);
                        EntityItem entityitem = new EntityItem(this.field_70170_p, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p(), boneMeal);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d((Entity)entityitem);
                        }
                    }
                } else if (weapon.func_77973_b() == GolemistItems.WEAPON_BLAZE_ROD && this.field_70146_Z.nextInt(100) < 3) {
                    ItemStack blazePowder = new ItemStack(Items.field_151065_br);
                    EntityItem entityitem = new EntityItem(this.field_70170_p, (double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p(), blazePowder);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityitem);
                    }
                }
                weapon.func_77972_a(1, (EntityLivingBase)this);
                if (!(this.func_184614_ca().func_77973_b() instanceof WeaponBase)) {
                    this.setWeaponType(0);
                }
            }
        }
        entityIn.field_70172_ad = 0;
        return flag;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (UniqueGolemUtils.ThrowableItemInInventory(this)) {
            ItemStack throwItem = UniqueGolemUtils.ThrowItem(this);
            EntityThrownItem entityThrownItem = new EntityThrownItem(this.field_70170_p, (EntityLivingBase)this);
            float accuracyBonus = this.getThrowingSkill() / 100;
            if (accuracyBonus > 10.0f) {
                accuracyBonus = 10.0f;
            }
            double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
            double d1 = target.field_70165_t - this.field_70165_t;
            double d2 = d0 - entityThrownItem.field_70163_u;
            double d3 = target.field_70161_v - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
            entityThrownItem.setProperty(this, throwItem);
            entityThrownItem.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f - accuracyBonus);
            this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)entityThrownItem);
            this.setThrowingSkill(this.getThrowingSkill() + 1);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getOwner() == null) {
            return false;
        }
        if (this.getState() != 0) {
            return false;
        }
        Entity entityprojectile = source.func_76364_f();
        Entity entity = source.func_76346_g();
        if (source == DamageSource.field_76379_h && this.getParachuteJump()) {
            this.setParachuteJump(false);
            return false;
        }
        if (this.func_184592_cb().func_77973_b() instanceof ShieldBase && entity instanceof EntityLivingBase) {
            int skillBonus = this.getShieldSkill();
            if (skillBonus > ConfigHandler.shieldSkillCountLimit) {
                skillBonus = ConfigHandler.shieldSkillCountLimit;
            }
            int i = ConfigHandler.shieldGuardChance + skillBonus / ConfigHandler.probabilityShiledSkillRatio;
            if (this.getShieldType() == 2) {
                i += 10;
            }
            if (this.field_70146_Z.nextInt(100) <= i && !this.field_70170_p.field_72995_K) {
                this.setShieldSkill(this.getShieldSkill() + 1);
                this.playShieldBlockSound();
                if (entityprojectile instanceof EntityArrow && this.field_70146_Z.nextInt(100) <= i) {
                    ItemStack arrow = new ItemStack(Items.field_151032_g);
                    this.func_70099_a(arrow, 1.0f);
                }
                ItemStack offHand = this.func_184592_cb();
                Item shield = offHand.func_77973_b();
                amount -= ((ShieldBase)shield).getReduceDamage();
                offHand.func_77972_a(1, (EntityLivingBase)this);
                if (amount < 0.0f) {
                    this.func_70653_a(entity, 0.5f, 0.5, 0.5);
                    this.field_70172_ad = this.field_70771_an;
                    return false;
                }
            }
        }
        return super.func_70097_a(source, amount);
    }

    public float func_70047_e() {
        return 0.7f;
    }

    public void func_70074_a(EntityLivingBase target) {
        HashMap<Object, Object> objEntities = new HashMap();
        float targetHealth = target.func_110138_aP();
        this.setKillCount(UniqueGolemUtils.addKillCount(target, this.getKillCount()));
        this.setTotalKillCount(this.getTotalKillCount() + 1);
        objEntities = UniqueGolemUtils.deserializeKillCount(this.getKillCount());
        String strEntityName = target.getClass().getName();
        int intKillCount = 0;
        if (ConfigHandler.increaseMaxHealth) {
            intKillCount = (Integer)objEntities.get(strEntityName);
            int h = this.field_70146_Z.nextInt(ConfigHandler.probabilityIncreaseMaxHealth);
            if (intKillCount > h) {
                if (this.func_110138_aP() + (float)ConfigHandler.limitIncreaseMaxHealth <= target.func_110138_aP()) {
                    this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.func_110138_aP() + 1.0);
                    if (!this.getOwner().field_70170_p.field_72995_K && this.getInfo()) {
                        this.getOwner().func_145747_a((ITextComponent)new TextComponentString(this.func_70005_c_() + " MaxHealth " + this.func_110138_aP()));
                    }
                }
            }
        }
        if (this.getInfo()) {
            this.getOwner().func_145747_a((ITextComponent)new TextComponentString(target.func_70005_c_() + " KillCount " + intKillCount));
        }
    }

    private String serializeIdeas(HashMap<String, Integer> objIdeas) {
        StringBuilder strIdeaSerialize = new StringBuilder();
        for (Map.Entry<String, Integer> objIdea : objIdeas.entrySet()) {
            strIdeaSerialize.append(objIdea.getKey() + "," + objIdea.getValue() + "|");
        }
        return strIdeaSerialize.toString().substring(0, strIdeaSerialize.toString().length() - 1);
    }

    private HashMap<String, Integer> deserializeIdeas(String strIdeaSerialize) {
        HashMap<String, Integer> objIdeas = new HashMap<String, Integer>();
        if (strIdeaSerialize.length() >= 1) {
            String[] strIdeas;
            for (String strEntity : strIdeas = strIdeaSerialize.split("\\|")) {
                String[] strKeyValue = strEntity.split(",");
                objIdeas.put(strKeyValue[0], Integer.parseInt(strKeyValue[1]));
            }
        }
        return objIdeas;
    }

    private String progressIdea(UniqueGolemUtils.EnumIdeas idea, String strIdeaSerialize) {
        HashMap<Object, Object> objIdeas = new HashMap();
        if (strIdeaSerialize.length() >= 1) {
            objIdeas = this.deserializeIdeas(strIdeaSerialize);
        }
        String strIdeaName = idea.getName();
        System.out.println(" |||||| Idea Name " + strIdeaName);
        int intStage = 0;
        if (objIdeas.containsKey(strIdeaName)) {
            intStage = (Integer)objIdeas.get(strIdeaName);
        }
        objIdeas.put(strIdeaName, ++intStage);
        return this.serializeIdeas(objIdeas);
    }

    public <T extends Entity> List<T> getNearbyEntities(Class<? extends T> clazz, Class filterClass, double range) {
        return this.func_130014_f_().func_175647_a(clazz, this.func_174813_aQ().func_72314_b(range, range, range), entity -> {
            if (filterClass == null) {
                return true;
            }
            return filterClass.isAssignableFrom(entity.getClass());
        });
    }
}

