/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import lily.golemist.GolemistItems;
import lily.golemist.common.entity.EntityGolemBase;
import lily.golemist.common.entity.EntityUniqueGolem;
import lily.golemist.common.entity.ai.GolemAIDown;
import lily.golemist.common.entity.ai.GolemAIFollowOwner;
import lily.golemist.common.entity.ai.GolemAIFollowPartner;
import lily.golemist.common.entity.ai.GolemAISit;
import lily.golemist.util.handlers.ConfigHandler;
import lily.golemist.util.handlers.GolemsUtils;
import lily.golemist.util.handlers.Runes;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWolfGolem
extends EntityGolemBase {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityWolfGolem.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(EntityWolfGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> PARTNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityWolfGolem.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> HELD_SHIELD = EntityDataManager.func_187226_a(EntityWolfGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEFT_WEDGE = EntityDataManager.func_187226_a(EntityWolfGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private float headRotationCourse;
    private float headRotationCourseOld;
    private boolean isWet;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int healingTime = 0;
    private int travelTime = 0;
    private int assistTime = 0;
    private int ignoreInteractTime = 0;
    private boolean assistGolem = false;
    protected GolemAIFollowPartner aiFollowPartner;

    public EntityWolfGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.85f);
    }

    @Override
    protected void func_184651_r() {
        this.aiDown = new GolemAIDown(this);
        this.aiSwim = new EntityAISwimming((EntityLiving)this);
        this.aiSit = new GolemAISit(this);
        this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2);
        this.aiFollowPartner = new GolemAIFollowPartner(this, 1.5, 10.0f, 1.2f);
        this.aiFollowOwner = new GolemAIFollowOwner(this, 1.5, 10.0f, 2.0f);
        this.aiWander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.aiWatch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.aiLook = new EntityAILookIdle((EntityLiving)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowPartner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(BEGGING, (Object)false);
        this.field_70180_af.func_187214_a(PARTNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(HELD_SHIELD, (Object)0);
        this.field_70180_af.func_187214_a(LEFT_WEDGE, (Object)0);
    }

    @Override
    protected void func_70619_bc() {
        EntityUniqueGolem partner = (EntityUniqueGolem)this.getPartner();
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        if (this.getState() != 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiDown);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiLook);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
            this.field_70126_B = this.field_70177_z;
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiDown);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiLook);
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.aiWander);
            if (this.getPartner() != null && partner.getState() == 0) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowPartner);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowOwner);
                if (!this.isSitting()) {
                    // empty if block
                }
            } else {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFollowPartner);
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        if (this.isTamed()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    @Nullable
    public UUID getPartnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(PARTNER_UNIQUE_ID)).orNull();
    }

    @Override
    @Nullable
    public EntityLivingBase getPartner() {
        try {
            UUID uuid = this.getPartnerId();
            if (uuid != null) {
                EntityPlayer player = this.field_70170_p.func_152378_a(uuid);
                if (player != null) {
                    return player;
                }
                EntityLivingBase entity = EntityWolfGolem.getEntityUUID(uuid, this.field_70170_p);
                if (entity != null) {
                    return entity;
                }
                return null;
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static EntityLivingBase getEntityUUID(UUID uuid, World world) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!uuid.equals(entity.func_110124_au())) continue;
            if (entity instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
            return null;
        }
        return null;
    }

    public int heldShield() {
        return (Integer)this.field_70180_af.func_187225_a(HELD_SHIELD);
    }

    public int getLeftWedge() {
        return (Integer)this.field_70180_af.func_187225_a(LEFT_WEDGE);
    }

    @Override
    public void setPartnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(PARTNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public void setShield(int shield) {
        this.field_70180_af.func_187227_b(HELD_SHIELD, (Object)shield);
    }

    public void setLeftWedge(int left_wedge) {
        this.field_70180_af.func_187227_b(LEFT_WEDGE, (Object)left_wedge);
    }

    public static void registerFixesWolfGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityWolfGolem.class);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getPartnerId() == null) {
            compound.func_74778_a("PartnerUUID", "");
        } else {
            compound.func_74778_a("PartnerUUID", this.getPartnerId().toString());
        }
        compound.func_74768_a("HeldShiled", this.heldShield());
        compound.func_74768_a("LeftWedge", this.getLeftWedge());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("PartnerUUID", 8)) {
            s = compound.func_74779_i("PartnerUUID");
        } else {
            String s1 = compound.func_74779_i("Partner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setPartnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setShield(compound.func_74762_e("HeldShiled"));
        this.setLeftWedge(compound.func_74762_e("LeftWedge"));
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        if (this.isTamed() && this.ignoreInteractTime == 0) {
            if (!mainHand.func_190926_b()) {
                EntityUniqueGolem partner;
                if (player.func_70093_af()) {
                    // empty if block
                }
                if (offHand.func_77973_b() == GolemistItems.PUMPKIN_MEDAL && (partner = (EntityUniqueGolem)this.getPartner()) != null && partner.getCarried() == 1) {
                    this.setCarried(2);
                    return true;
                }
            }
            if (this.isOwner((EntityLivingBase)player) && !this.func_184614_ca().func_190926_b()) {
                ItemStack pickedItem = this.func_184614_ca();
                if (pickedItem.func_77973_b() == Items.field_151103_aS) {
                    this.playWhineSound();
                }
                if (mainHand.func_190926_b()) {
                    player.func_184611_a(hand, pickedItem);
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else if (!player.field_71071_by.func_70441_a(pickedItem)) {
                    player.func_71019_a(pickedItem, false);
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
                this.travelTime = 0;
                this.ignoreInteractTime = 10;
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed()) {
            this.func_70106_y();
        }
        EntityPlayer owner = (EntityPlayer)this.getOwner();
        EntityUniqueGolem partner = (EntityUniqueGolem)this.getPartner();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (this.ignoreInteractTime >= 1) {
            --this.ignoreInteractTime;
        }
        if (this.func_70027_ad() && this.getState() == 0) {
            this.func_70066_B();
        }
        if (this.func_110143_aJ() <= 0.0f && this.isTamed()) {
            List<EntityLiving> nearEntities = GolemsUtils.getNearbyEntities(this, EntityLiving.class, null, 10.0);
            for (EntityLiving entityObj : nearEntities) {
                if (entityObj == this || entityObj instanceof EntityGolemBase) continue;
                ((EntityLivingBase)entityObj).func_70604_c(null);
                entityObj.func_70624_b(null);
                entityObj.func_70661_as().func_75499_g();
            }
            this.func_70624_b(null);
            this.func_70604_c(null);
            this.healingTime = 0;
            this.travelTime = 0;
            this.assistTime = 0;
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (!this.isSitting() && this.getCarried() == 0) {
            if (ConfigHandler.assistBarkCoolTime >= 1 && !this.assistGolem) {
                ++this.assistTime;
                if (this.assistTime >= ConfigHandler.assistBarkCoolTime) {
                    this.assistTime = 0;
                    this.assistGolem = true;
                }
            }
            if (this.assistGolem && partner != null && partner.fighting()) {
                this.playBarkSound();
                this.getPartner().func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 0, true, true));
                this.assistGolem = false;
            }
            if (ConfigHandler.itemPickingUpTime >= 1 && owner != null && this.func_184614_ca().func_190926_b()) {
                ++this.travelTime;
                if (this.travelTime >= ConfigHandler.itemPickingUpTime && !this.field_70170_p.field_72995_K && partner != null) {
                    ItemStack itemstack;
                    this.travelTime = 0;
                    int i = this.field_70146_Z.nextInt(100);
                    if (i <= 10) {
                        itemstack = new ItemStack(Items.field_151055_y);
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                        return;
                    }
                    if (i <= 20) {
                        itemstack = new ItemStack(Items.field_151103_aS);
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                        return;
                    }
                    if (i <= 30) {
                        itemstack = new ItemStack(Items.field_151008_G);
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                        return;
                    }
                    if (i <= 40) {
                        itemstack = new ItemStack(Items.field_151145_ak);
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                        return;
                    }
                    if (i <= 50) {
                        itemstack = new ItemStack(Items.field_151121_aF);
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                        return;
                    }
                    if (i <= 60) {
                        itemstack = new ItemStack(Items.field_151069_bo);
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                        return;
                    }
                    if (i <= 70) {
                        itemstack = new ItemStack(GolemistItems.PUMPKIN_MEDAL);
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                        return;
                    }
                    if (i <= 80) {
                        itemstack = new ItemStack(GolemistItems.BOTTLED_PUMPKIN_SOUL);
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                        return;
                    }
                    int n = this.field_70146_Z.nextInt(24) + 1;
                    ItemStack itemstack2 = Runes.checkRuneName(n);
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack2);
                    return;
                }
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    public double getDamage() {
        double d = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return d;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (this.getState() == 0) {
            // empty if block
        }
        return super.func_70097_a(source, amount);
    }

    public float func_70047_e() {
        return 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWolfWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float p_70915_1_) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70915_1_) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float p_70917_1_) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * p_70917_1_) * 0.15f * (float)Math.PI;
    }

    public int func_70646_bf() {
        return this.isSitting() ? 20 : super.func_70646_bf();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.isTamed() ? (0.55f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)beg);
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return super.func_184652_a(player);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected void playWhineSound() {
        this.func_184185_a(SoundEvents.field_187871_gL, 0.8f, 1.1f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected void playBarkSound() {
        this.func_184185_a(SoundEvents.field_187857_gE, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }
}

