/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity;

import java.util.List;
import javax.annotation.Nullable;
import lily.golemist.GolemistItems;
import lily.golemist.common.entity.EntityGolemBase;
import lily.golemist.common.entity.ai.GolemAIDown;
import lily.golemist.common.entity.ai.GolemAIFollowOwner;
import lily.golemist.common.entity.ai.GolemAISit;
import lily.golemist.util.handlers.ConfigHandler;
import lily.golemist.util.handlers.Runes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;

public class EntityWoodGolem
extends EntityGolemBase {
    private static final DataParameter<Boolean> POT = EntityDataManager.func_187226_a(EntityWoodGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> ESSENCE = EntityDataManager.func_187226_a(EntityWoodGolem.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> HEAL_ABILITY = EntityDataManager.func_187226_a(EntityWoodGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> HEAL_DURATION = EntityDataManager.func_187226_a(EntityWoodGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private int essenceTime = 0;
    private int healTime = 0;
    private int clientHealTime;
    private EntityGolemBase healTarget;

    public EntityWoodGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.35f);
    }

    @Override
    protected void func_184651_r() {
        this.aiDown = new GolemAIDown(this);
        this.aiSwim = new EntityAISwimming((EntityLiving)this);
        this.aiSit = new GolemAISit(this);
        this.aiMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2);
        this.aiFollowOwner = new GolemAIFollowOwner(this, 1.0, 10.0f, 2.0f);
        this.aiWander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.aiWatch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.aiLook = new EntityAILookIdle((EntityLiving)this);
        this.aiHurtByTarget = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]);
        this.aiAttackSlime = new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiMelee);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFollowOwner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POT, (Object)false);
        this.field_70180_af.func_187214_a(ESSENCE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(HEAL_ABILITY, (Object)false);
        this.field_70180_af.func_187214_a(HEAL_DURATION, (Object)80);
    }

    @Override
    protected void func_70619_bc() {
        if (this.getState() != 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiDown);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiLook);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
            this.field_70126_B = this.field_70177_z;
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiHurtByTarget);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiDown);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiWatch);
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.aiLook);
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.aiWander);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.aiHurtByTarget);
            if (this.func_110143_aJ() < this.func_110138_aP() || this.hasPot() && this.getEssence() < 5.0f) {
                this.field_70715_bh.func_75776_a(5, (EntityAIBase)this.aiAttackSlime);
            } else {
                this.field_70715_bh.func_85156_a((EntityAIBase)this.aiAttackSlime);
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.40000001192092893);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.woodGolemHealth);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.woodGolemBaseAttack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(ConfigHandler.woodGolemBaseArmor);
    }

    public boolean hasPot() {
        return (Boolean)this.field_70180_af.func_187225_a(POT);
    }

    public void setPot(boolean parachute) {
        this.field_70180_af.func_187227_b(POT, (Object)parachute);
    }

    public float getEssence() {
        return ((Float)this.field_70180_af.func_187225_a(ESSENCE)).floatValue();
    }

    public void setEssence(float e_amount) {
        this.field_70180_af.func_187227_b(ESSENCE, (Object)Float.valueOf(e_amount));
    }

    public boolean getHealAbility() {
        return (Boolean)this.field_70180_af.func_187225_a(HEAL_ABILITY);
    }

    public void hasHealAbility(boolean h_ability) {
        this.field_70180_af.func_187227_b(HEAL_ABILITY, (Object)h_ability);
    }

    public int getHealDuration() {
        return (Integer)this.field_70180_af.func_187225_a(HEAL_DURATION);
    }

    public void setHealDuration(int h_duration) {
        this.field_70180_af.func_187227_b(HEAL_DURATION, (Object)h_duration);
    }

    @Nullable
    public EntityGolemBase getHealTarget() {
        return this.healTarget;
    }

    public void setHealTarget(@Nullable EntityGolemBase targetGolem) {
        this.healTarget = targetGolem;
    }

    public static void registerFixesWoodGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityWoodGolem.class);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Pot", this.hasPot());
        compound.func_74776_a("Essence", this.getEssence());
        compound.func_74757_a("Heal", this.getHealAbility());
        compound.func_74768_a("HealDuration", this.getHealDuration());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPot(compound.func_74767_n("Pot"));
        this.setEssence(compound.func_74760_g("Essence"));
        this.hasHealAbility(compound.func_74767_n("Heal"));
        this.setHealDuration(compound.func_74762_e("HealDuration"));
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184614_ca();
        ItemStack itemstack2 = player.func_184592_cb();
        if (this.isTamed() && !itemstack.func_190926_b()) {
            if (player.func_70093_af()) {
                if (itemstack.func_77973_b() == Items.field_151162_bE) {
                    if (ConfigHandler.essenceGenerationTime >= 1) {
                        if (!this.hasPot()) {
                            if (!player.field_71075_bZ.field_75098_d) {
                                itemstack.func_190918_g(1);
                            }
                            if (!this.field_70170_p.field_72995_K) {
                                this.setPot(true);
                                this.playChestEquipSound();
                                return true;
                            }
                        }
                        return false;
                    }
                }
                if (itemstack.func_77973_b() == GolemistItems.GUARDIAN_EYE) {
                    if (this.getHealAbility()) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.hasHealAbility(true);
                            this.playChestEquipSound();
                            return true;
                        }
                    }
                    return false;
                }
            }
            if (itemstack.func_77973_b() == Items.field_151069_bo && this.getEssence() >= 1.0f) {
                ItemStack bottle = new ItemStack(GolemistItems.BOTTLED_PUMPKIN_SOUL);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                    if (!this.field_70170_p.field_72995_K) {
                        if (itemstack.func_190926_b()) {
                            player.func_184611_a(hand, bottle);
                        } else if (!player.field_71071_by.func_70441_a(bottle)) {
                            player.func_71019_a(bottle, false);
                        } else if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                        }
                    }
                }
                this.setEssence(this.getEssence() - 1.0f);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.hasPot() && this.getEssence() < 5.0f) {
            int ing = Runes.getRuneInSlot(this, 12);
            ++this.essenceTime;
            if (this.essenceTime >= ConfigHandler.essenceGenerationTime - 1200 * ing) {
                this.setEssence(this.getEssence() + 1.0f);
                this.essenceTime = 0;
            }
            if (this.func_110143_aJ() < this.func_110138_aP() && this.getEssence() >= 1.0f) {
                this.func_70691_i(1.0f);
                this.setEssence(this.getEssence() - 1.0f);
            }
        }
        if (this.getEssence() >= 1.0f) {
            int beorc = Runes.getRuneInSlot(this, 18);
            if (this.getHealAbility() && beorc >= 1 && this.getEssence() >= 1.0f) {
                List<EntityGolemBase> nearEntities = this.getNearbyEntities(EntityGolemBase.class, null, 4 * beorc);
                for (EntityGolemBase entityObj : nearEntities) {
                    EntityGolemBase targetGolem;
                    if (this.getHealTarget() != null || (targetGolem = entityObj) == this || targetGolem.getOwner() != this.getOwner() || !(targetGolem.func_110143_aJ() < targetGolem.func_110138_aP())) continue;
                    this.setHealTarget(targetGolem);
                }
                if (this.getHealTarget() != null) {
                    this.healTime += 1 * beorc;
                    if (this.healTime >= this.getHealDuration()) {
                        this.getHealTarget().func_70691_i(1.0f);
                        this.setEssence(this.getEssence() - 1.0f);
                        this.healTime = 0;
                        if (this.getHealTarget().func_110143_aJ() >= this.getHealTarget().func_110138_aP() || this.getEssence() < 1.0f) {
                            this.setHealTarget(null);
                        }
                    }
                }
            }
        }
        if (this.getOwner() == null && this.getHealTarget() != null) {
            this.setHealTarget(null);
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    public double getDamage() {
        double d = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return d;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getState() == 0) {
            // empty if block
        }
        return super.func_70097_a(source, amount);
    }

    public float func_70047_e() {
        return 0.8f;
    }

    public int func_70641_bl() {
        return 3;
    }

    public void func_70074_a(EntityLivingBase target) {
        if (this.hasPot() && this.getEssence() < 5.0f && target instanceof EntitySlime) {
            this.setEssence(this.getEssence() + 1.0f);
            if (this.getEssence() > 5.0f) {
                this.setEssence(5.0f);
            }
        }
    }

    public float getHealAnimationScale(float p_175477_1_) {
        return ((float)this.clientHealTime + p_175477_1_) / (float)this.getHealDuration();
    }

    public <T extends Entity> List<T> getNearbyEntities(Class<? extends T> clazz, Class filterClass, double range) {
        return this.func_130014_f_().func_175647_a(clazz, this.func_174813_aQ().func_72314_b(range, range, range), entity -> {
            if (filterClass == null) {
                return true;
            }
            return filterClass.isAssignableFrom(entity.getClass());
        });
    }
}

