/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity.ai;

import lily.golemist.common.entity.EntityGolemBase;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GolemAIFollowOwner
extends EntityAIBase {
    private final EntityGolemBase golem;
    private EntityLivingBase owner;
    World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    float maxDist;
    float minDist;
    private float oldWaterCost;

    public GolemAIFollowOwner(EntityGolemBase entityGolemBase, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.golem = entityGolemBase;
        this.world = entityGolemBase.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = entityGolemBase.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_75248_a(3);
        if (!(entityGolemBase.func_70661_as() instanceof PathNavigateGround) && !(entityGolemBase.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.golem.getOwner();
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
            return false;
        }
        if (this.golem.isSitting()) {
            return false;
        }
        if (this.golem.func_70068_e((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.golem.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.golem.isSitting();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.golem.func_184643_a(PathNodeType.WATER);
        this.golem.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.golem.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.golem.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.golem.func_70646_bf());
        if (!this.golem.isSitting() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed) && !this.golem.func_110167_bD() && !this.golem.func_184218_aH() && this.golem.func_70068_e((Entity)this.owner) >= 144.0) {
                int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                        this.golem.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.golem.field_70177_z, this.golem.field_70125_A);
                        this.petPathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(int x, int p_192381_2_, int y, int p_192381_4_, int p_192381_5_) {
        BlockPos blockpos = new BlockPos(x + p_192381_4_, y - 1, p_192381_2_ + p_192381_5_);
        IBlockState iblockstate = this.world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.golem) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
    }
}

