/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.common.entity.ai;

import lily.golemist.common.entity.EntityStoneGolem;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StoneGolemAIFollowCaptain
extends EntityAIBase {
    private final EntityStoneGolem stoneGolem;
    private EntityStoneGolem captain;
    World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    float maxDist;
    float minDist;
    private float oldWaterCost;

    public StoneGolemAIFollowCaptain(EntityStoneGolem wolfgolemIn, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.stoneGolem = wolfgolemIn;
        this.world = wolfgolemIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = wolfgolemIn.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_75248_a(3);
        if (!(wolfgolemIn.func_70661_as() instanceof PathNavigateGround) && !(wolfgolemIn.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityStoneGolem captain = (EntityStoneGolem)this.stoneGolem.getCaptain();
        if (captain == null) {
            return false;
        }
        if (this.stoneGolem.isSitting()) {
            return false;
        }
        if (this.stoneGolem.func_70068_e((Entity)captain) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.captain = captain;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.stoneGolem.func_70068_e((Entity)this.captain) > (double)(this.maxDist * this.maxDist) && !this.stoneGolem.isSitting();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.stoneGolem.func_184643_a(PathNodeType.WATER);
        this.stoneGolem.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.captain = null;
        this.petPathfinder.func_75499_g();
        this.stoneGolem.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        double d = 144.0;
        this.stoneGolem.func_70671_ap().func_75651_a((Entity)this.captain, 10.0f, (float)this.stoneGolem.func_70646_bf());
        if (!this.stoneGolem.isSitting() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.petPathfinder.func_75497_a((Entity)this.captain, this.followSpeed) && !this.stoneGolem.func_110167_bD() && !this.stoneGolem.func_184218_aH() && this.stoneGolem.func_70068_e((Entity)this.captain) >= d) {
                int i = MathHelper.func_76128_c((double)this.captain.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.captain.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.captain.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                        this.stoneGolem.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.stoneGolem.field_70177_z, this.stoneGolem.field_70125_A);
                        this.petPathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(int x, int p_192381_2_, int y, int p_192381_4_, int p_192381_5_) {
        BlockPos blockpos = new BlockPos(x + p_192381_4_, y - 1, p_192381_2_ + p_192381_5_);
        IBlockState iblockstate = this.world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.stoneGolem) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
    }
}

