/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.util.handlers;

import java.util.function.IntFunction;
import lily.golemist.GolemistBlocks;
import lily.golemist.GolemistItems;
import lily.golemist.util.handlers.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])GolemistItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])GolemistBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : GolemistItems.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : GolemistBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries() {
    }

    public static void initRegistries() {
    }

    public static void postInitRegistries() {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
    }

    public static void init(FMLInitializationEvent event) {
    }

    public static void postInit(FMLPostInitializationEvent event) {
    }

    public static void registerCustomItemblock(Block b, String path) {
        RegistryHandler.registerCustomItemblock(b, 1, i -> path);
    }

    public static void registerCustomItemblock(Block b, int maxExclusive, IntFunction<String> metaToPath) {
        Item item = Item.func_150898_a((Block)b);
        for (int i = 0; i < maxExclusive; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation("golemist:itemblock/" + metaToPath.apply(i), "inventory"));
        }
    }

    public void preInit() {
    }
}

