/*
 * Decompiled with CFR 0.152.
 */
package lily.golemist.util.handlers;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lily.golemist.common.entity.EntityUniqueGolem;
import lily.golemist.util.handlers.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class UniqueGolemUtils {
    public static ConfigHandler config;
    public static Entity lastTarget;
    private static final Set<Item> THROW;
    private static final Set<Item> STICK_WEAPONS;
    private static final Set<Item> SHIELD_ABLE;

    public static boolean isThrowableItems(ItemStack stack) {
        return THROW.contains(stack.func_77973_b());
    }

    public static boolean isStickWeapon(ItemStack stack) {
        return STICK_WEAPONS.contains(stack.func_77973_b());
    }

    public static boolean isShieldAble(ItemStack stack) {
        return SHIELD_ABLE.contains(stack.func_77973_b());
    }

    public static boolean Disadvantage(EntityUniqueGolem golem, EntityPlayer owner, EntityLivingBase target) {
        if (golem.func_110143_aJ() < golem.func_110138_aP() / 2.0f || golem.func_110143_aJ() <= target.func_110143_aJ() - 5.0f) {
            return true;
        }
        return owner.func_110143_aJ() < owner.func_110138_aP() / 2.0f || owner.func_110143_aJ() <= target.func_110143_aJ() - 5.0f;
    }

    public static boolean ThrowableItemInInventory(EntityUniqueGolem golem) {
        InventoryBasic golemInventory = golem.getGolemInventory();
        for (int i = 0; i < golemInventory.func_70302_i_(); ++i) {
            ItemStack itemstack = golemInventory.func_70301_a(i);
            if (!UniqueGolemUtils.isThrowableItems(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack ThrowItem(EntityUniqueGolem golem) {
        InventoryBasic golemInventory = golem.getGolemInventory();
        ItemStack throwItem = ItemStack.field_190927_a;
        for (int i = 0; i < golemInventory.func_70302_i_(); ++i) {
            ItemStack thowItem;
            ItemStack itemstack = golemInventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            Item item = itemstack.func_77973_b();
            if (item == Items.field_151130_bT && itemstack.func_190916_E() >= 1) {
                thowItem = itemstack;
                if (golem.field_70170_p.field_72995_K) continue;
                itemstack.func_190918_g(1);
                return thowItem;
            }
            if (item == Items.field_151118_aC && itemstack.func_190916_E() >= 1) {
                thowItem = itemstack;
                if (golem.field_70170_p.field_72995_K) continue;
                itemstack.func_190918_g(1);
                return thowItem;
            }
            if (item != Items.field_151145_ak || itemstack.func_190916_E() < 1) continue;
            thowItem = itemstack;
            if (golem.field_70170_p.field_72995_K) continue;
            itemstack.func_190918_g(1);
            return thowItem;
        }
        return null;
    }

    public static boolean IndirectAble(EntityUniqueGolem golem, EntityPlayer owner, EntityLivingBase target) {
        if (UniqueGolemUtils.Disadvantage(golem, owner, target) && UniqueGolemUtils.ThrowableItemInInventory(golem)) {
            double d0 = golem.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
            if (d0 >= 14.5) {
                return true;
            }
            if (target.func_180425_c().func_177956_o() >= golem.func_180425_c().func_177956_o() + 2 || target.func_180425_c().func_177956_o() <= golem.func_180425_c().func_177956_o() - 2) {
                return true;
            }
        }
        return false;
    }

    public static void ChangeAttackMode(EntityUniqueGolem golem, boolean shouldRangedAttack) {
        if (shouldRangedAttack) {
            golem.field_70714_bg.func_75776_a(5, (EntityAIBase)golem.aiRange);
            golem.field_70714_bg.func_85156_a((EntityAIBase)golem.aiMelee);
        } else {
            golem.field_70714_bg.func_75776_a(5, (EntityAIBase)golem.aiMelee);
            golem.field_70714_bg.func_85156_a((EntityAIBase)golem.aiRange);
        }
    }

    public static double getDamage(EntityUniqueGolem golem, Entity entityIn) {
        double d = golem.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        HashMap<Object, Object> objEntities = new HashMap();
        int intSkillBonus = 0;
        float targetHealth = ((EntityLivingBase)entityIn).func_110138_aP();
        objEntities = UniqueGolemUtils.deserializeKillCount(golem.getKillCount());
        String strEntityName = entityIn.getClass().getName();
        int intKillCount = 0;
        float kc = 0.0f;
        int intTotalKillCount = golem.getTotalKillCount();
        float tkc = intTotalKillCount;
        intSkillBonus = golem.getStickSkill();
        float sb = intSkillBonus;
        if (objEntities.containsKey(strEntityName)) {
            intKillCount = (Integer)objEntities.get(strEntityName);
            kc = intKillCount;
            if ((float)intKillCount > targetHealth * (float)ConfigHandler.killCountDamageLimit) {
                intKillCount = (int)(targetHealth * (float)ConfigHandler.killCountDamageLimit);
            }
        }
        if (intTotalKillCount > ConfigHandler.totalKillCountLimit) {
            intTotalKillCount = ConfigHandler.totalKillCountLimit;
        }
        if (golem.getWeaponType() == 2) {
            if (intSkillBonus > ConfigHandler.weaponSkillCountLimit) {
                intSkillBonus = ConfigHandler.weaponSkillCountLimit;
            }
        }
        d += (double)(intKillCount / ConfigHandler.killCountDamageBonusRatio);
        d += (double)(intTotalKillCount / ConfigHandler.totalKillCountDamageBonusRatio);
        d += (double)(intSkillBonus / ConfigHandler.weaponSkillDamageBonusRatio);
        if (golem.getInfo() && lastTarget != entityIn) {
            golem.getOwner().func_145747_a((ITextComponent)new TextComponentString("Target " + entityIn.func_70005_c_() + " " + golem.func_70005_c_() + " Base Attack " + golem.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + " KillCount " + (int)kc + " TotalKill " + (int)tkc + " WeaponSkill " + (int)sb));
            golem.getOwner().func_145747_a((ITextComponent)new TextComponentString("Offensive ability of the golem  = " + golem.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + " + " + (float)intKillCount / (float)ConfigHandler.killCountDamageBonusRatio + " + " + (float)intTotalKillCount / (float)ConfigHandler.totalKillCountDamageBonusRatio + " + " + (float)intSkillBonus / (float)ConfigHandler.weaponSkillDamageBonusRatio));
            lastTarget = entityIn;
        }
        return d;
    }

    private static String serializeKillCount(HashMap<String, Integer> objEntities) {
        StringBuilder strKillCountSerialize = new StringBuilder();
        for (Map.Entry<String, Integer> objEntity : objEntities.entrySet()) {
            strKillCountSerialize.append(objEntity.getKey() + "," + objEntity.getValue() + "|");
        }
        return strKillCountSerialize.toString().substring(0, strKillCountSerialize.toString().length() - 1);
    }

    public static HashMap<String, Integer> deserializeKillCount(String strKillCountSerialize) {
        HashMap<String, Integer> objEntities = new HashMap<String, Integer>();
        if (strKillCountSerialize.length() >= 1) {
            String[] strEntities;
            for (String strEntity : strEntities = strKillCountSerialize.split("\\|")) {
                String[] strKeyValue = strEntity.split(",");
                objEntities.put(strKeyValue[0], Integer.parseInt(strKeyValue[1]));
            }
        }
        return objEntities;
    }

    public static String addKillCount(EntityLivingBase target, String strKillCountSerialize) {
        HashMap<Object, Object> objEntities = new HashMap();
        if (strKillCountSerialize.length() >= 1) {
            objEntities = UniqueGolemUtils.deserializeKillCount(strKillCountSerialize);
        }
        String strEntityName = target.getClass().getName();
        int intKillCount = 0;
        if (objEntities.containsKey(strEntityName)) {
            intKillCount = (Integer)objEntities.get(strEntityName);
        }
        objEntities.put(strEntityName, ++intKillCount);
        return UniqueGolemUtils.serializeKillCount(objEntities);
    }

    static {
        THROW = Sets.newHashSet((Object[])new Item[]{Items.field_151145_ak, Items.field_151118_aC, Items.field_151130_bT});
        STICK_WEAPONS = Sets.newHashSet((Object[])new Item[]{Items.field_151055_y, Items.field_151103_aS, Item.func_150898_a((Block)Blocks.field_150411_aY), Items.field_151072_bj, Item.func_150898_a((Block)Blocks.field_185764_cQ)});
        SHIELD_ABLE = Sets.newHashSet((Object[])new Item[]{Item.func_150898_a((Block)Blocks.field_150452_aw), Item.func_150898_a((Block)Blocks.field_150456_au), Item.func_150898_a((Block)Blocks.field_150443_bT)});
    }

    public static enum EnumIdeas {
        STICK("Stick", 0);

        private final String name;
        private final int stage;

        private EnumIdeas(String nameIn, int stageIn) {
            this.name = nameIn;
            this.stage = stageIn;
        }

        public String getName() {
            return this.name;
        }

        public int getStage() {
            return this.stage;
        }
    }
}

