local G = GLOBAL

local TextureReplace = {
	['twigs.tex'] = {
		G.resolvefilepath('Twigs4K.xml'),
		'Twigs4K.tex',
		64 / 4096
	},
}

Assets = {
	Asset('ATLAS', 'Twigs4K.xml')
}

local Image = G.require('widgets/image')

local SetTexture_old = Image.SetTexture

local function SetTexture_new(self, atlas, tex, ...)
	local replace = TextureReplace[tex] or nil

	if replace == nil then
		SetTexture_old(self, atlas, tex, ...)
		return
	end

	SetTexture_old(self, replace[1] or atlas, replace[2] or tex, ...)

	local scale = replace[3] or nil

	if scale == nil then
		return
	end

	self.inst.UITransform:SetScale(scale, scale, scale)
end

Image.SetTexture = SetTexture_new
