// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: installer.proto

package installer

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Status defines the status of this progress message.
// If the status is one of (StatusCompleted, StatusCompletedPending, StatusAborted), this response is the last response sent
type ProgressResponse_Status int32

const (
	// StatusUnknown indicates the unknown progress
	StatusUnknown ProgressResponse_Status = 0
	// StatusCompleted status indicates that the operation has successfully completed.
	// This status is terminal - no more progress messages will follow
	StatusCompleted ProgressResponse_Status = 1
	// StatusCompletedPending status indicates that the operation has successfully completed
	// but the installer process will continue running to enable post-install tasks.
	// This status is terminal - no more progress messages will follow
	StatusCompletedPending ProgressResponse_Status = 2
	// StatusAborted status indicates that the operation has been aborted.
	// This status is terminal - no more progress messages will follow
	StatusAborted ProgressResponse_Status = 3
)

var ProgressResponse_Status_name = map[int32]string{
	0: "UNKNOWN",
	1: "COMPLETED",
	2: "COMPLETED_PENDING",
	3: "ABORTED",
}

var ProgressResponse_Status_value = map[string]int32{
	"UNKNOWN":           0,
	"COMPLETED":         1,
	"COMPLETED_PENDING": 2,
	"ABORTED":           3,
}

func (ProgressResponse_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{7, 0}
}

// Phase represents an operation plan phase
type Phase struct {
	// ID specifies the phase ID
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Key identifies the operation
	Key *OperationKey `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Rollback specifies whether this is a rollback
	Rollback bool `protobuf:"varint,3,opt,name=rollback,proto3" json:"rollback,omitempty"`
	// Force specifies whether the phase execution/rollback should be rerun
	// regardless of phase state
	Force                bool     `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Phase) Reset()         { *m = Phase{} }
func (m *Phase) String() string { return proto.CompactTextString(m) }
func (*Phase) ProtoMessage()    {}
func (*Phase) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{0}
}
func (m *Phase) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Phase.Unmarshal(m, b)
}
func (m *Phase) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Phase.Marshal(b, m, deterministic)
}
func (m *Phase) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Phase.Merge(m, src)
}
func (m *Phase) XXX_Size() int {
	return xxx_messageInfo_Phase.Size(m)
}
func (m *Phase) XXX_DiscardUnknown() {
	xxx_messageInfo_Phase.DiscardUnknown(m)
}

var xxx_messageInfo_Phase proto.InternalMessageInfo

func (m *Phase) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Phase) GetKey() *OperationKey {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *Phase) GetRollback() bool {
	if m != nil {
		return m.Rollback
	}
	return false
}

func (m *Phase) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// ExecuteRequest describes a request to execute install operation
type ExecuteRequest struct {
	// Phase optionally specifies the configuration for executing or rolling
	// back a specific phase.
	// If unspecified, the operation is executed from the beginning
	Phase                *Phase   `protobuf:"bytes,1,opt,name=phase,proto3" json:"phase,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecuteRequest) Reset()         { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()    {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{1}
}
func (m *ExecuteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteRequest.Unmarshal(m, b)
}
func (m *ExecuteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteRequest.Marshal(b, m, deterministic)
}
func (m *ExecuteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteRequest.Merge(m, src)
}
func (m *ExecuteRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteRequest.Size(m)
}
func (m *ExecuteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteRequest proto.InternalMessageInfo

func (m *ExecuteRequest) GetPhase() *Phase {
	if m != nil {
		return m.Phase
	}
	return nil
}

// SetStateRequest describes a request to explicitly set phase state
type SetStateRequest struct {
	// Phase describes the phase to set the state for
	Phase *Phase `protobuf:"bytes,1,opt,name=phase,proto3" json:"phase,omitempty"`
	// State is the new phase state
	State                string   `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetStateRequest) Reset()         { *m = SetStateRequest{} }
func (m *SetStateRequest) String() string { return proto.CompactTextString(m) }
func (*SetStateRequest) ProtoMessage()    {}
func (*SetStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{2}
}
func (m *SetStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetStateRequest.Unmarshal(m, b)
}
func (m *SetStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetStateRequest.Marshal(b, m, deterministic)
}
func (m *SetStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetStateRequest.Merge(m, src)
}
func (m *SetStateRequest) XXX_Size() int {
	return xxx_messageInfo_SetStateRequest.Size(m)
}
func (m *SetStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetStateRequest proto.InternalMessageInfo

func (m *SetStateRequest) GetPhase() *Phase {
	if m != nil {
		return m.Phase
	}
	return nil
}

func (m *SetStateRequest) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

// CompleteRequest describes a request to manually complete the operation
type CompleteRequest struct {
	// Key identifies the operation
	Key                  *OperationKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CompleteRequest) Reset()         { *m = CompleteRequest{} }
func (m *CompleteRequest) String() string { return proto.CompactTextString(m) }
func (*CompleteRequest) ProtoMessage()    {}
func (*CompleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{3}
}
func (m *CompleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompleteRequest.Unmarshal(m, b)
}
func (m *CompleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompleteRequest.Marshal(b, m, deterministic)
}
func (m *CompleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompleteRequest.Merge(m, src)
}
func (m *CompleteRequest) XXX_Size() int {
	return xxx_messageInfo_CompleteRequest.Size(m)
}
func (m *CompleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CompleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CompleteRequest proto.InternalMessageInfo

func (m *CompleteRequest) GetKey() *OperationKey {
	if m != nil {
		return m.Key
	}
	return nil
}

// AbortRequest describes a request to abort the operation and clean up
type AbortRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AbortRequest) Reset()         { *m = AbortRequest{} }
func (m *AbortRequest) String() string { return proto.CompactTextString(m) }
func (*AbortRequest) ProtoMessage()    {}
func (*AbortRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{4}
}
func (m *AbortRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AbortRequest.Unmarshal(m, b)
}
func (m *AbortRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AbortRequest.Marshal(b, m, deterministic)
}
func (m *AbortRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AbortRequest.Merge(m, src)
}
func (m *AbortRequest) XXX_Size() int {
	return xxx_messageInfo_AbortRequest.Size(m)
}
func (m *AbortRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AbortRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AbortRequest proto.InternalMessageInfo

// ShutdownRequest describes a request to shut down the server
type ShutdownRequest struct {
	// Completed indicates that the operation has been successfully completed
	Completed bool `protobuf:"varint,1,opt,name=completed,proto3" json:"completed,omitempty"`
	// ExitCode optionally specifies the exit code for the service.
	// 0 value is considered success
	ExitCode             int32    `protobuf:"varint,2,opt,name=exitCode,proto3" json:"exitCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShutdownRequest) Reset()         { *m = ShutdownRequest{} }
func (m *ShutdownRequest) String() string { return proto.CompactTextString(m) }
func (*ShutdownRequest) ProtoMessage()    {}
func (*ShutdownRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{5}
}
func (m *ShutdownRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShutdownRequest.Unmarshal(m, b)
}
func (m *ShutdownRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShutdownRequest.Marshal(b, m, deterministic)
}
func (m *ShutdownRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShutdownRequest.Merge(m, src)
}
func (m *ShutdownRequest) XXX_Size() int {
	return xxx_messageInfo_ShutdownRequest.Size(m)
}
func (m *ShutdownRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ShutdownRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ShutdownRequest proto.InternalMessageInfo

func (m *ShutdownRequest) GetCompleted() bool {
	if m != nil {
		return m.Completed
	}
	return false
}

func (m *ShutdownRequest) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

// DebugReportRequest describes a request to generate debug report
type DebugReportRequest struct {
	// Path specifies the path to the report file
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugReportRequest) Reset()         { *m = DebugReportRequest{} }
func (m *DebugReportRequest) String() string { return proto.CompactTextString(m) }
func (*DebugReportRequest) ProtoMessage()    {}
func (*DebugReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{6}
}
func (m *DebugReportRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebugReportRequest.Unmarshal(m, b)
}
func (m *DebugReportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebugReportRequest.Marshal(b, m, deterministic)
}
func (m *DebugReportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugReportRequest.Merge(m, src)
}
func (m *DebugReportRequest) XXX_Size() int {
	return xxx_messageInfo_DebugReportRequest.Size(m)
}
func (m *DebugReportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugReportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DebugReportRequest proto.InternalMessageInfo

func (m *DebugReportRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// ProgressResponse describes a single progress step
type ProgressResponse struct {
	// Message specifies the progress message
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Status describes the status of this response
	Status ProgressResponse_Status `protobuf:"varint,2,opt,name=status,proto3,enum=installer.ProgressResponse_Status" json:"status,omitempty"`
	// Error specifies the error for this progress step
	Error                *Error   `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProgressResponse) Reset()         { *m = ProgressResponse{} }
func (m *ProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ProgressResponse) ProtoMessage()    {}
func (*ProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{7}
}
func (m *ProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProgressResponse.Unmarshal(m, b)
}
func (m *ProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProgressResponse.Marshal(b, m, deterministic)
}
func (m *ProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProgressResponse.Merge(m, src)
}
func (m *ProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ProgressResponse.Size(m)
}
func (m *ProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProgressResponse proto.InternalMessageInfo

func (m *ProgressResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ProgressResponse) GetStatus() ProgressResponse_Status {
	if m != nil {
		return m.Status
	}
	return StatusUnknown
}

func (m *ProgressResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

// Error represents an error in the operation
type Error struct {
	// Message specifies the error message
	Message              string   `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Error) Reset()         { *m = Error{} }
func (m *Error) String() string { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()    {}
func (*Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{8}
}
func (m *Error) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Error.Unmarshal(m, b)
}
func (m *Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Error.Marshal(b, m, deterministic)
}
func (m *Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Error.Merge(m, src)
}
func (m *Error) XXX_Size() int {
	return xxx_messageInfo_Error.Size(m)
}
func (m *Error) XXX_DiscardUnknown() {
	xxx_messageInfo_Error.DiscardUnknown(m)
}

var xxx_messageInfo_Error proto.InternalMessageInfo

func (m *Error) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// OperationKey describes a cluster operation
type OperationKey struct {
	// AccountID refers to the account this operation belongs to
	AccountID string `protobuf:"bytes,1,opt,name=account_id,json=accountId,proto3" json:"account_id,omitempty"`
	// ClusterName identifies the cluster for the operation
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// ID specifies the operation ID
	ID                   string   `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationKey) Reset()         { *m = OperationKey{} }
func (m *OperationKey) String() string { return proto.CompactTextString(m) }
func (*OperationKey) ProtoMessage()    {}
func (*OperationKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_675879a591bd3155, []int{9}
}
func (m *OperationKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationKey.Unmarshal(m, b)
}
func (m *OperationKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationKey.Marshal(b, m, deterministic)
}
func (m *OperationKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationKey.Merge(m, src)
}
func (m *OperationKey) XXX_Size() int {
	return xxx_messageInfo_OperationKey.Size(m)
}
func (m *OperationKey) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationKey.DiscardUnknown(m)
}

var xxx_messageInfo_OperationKey proto.InternalMessageInfo

func (m *OperationKey) GetAccountID() string {
	if m != nil {
		return m.AccountID
	}
	return ""
}

func (m *OperationKey) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *OperationKey) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func init() {
	proto.RegisterEnum("installer.ProgressResponse_Status", ProgressResponse_Status_name, ProgressResponse_Status_value)
	proto.RegisterType((*Phase)(nil), "installer.Phase")
	proto.RegisterType((*ExecuteRequest)(nil), "installer.ExecuteRequest")
	proto.RegisterType((*SetStateRequest)(nil), "installer.SetStateRequest")
	proto.RegisterType((*CompleteRequest)(nil), "installer.CompleteRequest")
	proto.RegisterType((*AbortRequest)(nil), "installer.AbortRequest")
	proto.RegisterType((*ShutdownRequest)(nil), "installer.ShutdownRequest")
	proto.RegisterType((*DebugReportRequest)(nil), "installer.DebugReportRequest")
	proto.RegisterType((*ProgressResponse)(nil), "installer.ProgressResponse")
	proto.RegisterType((*Error)(nil), "installer.Error")
	proto.RegisterType((*OperationKey)(nil), "installer.OperationKey")
}

func init() { proto.RegisterFile("installer.proto", fileDescriptor_675879a591bd3155) }

var fileDescriptor_675879a591bd3155 = []byte{
	// 697 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xcd, 0x4e, 0xdb, 0x4a,
	0x14, 0xc6, 0x09, 0x0e, 0xf1, 0x09, 0x90, 0x30, 0x5c, 0x71, 0x73, 0xcd, 0x6d, 0x48, 0xbd, 0xa8,
	0x52, 0xa9, 0x0a, 0x6d, 0xba, 0x41, 0x55, 0x55, 0x29, 0x24, 0x11, 0x8a, 0xa0, 0x49, 0x34, 0x29,
	0xea, 0x12, 0x39, 0xf6, 0xc1, 0x44, 0x38, 0x1e, 0xd7, 0x1e, 0x0b, 0x90, 0xfa, 0x00, 0x88, 0x75,
	0xb7, 0xac, 0xca, 0xa2, 0xfb, 0xee, 0xfa, 0x00, 0x7d, 0x0c, 0x16, 0x3c, 0x49, 0x65, 0x8f, 0x93,
	0x38, 0xa9, 0x42, 0xd5, 0x9d, 0xcf, 0xcf, 0x77, 0xbe, 0xf3, 0xe3, 0x6f, 0x20, 0x3f, 0x74, 0x7c,
	0xae, 0xdb, 0x36, 0x7a, 0x55, 0xd7, 0x63, 0x9c, 0x11, 0x65, 0xe2, 0x50, 0xb7, 0x2d, 0xc6, 0x2c,
	0x1b, 0x77, 0xa3, 0xc0, 0x20, 0x38, 0xdd, 0xc5, 0x91, 0xcb, 0xaf, 0x44, 0x9e, 0x0a, 0x16, 0xb3,
	0x98, 0xf8, 0xd6, 0x3e, 0x83, 0xdc, 0x3b, 0xd3, 0x7d, 0x24, 0x5b, 0x90, 0x1a, 0x9a, 0x45, 0xa9,
	0x2c, 0x55, 0x94, 0xfd, 0xcc, 0xc3, 0xfd, 0x4e, 0xaa, 0xdd, 0xa4, 0xa9, 0xa1, 0x49, 0x9e, 0x43,
	0xfa, 0x1c, 0xaf, 0x8a, 0xa9, 0xb2, 0x54, 0xc9, 0xd5, 0xfe, 0xad, 0x4e, 0x39, 0xbb, 0x2e, 0x7a,
	0x3a, 0x1f, 0x32, 0xe7, 0x10, 0xaf, 0x68, 0x98, 0x43, 0x54, 0xc8, 0x7a, 0xcc, 0xb6, 0x07, 0xba,
	0x71, 0x5e, 0x4c, 0x97, 0xa5, 0x4a, 0x96, 0x4e, 0x6c, 0xf2, 0x0f, 0xc8, 0xa7, 0xcc, 0x33, 0xb0,
	0xb8, 0x1c, 0x05, 0x84, 0xa1, 0xed, 0xc1, 0x7a, 0xeb, 0x12, 0x8d, 0x80, 0x23, 0xc5, 0x4f, 0x01,
	0xfa, 0x9c, 0x3c, 0x03, 0xd9, 0x0d, 0xfb, 0x89, 0x3a, 0xc9, 0xd5, 0x0a, 0x09, 0xc2, 0xa8, 0x4f,
	0x2a, 0xc2, 0x5a, 0x17, 0xf2, 0x7d, 0xe4, 0x7d, 0xae, 0xff, 0x35, 0x34, 0x6c, 0xc5, 0x0f, 0x71,
	0xd1, 0x4c, 0x0a, 0x15, 0x86, 0xf6, 0x16, 0xf2, 0x0d, 0x36, 0x72, 0x6d, 0x9c, 0x16, 0x8c, 0x47,
	0x97, 0xfe, 0x3c, 0xba, 0xb6, 0x0e, 0xab, 0xf5, 0x01, 0xf3, 0x78, 0x0c, 0xd5, 0x0e, 0x21, 0xdf,
	0x3f, 0x0b, 0xb8, 0xc9, 0x2e, 0x9c, 0x71, 0xb5, 0xff, 0x41, 0x31, 0x62, 0x02, 0xb1, 0xe7, 0x2c,
	0x9d, 0x3a, 0xc2, 0xdd, 0xe1, 0xe5, 0x90, 0x37, 0x98, 0x29, 0xfa, 0x92, 0xe9, 0xc4, 0xd6, 0x2a,
	0x40, 0x9a, 0x38, 0x08, 0x2c, 0x8a, 0xee, 0x94, 0x82, 0x10, 0x58, 0x76, 0x75, 0x7e, 0x26, 0x4e,
	0x46, 0xa3, 0x6f, 0xed, 0x67, 0x0a, 0x0a, 0x3d, 0x8f, 0x59, 0x1e, 0xfa, 0x3e, 0x45, 0xdf, 0x65,
	0x8e, 0x8f, 0xa4, 0x08, 0x2b, 0x23, 0xf4, 0x7d, 0xdd, 0xc2, 0x38, 0x77, 0x6c, 0x92, 0x37, 0x90,
	0x09, 0x87, 0x0f, 0xfc, 0x88, 0x72, 0xbd, 0xa6, 0x25, 0x57, 0x36, 0x57, 0xa6, 0xda, 0x8f, 0x32,
	0x69, 0x8c, 0x08, 0xb7, 0x8d, 0x9e, 0xc7, 0xbc, 0xe8, 0xd2, 0xb3, 0xdb, 0x6e, 0x85, 0x7e, 0x2a,
	0xc2, 0xda, 0x77, 0x09, 0x32, 0x02, 0x4a, 0x4a, 0xb0, 0x72, 0xdc, 0x39, 0xec, 0x74, 0x3f, 0x76,
	0x0a, 0x4b, 0xea, 0xc6, 0xcd, 0x6d, 0x79, 0x4d, 0x04, 0x8e, 0x9d, 0x73, 0x87, 0x5d, 0x38, 0x44,
	0x03, 0xa5, 0xd1, 0x7d, 0xdf, 0x3b, 0x6a, 0x7d, 0x68, 0x35, 0x0b, 0x92, 0xba, 0x79, 0x73, 0x5b,
	0xce, 0x8b, 0x8c, 0xc6, 0x64, 0x4f, 0xaf, 0x60, 0x63, 0x92, 0x73, 0xd2, 0x6b, 0x75, 0x9a, 0xed,
	0xce, 0x41, 0x21, 0xa5, 0xaa, 0x37, 0xb7, 0xe5, 0xad, 0xb9, 0xdc, 0x1e, 0x3a, 0xe6, 0xd0, 0xb1,
	0x42, 0xda, 0xfa, 0x7e, 0x97, 0x86, 0x45, 0xd3, 0x49, 0xda, 0xe8, 0x60, 0x68, 0xaa, 0xe4, 0xfa,
	0x6b, 0x69, 0xe9, 0xdb, 0x5d, 0x69, 0xe9, 0xc7, 0x5d, 0x29, 0x6e, 0x55, 0x7b, 0x0a, 0x72, 0x34,
	0xc5, 0xe2, 0xe5, 0x69, 0xd7, 0x12, 0xac, 0x26, 0x7f, 0x04, 0xf2, 0x02, 0x40, 0x37, 0x0c, 0x16,
	0x38, 0xfc, 0x64, 0xa2, 0xa4, 0xb5, 0x87, 0xfb, 0x1d, 0xa5, 0x2e, 0xbc, 0xed, 0x26, 0x55, 0xe2,
	0x84, 0xb6, 0x49, 0x6a, 0xb0, 0x6a, 0xd8, 0x81, 0xcf, 0xd1, 0x3b, 0x71, 0xf4, 0x51, 0xfc, 0x33,
	0xee, 0xe7, 0x1f, 0xee, 0x77, 0x72, 0x0d, 0xe1, 0xef, 0xe8, 0x23, 0xa4, 0x39, 0x63, 0x6a, 0xc4,
	0x1a, 0x4d, 0xcf, 0x6b, 0xb4, 0xf6, 0x25, 0x0d, 0x72, 0xdd, 0x42, 0x87, 0x93, 0x06, 0xac, 0xc4,
	0x82, 0x22, 0xff, 0x25, 0x2f, 0x32, 0x23, 0x32, 0x75, 0xfb, 0x91, 0x3b, 0xbf, 0x94, 0xc8, 0x3b,
	0xc8, 0x8e, 0x97, 0x48, 0xd4, 0x44, 0xea, 0x9c, 0x3e, 0xd4, 0xad, 0xaa, 0x78, 0x65, 0xaa, 0xe3,
	0x57, 0xa6, 0xda, 0x0a, 0x5f, 0x99, 0x10, 0x3f, 0xd6, 0xe6, 0x0c, 0x7e, 0x4e, 0xb0, 0x0b, 0xf1,
	0x7b, 0x20, 0x47, 0xb7, 0x21, 0x49, 0xcd, 0x25, 0xe5, 0xf5, 0x28, 0x73, 0x2c, 0xbb, 0x59, 0xe6,
	0x59, 0x2d, 0x2e, 0xc4, 0x1f, 0xc1, 0xe6, 0x01, 0x3a, 0xe1, 0x4d, 0x31, 0xa1, 0x38, 0xf2, 0x24,
	0x51, 0xea, 0x77, 0x25, 0x2e, 0xaa, 0x36, 0xc8, 0x44, 0xf6, 0xeb, 0x5f, 0x01, 0x00, 0x00, 0xff,
	0xff, 0x3d, 0x71, 0x20, 0x38, 0xa9, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AgentClient is the client API for Agent service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentClient interface {
	// Execute runs the operation specified with request.
	// If the client drops disconnects in the middle of the operation,
	// it can reconnect later and continue receiving progress updates
	// until the operation has completed
	Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (Agent_ExecuteClient, error)
	// Complete marks the operation as completed
	Complete(ctx context.Context, in *CompleteRequest, opts ...grpc.CallOption) (*types.Empty, error)
	// SetState sets the specified phase state without executing it
	SetState(ctx context.Context, in *SetStateRequest, opts ...grpc.CallOption) (*types.Empty, error)
	// Abort requests that the installer service aborts
	Abort(ctx context.Context, in *AbortRequest, opts ...grpc.CallOption) (*types.Empty, error)
	// Shutdown requests that the installer service shuts down gracefully
	Shutdown(ctx context.Context, in *ShutdownRequest, opts ...grpc.CallOption) (*types.Empty, error)
	// GenerateDebugReport requests the installer to generate a debug report
	GenerateDebugReport(ctx context.Context, in *DebugReportRequest, opts ...grpc.CallOption) (*types.Empty, error)
}

type agentClient struct {
	cc *grpc.ClientConn
}

func NewAgentClient(cc *grpc.ClientConn) AgentClient {
	return &agentClient{cc}
}

func (c *agentClient) Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (Agent_ExecuteClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Agent_serviceDesc.Streams[0], "/installer.Agent/Execute", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentExecuteClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Agent_ExecuteClient interface {
	Recv() (*ProgressResponse, error)
	grpc.ClientStream
}

type agentExecuteClient struct {
	grpc.ClientStream
}

func (x *agentExecuteClient) Recv() (*ProgressResponse, error) {
	m := new(ProgressResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentClient) Complete(ctx context.Context, in *CompleteRequest, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/installer.Agent/Complete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) SetState(ctx context.Context, in *SetStateRequest, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/installer.Agent/SetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) Abort(ctx context.Context, in *AbortRequest, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/installer.Agent/Abort", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) Shutdown(ctx context.Context, in *ShutdownRequest, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/installer.Agent/Shutdown", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) GenerateDebugReport(ctx context.Context, in *DebugReportRequest, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/installer.Agent/GenerateDebugReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentServer is the server API for Agent service.
type AgentServer interface {
	// Execute runs the operation specified with request.
	// If the client drops disconnects in the middle of the operation,
	// it can reconnect later and continue receiving progress updates
	// until the operation has completed
	Execute(*ExecuteRequest, Agent_ExecuteServer) error
	// Complete marks the operation as completed
	Complete(context.Context, *CompleteRequest) (*types.Empty, error)
	// SetState sets the specified phase state without executing it
	SetState(context.Context, *SetStateRequest) (*types.Empty, error)
	// Abort requests that the installer service aborts
	Abort(context.Context, *AbortRequest) (*types.Empty, error)
	// Shutdown requests that the installer service shuts down gracefully
	Shutdown(context.Context, *ShutdownRequest) (*types.Empty, error)
	// GenerateDebugReport requests the installer to generate a debug report
	GenerateDebugReport(context.Context, *DebugReportRequest) (*types.Empty, error)
}

// UnimplementedAgentServer can be embedded to have forward compatible implementations.
type UnimplementedAgentServer struct {
}

func (*UnimplementedAgentServer) Execute(req *ExecuteRequest, srv Agent_ExecuteServer) error {
	return status.Errorf(codes.Unimplemented, "method Execute not implemented")
}
func (*UnimplementedAgentServer) Complete(ctx context.Context, req *CompleteRequest) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Complete not implemented")
}
func (*UnimplementedAgentServer) SetState(ctx context.Context, req *SetStateRequest) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetState not implemented")
}
func (*UnimplementedAgentServer) Abort(ctx context.Context, req *AbortRequest) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Abort not implemented")
}
func (*UnimplementedAgentServer) Shutdown(ctx context.Context, req *ShutdownRequest) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Shutdown not implemented")
}
func (*UnimplementedAgentServer) GenerateDebugReport(ctx context.Context, req *DebugReportRequest) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateDebugReport not implemented")
}

func RegisterAgentServer(s *grpc.Server, srv AgentServer) {
	s.RegisterService(&_Agent_serviceDesc, srv)
}

func _Agent_Execute_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AgentServer).Execute(m, &agentExecuteServer{stream})
}

type Agent_ExecuteServer interface {
	Send(*ProgressResponse) error
	grpc.ServerStream
}

type agentExecuteServer struct {
	grpc.ServerStream
}

func (x *agentExecuteServer) Send(m *ProgressResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Agent_Complete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).Complete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/installer.Agent/Complete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).Complete(ctx, req.(*CompleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_SetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).SetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/installer.Agent/SetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).SetState(ctx, req.(*SetStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_Abort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AbortRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).Abort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/installer.Agent/Abort",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).Abort(ctx, req.(*AbortRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_Shutdown_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShutdownRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).Shutdown(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/installer.Agent/Shutdown",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).Shutdown(ctx, req.(*ShutdownRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_GenerateDebugReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DebugReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).GenerateDebugReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/installer.Agent/GenerateDebugReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).GenerateDebugReport(ctx, req.(*DebugReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Agent_serviceDesc = grpc.ServiceDesc{
	ServiceName: "installer.Agent",
	HandlerType: (*AgentServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Complete",
			Handler:    _Agent_Complete_Handler,
		},
		{
			MethodName: "SetState",
			Handler:    _Agent_SetState_Handler,
		},
		{
			MethodName: "Abort",
			Handler:    _Agent_Abort_Handler,
		},
		{
			MethodName: "Shutdown",
			Handler:    _Agent_Shutdown_Handler,
		},
		{
			MethodName: "GenerateDebugReport",
			Handler:    _Agent_GenerateDebugReport_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Execute",
			Handler:       _Agent_Execute_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "installer.proto",
}
