// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: agent.proto

package proto

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ExecOutput_FD int32

const (
	ExecOutput_STDOUT ExecOutput_FD = 0
	ExecOutput_STDERR ExecOutput_FD = 1
)

var ExecOutput_FD_name = map[int32]string{
	0: "STDOUT",
	1: "STDERR",
}

var ExecOutput_FD_value = map[string]int32{
	"STDOUT": 0,
	"STDERR": 1,
}

func (x ExecOutput_FD) String() string {
	return proto.EnumName(ExecOutput_FD_name, int32(x))
}

func (ExecOutput_FD) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{6, 0}
}

type LogEntry_Level int32

const (
	LogEntry_Debug LogEntry_Level = 0
	LogEntry_Info  LogEntry_Level = 1
	LogEntry_Warn  LogEntry_Level = 2
	LogEntry_Error LogEntry_Level = 3
)

var LogEntry_Level_name = map[int32]string{
	0: "Debug",
	1: "Info",
	2: "Warn",
	3: "Error",
}

var LogEntry_Level_value = map[string]int32{
	"Debug": 0,
	"Info":  1,
	"Warn":  2,
	"Error": 3,
}

func (x LogEntry_Level) String() string {
	return proto.EnumName(LogEntry_Level_name, int32(x))
}

func (LogEntry_Level) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{7, 0}
}

// ShutdownRequest describes a request to shut down a report RPC agent
type ShutdownRequest struct {
	// Completed indicates that the operation has been completed.
	// Agents may choose to prevent restart after receiving the shutdown request
	// with Completed = true
	Completed            bool     `protobuf:"varint,1,opt,name=completed,proto3" json:"completed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShutdownRequest) Reset()         { *m = ShutdownRequest{} }
func (m *ShutdownRequest) String() string { return proto.CompactTextString(m) }
func (*ShutdownRequest) ProtoMessage()    {}
func (*ShutdownRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{0}
}
func (m *ShutdownRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShutdownRequest.Unmarshal(m, b)
}
func (m *ShutdownRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShutdownRequest.Marshal(b, m, deterministic)
}
func (m *ShutdownRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShutdownRequest.Merge(m, src)
}
func (m *ShutdownRequest) XXX_Size() int {
	return xxx_messageInfo_ShutdownRequest.Size(m)
}
func (m *ShutdownRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ShutdownRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ShutdownRequest proto.InternalMessageInfo

func (m *ShutdownRequest) GetCompleted() bool {
	if m != nil {
		return m.Completed
	}
	return false
}

type CommandArgs struct {
	// Args specify the command to run
	Args []string `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	// SelfCommand specifies whether the agent's binary
	// should execute the command given with args
	SelfCommand bool `protobuf:"varint,2,opt,name=self_command,json=selfCommand,proto3" json:"self_command,omitempty"`
	// Env sets the environment for the command
	Env                  map[string]string `protobuf:"bytes,3,rep,name=env,proto3" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CommandArgs) Reset()         { *m = CommandArgs{} }
func (m *CommandArgs) String() string { return proto.CompactTextString(m) }
func (*CommandArgs) ProtoMessage()    {}
func (*CommandArgs) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{1}
}
func (m *CommandArgs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommandArgs.Unmarshal(m, b)
}
func (m *CommandArgs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommandArgs.Marshal(b, m, deterministic)
}
func (m *CommandArgs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandArgs.Merge(m, src)
}
func (m *CommandArgs) XXX_Size() int {
	return xxx_messageInfo_CommandArgs.Size(m)
}
func (m *CommandArgs) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandArgs.DiscardUnknown(m)
}

var xxx_messageInfo_CommandArgs proto.InternalMessageInfo

func (m *CommandArgs) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *CommandArgs) GetSelfCommand() bool {
	if m != nil {
		return m.SelfCommand
	}
	return false
}

func (m *CommandArgs) GetEnv() map[string]string {
	if m != nil {
		return m.Env
	}
	return nil
}

// Message is a union of various subtypes of event stream
type Message struct {
	// Types that are valid to be assigned to Element:
	//	*Message_ExecStarted
	//	*Message_ExecCompleted
	//	*Message_ExecOutput
	//	*Message_LogEntry
	//	*Message_Error
	Element              isMessage_Element `protobuf_oneof:"element"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Message) Reset()         { *m = Message{} }
func (m *Message) String() string { return proto.CompactTextString(m) }
func (*Message) ProtoMessage()    {}
func (*Message) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{2}
}
func (m *Message) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Message.Unmarshal(m, b)
}
func (m *Message) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Message.Marshal(b, m, deterministic)
}
func (m *Message) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Message.Merge(m, src)
}
func (m *Message) XXX_Size() int {
	return xxx_messageInfo_Message.Size(m)
}
func (m *Message) XXX_DiscardUnknown() {
	xxx_messageInfo_Message.DiscardUnknown(m)
}

var xxx_messageInfo_Message proto.InternalMessageInfo

type isMessage_Element interface {
	isMessage_Element()
}

type Message_ExecStarted struct {
	ExecStarted *ExecStarted `protobuf:"bytes,1,opt,name=exec_started,json=execStarted,proto3,oneof"`
}
type Message_ExecCompleted struct {
	ExecCompleted *ExecCompleted `protobuf:"bytes,2,opt,name=exec_completed,json=execCompleted,proto3,oneof"`
}
type Message_ExecOutput struct {
	ExecOutput *ExecOutput `protobuf:"bytes,3,opt,name=exec_output,json=execOutput,proto3,oneof"`
}
type Message_LogEntry struct {
	LogEntry *LogEntry `protobuf:"bytes,4,opt,name=log_entry,json=logEntry,proto3,oneof"`
}
type Message_Error struct {
	Error *Error `protobuf:"bytes,5,opt,name=error,proto3,oneof"`
}

func (*Message_ExecStarted) isMessage_Element()   {}
func (*Message_ExecCompleted) isMessage_Element() {}
func (*Message_ExecOutput) isMessage_Element()    {}
func (*Message_LogEntry) isMessage_Element()      {}
func (*Message_Error) isMessage_Element()         {}

func (m *Message) GetElement() isMessage_Element {
	if m != nil {
		return m.Element
	}
	return nil
}

func (m *Message) GetExecStarted() *ExecStarted {
	if x, ok := m.GetElement().(*Message_ExecStarted); ok {
		return x.ExecStarted
	}
	return nil
}

func (m *Message) GetExecCompleted() *ExecCompleted {
	if x, ok := m.GetElement().(*Message_ExecCompleted); ok {
		return x.ExecCompleted
	}
	return nil
}

func (m *Message) GetExecOutput() *ExecOutput {
	if x, ok := m.GetElement().(*Message_ExecOutput); ok {
		return x.ExecOutput
	}
	return nil
}

func (m *Message) GetLogEntry() *LogEntry {
	if x, ok := m.GetElement().(*Message_LogEntry); ok {
		return x.LogEntry
	}
	return nil
}

func (m *Message) GetError() *Error {
	if x, ok := m.GetElement().(*Message_Error); ok {
		return x.Error
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Message) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Message_ExecStarted)(nil),
		(*Message_ExecCompleted)(nil),
		(*Message_ExecOutput)(nil),
		(*Message_LogEntry)(nil),
		(*Message_Error)(nil),
	}
}

// ExecStarted is sent when local command starts to execute
type ExecStarted struct {
	// Seq specifies the command ID. Unique only in the current call scope
	Seq int32 `protobuf:"varint,1,opt,name=seq,proto3" json:"seq,omitempty"`
	// Args describes the running command
	Args []string `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
	// Env defines the environment of the running command
	Env                  []string `protobuf:"bytes,3,rep,name=env,proto3" json:"env,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecStarted) Reset()         { *m = ExecStarted{} }
func (m *ExecStarted) String() string { return proto.CompactTextString(m) }
func (*ExecStarted) ProtoMessage()    {}
func (*ExecStarted) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{3}
}
func (m *ExecStarted) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecStarted.Unmarshal(m, b)
}
func (m *ExecStarted) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecStarted.Marshal(b, m, deterministic)
}
func (m *ExecStarted) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecStarted.Merge(m, src)
}
func (m *ExecStarted) XXX_Size() int {
	return xxx_messageInfo_ExecStarted.Size(m)
}
func (m *ExecStarted) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecStarted.DiscardUnknown(m)
}

var xxx_messageInfo_ExecStarted proto.InternalMessageInfo

func (m *ExecStarted) GetSeq() int32 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *ExecStarted) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *ExecStarted) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

// ExecComplete is sent when command completes
type ExecCompleted struct {
	// Seq specifies the command ID. Unique only in the current call scope
	Seq int32 `protobuf:"varint,1,opt,name=seq,proto3" json:"seq,omitempty"`
	// ExitCode is the exit code command exited with
	ExitCode int32 `protobuf:"varint,2,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Error specifies the command execution error
	Error                *Error   `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecCompleted) Reset()         { *m = ExecCompleted{} }
func (m *ExecCompleted) String() string { return proto.CompactTextString(m) }
func (*ExecCompleted) ProtoMessage()    {}
func (*ExecCompleted) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{4}
}
func (m *ExecCompleted) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecCompleted.Unmarshal(m, b)
}
func (m *ExecCompleted) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecCompleted.Marshal(b, m, deterministic)
}
func (m *ExecCompleted) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecCompleted.Merge(m, src)
}
func (m *ExecCompleted) XXX_Size() int {
	return xxx_messageInfo_ExecCompleted.Size(m)
}
func (m *ExecCompleted) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecCompleted.DiscardUnknown(m)
}

var xxx_messageInfo_ExecCompleted proto.InternalMessageInfo

func (m *ExecCompleted) GetSeq() int32 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *ExecCompleted) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *ExecCompleted) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

// Error encapsulates error stack
type Error struct {
	// Messages specifies the error message
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Traces lists stack traces
	Traces               []string `protobuf:"bytes,2,rep,name=traces,proto3" json:"traces,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Error) Reset()         { *m = Error{} }
func (m *Error) String() string { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()    {}
func (*Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{5}
}
func (m *Error) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Error.Unmarshal(m, b)
}
func (m *Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Error.Marshal(b, m, deterministic)
}
func (m *Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Error.Merge(m, src)
}
func (m *Error) XXX_Size() int {
	return xxx_messageInfo_Error.Size(m)
}
func (m *Error) XXX_DiscardUnknown() {
	xxx_messageInfo_Error.DiscardUnknown(m)
}

var xxx_messageInfo_Error proto.InternalMessageInfo

func (m *Error) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Error) GetTraces() []string {
	if m != nil {
		return m.Traces
	}
	return nil
}

// ExecOutput represents output of a running command
type ExecOutput struct {
	Seq                  int32         `protobuf:"varint,1,opt,name=seq,proto3" json:"seq,omitempty"`
	Fd                   ExecOutput_FD `protobuf:"varint,2,opt,name=fd,proto3,enum=proto.ExecOutput_FD" json:"fd,omitempty"`
	Data                 []byte        `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExecOutput) Reset()         { *m = ExecOutput{} }
func (m *ExecOutput) String() string { return proto.CompactTextString(m) }
func (*ExecOutput) ProtoMessage()    {}
func (*ExecOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{6}
}
func (m *ExecOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecOutput.Unmarshal(m, b)
}
func (m *ExecOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecOutput.Marshal(b, m, deterministic)
}
func (m *ExecOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecOutput.Merge(m, src)
}
func (m *ExecOutput) XXX_Size() int {
	return xxx_messageInfo_ExecOutput.Size(m)
}
func (m *ExecOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecOutput.DiscardUnknown(m)
}

var xxx_messageInfo_ExecOutput proto.InternalMessageInfo

func (m *ExecOutput) GetSeq() int32 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *ExecOutput) GetFd() ExecOutput_FD {
	if m != nil {
		return m.Fd
	}
	return ExecOutput_STDOUT
}

func (m *ExecOutput) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type LogEntry struct {
	Message              string            `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	Fields               map[string]string `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Level                LogEntry_Level    `protobuf:"varint,3,opt,name=level,proto3,enum=proto.LogEntry_Level" json:"level,omitempty"`
	Traces               []string          `protobuf:"bytes,4,rep,name=traces,proto3" json:"traces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{7}
}
func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (m *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(m, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *LogEntry) GetFields() map[string]string {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *LogEntry) GetLevel() LogEntry_Level {
	if m != nil {
		return m.Level
	}
	return LogEntry_Debug
}

func (m *LogEntry) GetTraces() []string {
	if m != nil {
		return m.Traces
	}
	return nil
}

// UninstallRequest is request to uninstall the system on remote node
type UninstallRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UninstallRequest) Reset()         { *m = UninstallRequest{} }
func (m *UninstallRequest) String() string { return proto.CompactTextString(m) }
func (*UninstallRequest) ProtoMessage()    {}
func (*UninstallRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{8}
}
func (m *UninstallRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UninstallRequest.Unmarshal(m, b)
}
func (m *UninstallRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UninstallRequest.Marshal(b, m, deterministic)
}
func (m *UninstallRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UninstallRequest.Merge(m, src)
}
func (m *UninstallRequest) XXX_Size() int {
	return xxx_messageInfo_UninstallRequest.Size(m)
}
func (m *UninstallRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UninstallRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UninstallRequest proto.InternalMessageInfo

// PeerJoinRequest is request to join from a remote peer.
type PeerJoinRequest struct {
	// Addr is the peer address as host:port
	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	// Config specifies the peer's runtime configuration
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// SystemInfo describes the peer's environment
	SystemInfo           []byte   `protobuf:"bytes,3,opt,name=system_info,json=systemInfo,proto3" json:"system_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeerJoinRequest) Reset()      { *m = PeerJoinRequest{} }
func (*PeerJoinRequest) ProtoMessage() {}
func (*PeerJoinRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{9}
}
func (m *PeerJoinRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PeerJoinRequest.Unmarshal(m, b)
}
func (m *PeerJoinRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PeerJoinRequest.Marshal(b, m, deterministic)
}
func (m *PeerJoinRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerJoinRequest.Merge(m, src)
}
func (m *PeerJoinRequest) XXX_Size() int {
	return xxx_messageInfo_PeerJoinRequest.Size(m)
}
func (m *PeerJoinRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerJoinRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PeerJoinRequest proto.InternalMessageInfo

func (m *PeerJoinRequest) GetAddr() string {
	if m != nil {
		return m.Addr
	}
	return ""
}

func (m *PeerJoinRequest) GetConfig() *RuntimeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *PeerJoinRequest) GetSystemInfo() []byte {
	if m != nil {
		return m.SystemInfo
	}
	return nil
}

// PeerLeaveRequest is a request a peer sends when it wants to leave the cluster
type PeerLeaveRequest struct {
	// Addr is the peer address as host:port
	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	// Config specifies the peer's runtime configuration
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// SystemInfo describes the peer's environment
	SystemInfo           []byte   `protobuf:"bytes,3,opt,name=system_info,json=systemInfo,proto3" json:"system_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeerLeaveRequest) Reset()      { *m = PeerLeaveRequest{} }
func (*PeerLeaveRequest) ProtoMessage() {}
func (*PeerLeaveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{10}
}
func (m *PeerLeaveRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PeerLeaveRequest.Unmarshal(m, b)
}
func (m *PeerLeaveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PeerLeaveRequest.Marshal(b, m, deterministic)
}
func (m *PeerLeaveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerLeaveRequest.Merge(m, src)
}
func (m *PeerLeaveRequest) XXX_Size() int {
	return xxx_messageInfo_PeerLeaveRequest.Size(m)
}
func (m *PeerLeaveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerLeaveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PeerLeaveRequest proto.InternalMessageInfo

func (m *PeerLeaveRequest) GetAddr() string {
	if m != nil {
		return m.Addr
	}
	return ""
}

func (m *PeerLeaveRequest) GetConfig() *RuntimeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *PeerLeaveRequest) GetSystemInfo() []byte {
	if m != nil {
		return m.SystemInfo
	}
	return nil
}

func init() {
	proto.RegisterEnum("proto.ExecOutput_FD", ExecOutput_FD_name, ExecOutput_FD_value)
	proto.RegisterEnum("proto.LogEntry_Level", LogEntry_Level_name, LogEntry_Level_value)
	proto.RegisterType((*ShutdownRequest)(nil), "proto.ShutdownRequest")
	proto.RegisterType((*CommandArgs)(nil), "proto.CommandArgs")
	proto.RegisterMapType((map[string]string)(nil), "proto.CommandArgs.EnvEntry")
	proto.RegisterType((*Message)(nil), "proto.Message")
	proto.RegisterType((*ExecStarted)(nil), "proto.ExecStarted")
	proto.RegisterType((*ExecCompleted)(nil), "proto.ExecCompleted")
	proto.RegisterType((*Error)(nil), "proto.Error")
	proto.RegisterType((*ExecOutput)(nil), "proto.ExecOutput")
	proto.RegisterType((*LogEntry)(nil), "proto.LogEntry")
	proto.RegisterMapType((map[string]string)(nil), "proto.LogEntry.FieldsEntry")
	proto.RegisterType((*UninstallRequest)(nil), "proto.UninstallRequest")
	proto.RegisterType((*PeerJoinRequest)(nil), "proto.PeerJoinRequest")
	proto.RegisterType((*PeerLeaveRequest)(nil), "proto.PeerLeaveRequest")
}

func init() { proto.RegisterFile("agent.proto", fileDescriptor_56ede974c0020f77) }

var fileDescriptor_56ede974c0020f77 = []byte{
	// 800 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x54, 0xcd, 0x6e, 0xdc, 0x54,
	0x14, 0x1e, 0xdb, 0xe3, 0xc9, 0xf8, 0x38, 0x4d, 0xcc, 0x55, 0x09, 0xd6, 0xa4, 0x52, 0x83, 0xd5,
	0x45, 0x24, 0xc0, 0x81, 0x14, 0x51, 0x1a, 0xc1, 0x22, 0x24, 0x13, 0x0d, 0x28, 0xa8, 0xe8, 0xa6,
	0x15, 0xcb, 0x91, 0xc7, 0x3e, 0x36, 0x16, 0xb6, 0x6f, 0x6a, 0x5f, 0x0f, 0x09, 0xbc, 0x02, 0x0f,
	0xd0, 0x25, 0x3b, 0x16, 0xbc, 0x24, 0xba, 0x3f, 0x9e, 0x71, 0xd3, 0x0c, 0x12, 0x9b, 0xae, 0xe6,
	0xfc, 0x7d, 0xe7, 0x7c, 0x3e, 0xdf, 0xdc, 0x03, 0x6e, 0x94, 0x61, 0xc5, 0xc3, 0xeb, 0x9a, 0x71,
	0x46, 0x6c, 0xf9, 0x33, 0xd9, 0xcf, 0x18, 0xcb, 0x0a, 0x3c, 0x92, 0xde, 0xa2, 0x4d, 0x8f, 0xb0,
	0xbc, 0xe6, 0xb7, 0xaa, 0x66, 0xb2, 0x9b, 0xe4, 0x4d, 0xcc, 0x96, 0x58, 0x77, 0x01, 0xc8, 0x58,
	0xc6, 0x94, 0x1d, 0x1c, 0xc1, 0xee, 0xd5, 0x2f, 0x2d, 0x4f, 0xd8, 0x6f, 0x15, 0xc5, 0xd7, 0x2d,
	0x36, 0x9c, 0x3c, 0x02, 0x27, 0x66, 0xe5, 0x75, 0x81, 0x1c, 0x13, 0xdf, 0x38, 0x30, 0x0e, 0xc7,
	0x74, 0x1d, 0x08, 0xfe, 0x31, 0xc0, 0x3d, 0x63, 0x65, 0x19, 0x55, 0xc9, 0x69, 0x9d, 0x35, 0x84,
	0xc0, 0x30, 0xaa, 0xb3, 0xc6, 0x37, 0x0e, 0xac, 0x43, 0x87, 0x4a, 0x9b, 0x7c, 0x0c, 0xdb, 0x0d,
	0x16, 0xe9, 0x3c, 0x56, 0x75, 0xbe, 0x29, 0x9b, 0xb8, 0x22, 0xa6, 0xa1, 0xe4, 0x33, 0xb0, 0xb0,
	0x5a, 0xfa, 0xd6, 0x81, 0x75, 0xe8, 0x1e, 0xef, 0x2b, 0x32, 0x61, 0xaf, 0x6f, 0x38, 0xad, 0x96,
	0xd3, 0x8a, 0xd7, 0xb7, 0x54, 0xd4, 0x4d, 0xbe, 0x82, 0x71, 0x17, 0x20, 0x1e, 0x58, 0xbf, 0xe2,
	0xad, 0x64, 0xe6, 0x50, 0x61, 0x92, 0x87, 0x60, 0x2f, 0xa3, 0xa2, 0x45, 0x39, 0xc8, 0xa1, 0xca,
	0x39, 0x31, 0xbf, 0x36, 0x82, 0x37, 0x26, 0x6c, 0xfd, 0x88, 0x4d, 0x13, 0x65, 0x48, 0x9e, 0xc1,
	0x36, 0xde, 0x60, 0x3c, 0x6f, 0x78, 0x54, 0x77, 0x9f, 0xe6, 0x1e, 0x13, 0x3d, 0x7b, 0x7a, 0x83,
	0xf1, 0x95, 0xca, 0xcc, 0x06, 0xd4, 0xc5, 0xb5, 0x4b, 0xbe, 0x85, 0x1d, 0x09, 0x5c, 0x6f, 0xc5,
	0x94, 0xd0, 0x87, 0x3d, 0xe8, 0x59, 0x97, 0x9b, 0x0d, 0xe8, 0x03, 0xec, 0x07, 0xc8, 0x97, 0x20,
	0xbb, 0xcd, 0x59, 0xcb, 0xaf, 0x5b, 0xee, 0x5b, 0x12, 0xfb, 0x41, 0x0f, 0xfb, 0x42, 0x26, 0x66,
	0x03, 0x0a, 0xb8, 0xf2, 0x48, 0x08, 0x4e, 0xc1, 0xb2, 0x39, 0x8a, 0x4f, 0xf6, 0x87, 0x12, 0xb3,
	0xab, 0x31, 0x97, 0x2c, 0x93, 0x9b, 0x98, 0x0d, 0xe8, 0xb8, 0xd0, 0x36, 0x79, 0x02, 0x36, 0xd6,
	0x35, 0xab, 0x7d, 0x5b, 0xd6, 0x6e, 0x77, 0xfd, 0x45, 0x6c, 0x36, 0xa0, 0x2a, 0xf9, 0x9d, 0x03,
	0x5b, 0x58, 0x60, 0x89, 0x15, 0x0f, 0xa6, 0xe0, 0xf6, 0xbe, 0x59, 0x6c, 0xb5, 0xc1, 0xd7, 0x72,
	0x29, 0x36, 0x15, 0xe6, 0x4a, 0x59, 0xb3, 0xa7, 0xac, 0xb7, 0x96, 0xcd, 0x91, 0xca, 0x04, 0x0b,
	0x78, 0xf0, 0xd6, 0xf7, 0xdf, 0xd3, 0x68, 0x1f, 0x1c, 0xbc, 0xc9, 0xf9, 0x3c, 0x66, 0x89, 0x92,
	0xc8, 0xa6, 0x63, 0x11, 0x38, 0x63, 0x09, 0x92, 0xa0, 0xe3, 0x6d, 0xbd, 0xcb, 0x5b, 0xb3, 0x0e,
	0x9e, 0x83, 0x2d, 0x7d, 0xe2, 0xc3, 0x56, 0xa9, 0xd4, 0xd4, 0xf2, 0x77, 0x2e, 0xd9, 0x83, 0x11,
	0xaf, 0xa3, 0x18, 0x3b, 0xba, 0xda, 0x0b, 0x96, 0x00, 0xeb, 0x15, 0xdf, 0xc3, 0xed, 0x09, 0x98,
	0xa9, 0xd2, 0x73, 0xe7, 0x2d, 0x3d, 0x15, 0x20, 0xbc, 0x38, 0xa7, 0x66, 0x9a, 0x88, 0x55, 0x24,
	0x11, 0x8f, 0x24, 0xc7, 0x6d, 0x2a, 0xed, 0xe0, 0x11, 0x98, 0x17, 0xe7, 0x04, 0x60, 0x74, 0xf5,
	0xf2, 0xfc, 0xc5, 0xab, 0x97, 0xde, 0x40, 0xdb, 0x53, 0x4a, 0x3d, 0x23, 0xf8, 0xd3, 0x84, 0x71,
	0xa7, 0xd3, 0x7f, 0xd0, 0x7e, 0x0a, 0xa3, 0x34, 0xc7, 0x22, 0x51, 0xb4, 0xd7, 0x2f, 0xa1, 0x83,
	0x86, 0x17, 0x32, 0xab, 0x5e, 0x82, 0x2e, 0x25, 0x9f, 0x80, 0x5d, 0xe0, 0x12, 0x0b, 0x49, 0x67,
	0xe7, 0xf8, 0xc3, 0xbb, 0x98, 0x4b, 0x91, 0xa4, 0xaa, 0xa6, 0xb7, 0x98, 0x61, 0x7f, 0x31, 0x93,
	0xe7, 0xe0, 0xf6, 0x7a, 0xff, 0xaf, 0x47, 0xf5, 0x05, 0xd8, 0x72, 0x04, 0x71, 0xc0, 0x3e, 0xc7,
	0x45, 0x9b, 0x79, 0x03, 0x32, 0x86, 0xe1, 0xf7, 0x55, 0xca, 0x3c, 0x43, 0x58, 0x3f, 0x47, 0x75,
	0xe5, 0x99, 0x22, 0x2d, 0x65, 0xf3, 0xac, 0x80, 0x80, 0xf7, 0xaa, 0xca, 0xab, 0x86, 0x47, 0x45,
	0xa1, 0xef, 0x4c, 0xf0, 0x3b, 0xec, 0xfe, 0x84, 0x58, 0xff, 0xc0, 0xf2, 0xd5, 0xe9, 0x11, 0x7f,
	0xb9, 0x24, 0xa9, 0x35, 0x0d, 0x69, 0x93, 0x4f, 0x61, 0x14, 0xb3, 0x2a, 0xcd, 0xb3, 0x3b, 0xaf,
	0x8e, 0xb6, 0x15, 0xcf, 0x4b, 0x3c, 0x93, 0x39, 0xaa, 0x6b, 0xc8, 0x63, 0x70, 0x9b, 0xdb, 0x86,
	0x63, 0x39, 0xcf, 0xab, 0x94, 0x69, 0xc1, 0x40, 0x85, 0x04, 0xc1, 0x93, 0xe1, 0x9b, 0xbf, 0x1e,
	0x0f, 0x82, 0x3f, 0xc0, 0x13, 0xb3, 0x2f, 0x31, 0x5a, 0xe2, 0xfb, 0x1e, 0x7e, 0xfc, 0xb7, 0x09,
	0xf6, 0xa9, 0x38, 0xe2, 0xe4, 0x04, 0xc6, 0xdd, 0xf5, 0x25, 0x7b, 0xba, 0xf5, 0x9d, 0x73, 0x3c,
	0xd9, 0x0b, 0xd5, 0x71, 0x0f, 0xbb, 0xe3, 0x1e, 0x4e, 0xc5, 0x71, 0x27, 0xcf, 0xc0, 0x3e, 0x5d,
	0xb0, 0x9a, 0x93, 0x0d, 0x05, 0x1b, 0x81, 0x47, 0xb0, 0xd5, 0x5d, 0x61, 0xf2, 0xee, 0xe1, 0x9d,
	0xec, 0xe8, 0x98, 0x3e, 0x9b, 0x9f, 0x1b, 0x82, 0x65, 0x27, 0xd4, 0x8a, 0xe5, 0x1d, 0xe5, 0x36,
	0x0e, 0xfb, 0x06, 0x9c, 0xd5, 0xa2, 0xc9, 0x47, 0x3d, 0x70, 0x7f, 0xf5, 0x9b, 0xd0, 0x8b, 0x91,
	0xf4, 0x9f, 0xfe, 0x1b, 0x00, 0x00, 0xff, 0xff, 0xaf, 0xe6, 0x08, 0x92, 0xf4, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AgentClient is the client API for Agent service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentClient interface {
	// Shutdown requests the agent to shut down
	Shutdown(ctx context.Context, in *ShutdownRequest, opts ...grpc.CallOption) (*types.Empty, error)
	// Abort requests the agent to clean up the state on this node and shut down
	Abort(ctx context.Context, in *types.Empty, opts ...grpc.CallOption) (*types.Empty, error)
	// Command executes a command specified with CommandArgs.
	// The output of the command is streamed as a result.
	Command(ctx context.Context, in *CommandArgs, opts ...grpc.CallOption) (Agent_CommandClient, error)
	// PeerJoin receives a connection from a peer.
	// The peer configuration allows this agent to establish a reverse
	// connection to the remote peer to execute remote commands
	PeerJoin(ctx context.Context, in *PeerJoinRequest, opts ...grpc.CallOption) (*types.Empty, error)
	// PeerLeave receives a "leave" request from a peer and initiates its shutdown
	PeerLeave(ctx context.Context, in *PeerLeaveRequest, opts ...grpc.CallOption) (*types.Empty, error)
}

type agentClient struct {
	cc *grpc.ClientConn
}

func NewAgentClient(cc *grpc.ClientConn) AgentClient {
	return &agentClient{cc}
}

func (c *agentClient) Shutdown(ctx context.Context, in *ShutdownRequest, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/proto.Agent/Shutdown", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) Abort(ctx context.Context, in *types.Empty, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/proto.Agent/Abort", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) Command(ctx context.Context, in *CommandArgs, opts ...grpc.CallOption) (Agent_CommandClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Agent_serviceDesc.Streams[0], "/proto.Agent/Command", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentCommandClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Agent_CommandClient interface {
	Recv() (*Message, error)
	grpc.ClientStream
}

type agentCommandClient struct {
	grpc.ClientStream
}

func (x *agentCommandClient) Recv() (*Message, error) {
	m := new(Message)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentClient) PeerJoin(ctx context.Context, in *PeerJoinRequest, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/proto.Agent/PeerJoin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) PeerLeave(ctx context.Context, in *PeerLeaveRequest, opts ...grpc.CallOption) (*types.Empty, error) {
	out := new(types.Empty)
	err := c.cc.Invoke(ctx, "/proto.Agent/PeerLeave", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentServer is the server API for Agent service.
type AgentServer interface {
	// Shutdown requests the agent to shut down
	Shutdown(context.Context, *ShutdownRequest) (*types.Empty, error)
	// Abort requests the agent to clean up the state on this node and shut down
	Abort(context.Context, *types.Empty) (*types.Empty, error)
	// Command executes a command specified with CommandArgs.
	// The output of the command is streamed as a result.
	Command(*CommandArgs, Agent_CommandServer) error
	// PeerJoin receives a connection from a peer.
	// The peer configuration allows this agent to establish a reverse
	// connection to the remote peer to execute remote commands
	PeerJoin(context.Context, *PeerJoinRequest) (*types.Empty, error)
	// PeerLeave receives a "leave" request from a peer and initiates its shutdown
	PeerLeave(context.Context, *PeerLeaveRequest) (*types.Empty, error)
}

// UnimplementedAgentServer can be embedded to have forward compatible implementations.
type UnimplementedAgentServer struct {
}

func (*UnimplementedAgentServer) Shutdown(ctx context.Context, req *ShutdownRequest) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Shutdown not implemented")
}
func (*UnimplementedAgentServer) Abort(ctx context.Context, req *types.Empty) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Abort not implemented")
}
func (*UnimplementedAgentServer) Command(req *CommandArgs, srv Agent_CommandServer) error {
	return status.Errorf(codes.Unimplemented, "method Command not implemented")
}
func (*UnimplementedAgentServer) PeerJoin(ctx context.Context, req *PeerJoinRequest) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PeerJoin not implemented")
}
func (*UnimplementedAgentServer) PeerLeave(ctx context.Context, req *PeerLeaveRequest) (*types.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PeerLeave not implemented")
}

func RegisterAgentServer(s *grpc.Server, srv AgentServer) {
	s.RegisterService(&_Agent_serviceDesc, srv)
}

func _Agent_Shutdown_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShutdownRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).Shutdown(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.Agent/Shutdown",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).Shutdown(ctx, req.(*ShutdownRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_Abort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(types.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).Abort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.Agent/Abort",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).Abort(ctx, req.(*types.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_Command_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommandArgs)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AgentServer).Command(m, &agentCommandServer{stream})
}

type Agent_CommandServer interface {
	Send(*Message) error
	grpc.ServerStream
}

type agentCommandServer struct {
	grpc.ServerStream
}

func (x *agentCommandServer) Send(m *Message) error {
	return x.ServerStream.SendMsg(m)
}

func _Agent_PeerJoin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PeerJoinRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).PeerJoin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.Agent/PeerJoin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).PeerJoin(ctx, req.(*PeerJoinRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_PeerLeave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PeerLeaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).PeerLeave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.Agent/PeerLeave",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).PeerLeave(ctx, req.(*PeerLeaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Agent_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.Agent",
	HandlerType: (*AgentServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Shutdown",
			Handler:    _Agent_Shutdown_Handler,
		},
		{
			MethodName: "Abort",
			Handler:    _Agent_Abort_Handler,
		},
		{
			MethodName: "PeerJoin",
			Handler:    _Agent_PeerJoin_Handler,
		},
		{
			MethodName: "PeerLeave",
			Handler:    _Agent_PeerLeave_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Command",
			Handler:       _Agent_Command_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "agent.proto",
}
