/*
Copyright 2018 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package utils

import (
	"encoding/json"
	"io"

	"github.com/ghodss/yaml"
	"github.com/gravitational/trace"
)

// WriteJSON writes JSON serialized object into provided writer
func WriteJSON(m Marshaler, w io.Writer) error {
	data, err := json.MarshalIndent(m.ToMarshal(), "", "    ")
	if err != nil {
		return trace.Wrap(err)
	}
	_, err = w.Write(data)
	return trace.Wrap(err)
}

// WriteYAML writes YAML serialized object into provided writer
func WriteYAML(m Marshaler, w io.Writer) error {
	data, err := yaml.Marshal(m.ToMarshal())
	if err != nil {
		return trace.Wrap(err)
	}
	_, err = w.Write(data)
	return trace.Wrap(err)
}

// Marshaler defines an interface for marshalable objects
type Marshaler interface {
	// ToMarshal returns object that needs to be marshaled
	ToMarshal() interface{}
}
