/*
Copyright 2018 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package utils

import "gopkg.in/check.v1"

type StringSetSuite struct{}

var _ = check.Suite(&StringSetSuite{})

func (s *StringSetSuite) TestEverything(c *check.C) {
	set := NewStringSet()

	set.Add("one")
	set.Add("two")
	set.Add("two")
	c.Assert(set, check.HasLen, 2)

	set.Remove("two")
	c.Assert(set, check.HasLen, 1)

	another := NewStringSet()
	another.Add("1")
	another.Add("2")
	another.Add("3")

	set.AddSet(another)
	c.Assert(set.Slice(), check.DeepEquals, []string{"1", "2", "3", "one"})

	set.AddSlice([]string{"bad", "santa"})
	c.Assert(set.Slice(), check.DeepEquals, []string{"1", "2", "3", "bad", "one", "santa"})
}

func (s *StringSetSuite) TestDiff(c *check.C) {
	set1 := NewStringSetFromSlice([]string{"1", "2", "3"})
	set2 := NewStringSetFromSlice([]string{"2", "3", "4"})
	c.Assert(set1.Diff(set2).Slice(), check.DeepEquals, []string{"1", "4"})
}
