/*
Copyright 2018 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package cli

import (
	"encoding/json"
	"fmt"

	"github.com/gravitational/gravity/lib/constants"
	"github.com/gravitational/gravity/lib/modules"

	"github.com/gravitational/trace"
)

func printVersion(format constants.Format) error {
	ver := modules.Get().Version()
	switch format {
	case constants.EncodingText:
		fmt.Println(ver.String())
	case constants.EncodingJSON:
		bytes, err := json.Marshal(ver)
		if err != nil {
			return trace.Wrap(err)
		}
		fmt.Printf(string(bytes))
	}
	return nil
}
