// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: agent.proto

package agentpb

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type SystemStatus_Type int32

const (
	SystemStatus_Unknown  SystemStatus_Type = 0
	SystemStatus_Running  SystemStatus_Type = 1
	SystemStatus_Degraded SystemStatus_Type = 2
)

var SystemStatus_Type_name = map[int32]string{
	0: "Unknown",
	1: "Running",
	2: "Degraded",
}

var SystemStatus_Type_value = map[string]int32{
	"Unknown":  0,
	"Running":  1,
	"Degraded": 2,
}

func (x SystemStatus_Type) String() string {
	return proto.EnumName(SystemStatus_Type_name, int32(x))
}

func (SystemStatus_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{6, 0}
}

type MemberStatus_Type int32

const (
	MemberStatus_None    MemberStatus_Type = 0
	MemberStatus_Alive   MemberStatus_Type = 1
	MemberStatus_Leaving MemberStatus_Type = 2
	MemberStatus_Left    MemberStatus_Type = 3
	MemberStatus_Failed  MemberStatus_Type = 4
)

var MemberStatus_Type_name = map[int32]string{
	0: "None",
	1: "Alive",
	2: "Leaving",
	3: "Left",
	4: "Failed",
}

var MemberStatus_Type_value = map[string]int32{
	"None":    0,
	"Alive":   1,
	"Leaving": 2,
	"Left":    3,
	"Failed":  4,
}

func (x MemberStatus_Type) String() string {
	return proto.EnumName(MemberStatus_Type_name, int32(x))
}

func (MemberStatus_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{7, 0}
}

type NodeStatus_Type int32

const (
	NodeStatus_Unknown  NodeStatus_Type = 0
	NodeStatus_Running  NodeStatus_Type = 1
	NodeStatus_Degraded NodeStatus_Type = 2
)

var NodeStatus_Type_name = map[int32]string{
	0: "Unknown",
	1: "Running",
	2: "Degraded",
}

var NodeStatus_Type_value = map[string]int32{
	"Unknown":  0,
	"Running":  1,
	"Degraded": 2,
}

func (x NodeStatus_Type) String() string {
	return proto.EnumName(NodeStatus_Type_name, int32(x))
}

func (NodeStatus_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{8, 0}
}

type Probe_Type int32

const (
	Probe_Unknown    Probe_Type = 0
	Probe_Running    Probe_Type = 1
	Probe_Failed     Probe_Type = 2
	Probe_Terminated Probe_Type = 3
)

var Probe_Type_name = map[int32]string{
	0: "Unknown",
	1: "Running",
	2: "Failed",
	3: "Terminated",
}

var Probe_Type_value = map[string]int32{
	"Unknown":    0,
	"Running":    1,
	"Failed":     2,
	"Terminated": 3,
}

func (x Probe_Type) String() string {
	return proto.EnumName(Probe_Type_name, int32(x))
}

func (Probe_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{9, 0}
}

// Severity defines the severity of the probe.
type Probe_Severity int32

const (
	// None severity denotes the severity of a running probe
	Probe_None Probe_Severity = 0
	// Critical defines a serious error that requires immediate attention
	Probe_Critical Probe_Severity = 1
	// Warning defines a (possibly transient) condition that requires attention
	// but is not critical
	Probe_Warning Probe_Severity = 2
)

var Probe_Severity_name = map[int32]string{
	0: "None",
	1: "Critical",
	2: "Warning",
}

var Probe_Severity_value = map[string]int32{
	"None":     0,
	"Critical": 1,
	"Warning":  2,
}

func (x Probe_Severity) String() string {
	return proto.EnumName(Probe_Severity_name, int32(x))
}

func (Probe_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{9, 1}
}

type StatusRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StatusRequest) Reset()         { *m = StatusRequest{} }
func (m *StatusRequest) String() string { return proto.CompactTextString(m) }
func (*StatusRequest) ProtoMessage()    {}
func (*StatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{0}
}
func (m *StatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusRequest.Merge(m, src)
}
func (m *StatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *StatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StatusRequest proto.InternalMessageInfo

type StatusResponse struct {
	Status               *SystemStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *StatusResponse) Reset()         { *m = StatusResponse{} }
func (m *StatusResponse) String() string { return proto.CompactTextString(m) }
func (*StatusResponse) ProtoMessage()    {}
func (*StatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{1}
}
func (m *StatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusResponse.Merge(m, src)
}
func (m *StatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *StatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StatusResponse proto.InternalMessageInfo

func (m *StatusResponse) GetStatus() *SystemStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type LocalStatusRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocalStatusRequest) Reset()         { *m = LocalStatusRequest{} }
func (m *LocalStatusRequest) String() string { return proto.CompactTextString(m) }
func (*LocalStatusRequest) ProtoMessage()    {}
func (*LocalStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{2}
}
func (m *LocalStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalStatusRequest.Merge(m, src)
}
func (m *LocalStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *LocalStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LocalStatusRequest proto.InternalMessageInfo

type LocalStatusResponse struct {
	Status               *NodeStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *LocalStatusResponse) Reset()         { *m = LocalStatusResponse{} }
func (m *LocalStatusResponse) String() string { return proto.CompactTextString(m) }
func (*LocalStatusResponse) ProtoMessage()    {}
func (*LocalStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{3}
}
func (m *LocalStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalStatusResponse.Merge(m, src)
}
func (m *LocalStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *LocalStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LocalStatusResponse proto.InternalMessageInfo

func (m *LocalStatusResponse) GetStatus() *NodeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// LastSeenRequest requests the last seen timestamp for the specified member.
type LastSeenRequest struct {
	// Name specifies the member's serf name.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LastSeenRequest) Reset()         { *m = LastSeenRequest{} }
func (m *LastSeenRequest) String() string { return proto.CompactTextString(m) }
func (*LastSeenRequest) ProtoMessage()    {}
func (*LastSeenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{4}
}
func (m *LastSeenRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LastSeenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LastSeenRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LastSeenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LastSeenRequest.Merge(m, src)
}
func (m *LastSeenRequest) XXX_Size() int {
	return m.Size()
}
func (m *LastSeenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LastSeenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LastSeenRequest proto.InternalMessageInfo

func (m *LastSeenRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// LastSeenResponse returns the last seen timestamp for the requested member.
type LastSeenResponse struct {
	// Timestamp specifies the last seen timestamp.
	Timestamp            *Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *LastSeenResponse) Reset()         { *m = LastSeenResponse{} }
func (m *LastSeenResponse) String() string { return proto.CompactTextString(m) }
func (*LastSeenResponse) ProtoMessage()    {}
func (*LastSeenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{5}
}
func (m *LastSeenResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LastSeenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LastSeenResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LastSeenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LastSeenResponse.Merge(m, src)
}
func (m *LastSeenResponse) XXX_Size() int {
	return m.Size()
}
func (m *LastSeenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LastSeenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LastSeenResponse proto.InternalMessageInfo

func (m *LastSeenResponse) GetTimestamp() *Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

// System describes the health status of the cluster.
type SystemStatus struct {
	Status SystemStatus_Type `protobuf:"varint,1,opt,name=status,proto3,enum=agentpb.SystemStatus_Type" json:"status,omitempty"`
	// Health status of individual nodes.
	Nodes     []*NodeStatus `protobuf:"bytes,2,rep,name=nodes,proto3" json:"nodes,omitempty"`
	Timestamp *Timestamp    `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Human-readable status summary.
	Summary              string   `protobuf:"bytes,4,opt,name=summary,proto3" json:"summary,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SystemStatus) Reset()         { *m = SystemStatus{} }
func (m *SystemStatus) String() string { return proto.CompactTextString(m) }
func (*SystemStatus) ProtoMessage()    {}
func (*SystemStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{6}
}
func (m *SystemStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SystemStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SystemStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SystemStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SystemStatus.Merge(m, src)
}
func (m *SystemStatus) XXX_Size() int {
	return m.Size()
}
func (m *SystemStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_SystemStatus.DiscardUnknown(m)
}

var xxx_messageInfo_SystemStatus proto.InternalMessageInfo

func (m *SystemStatus) GetStatus() SystemStatus_Type {
	if m != nil {
		return m.Status
	}
	return SystemStatus_Unknown
}

func (m *SystemStatus) GetNodes() []*NodeStatus {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *SystemStatus) GetTimestamp() *Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *SystemStatus) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

// MembereStatus represents the status of a member of the serf cluster.
type MemberStatus struct {
	Name                 string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Addr                 string            `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
	Status               MemberStatus_Type `protobuf:"varint,3,opt,name=status,proto3,enum=agentpb.MemberStatus_Type" json:"status,omitempty"`
	Tags                 map[string]string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MemberStatus) Reset()         { *m = MemberStatus{} }
func (m *MemberStatus) String() string { return proto.CompactTextString(m) }
func (*MemberStatus) ProtoMessage()    {}
func (*MemberStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{7}
}
func (m *MemberStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemberStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemberStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemberStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemberStatus.Merge(m, src)
}
func (m *MemberStatus) XXX_Size() int {
	return m.Size()
}
func (m *MemberStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_MemberStatus.DiscardUnknown(m)
}

var xxx_messageInfo_MemberStatus proto.InternalMessageInfo

func (m *MemberStatus) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MemberStatus) GetAddr() string {
	if m != nil {
		return m.Addr
	}
	return ""
}

func (m *MemberStatus) GetStatus() MemberStatus_Type {
	if m != nil {
		return m.Status
	}
	return MemberStatus_None
}

func (m *MemberStatus) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// NodeStatus represents a result of a health check for a single node.
type NodeStatus struct {
	Name         string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	MemberStatus *MemberStatus   `protobuf:"bytes,2,opt,name=member_status,json=memberStatus,proto3" json:"member_status,omitempty"`
	Status       NodeStatus_Type `protobuf:"varint,3,opt,name=status,proto3,enum=agentpb.NodeStatus_Type" json:"status,omitempty"`
	// Probes lists all the health probes collected during the health check.
	Probes               []*Probe `protobuf:"bytes,4,rep,name=probes,proto3" json:"probes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeStatus) Reset()         { *m = NodeStatus{} }
func (m *NodeStatus) String() string { return proto.CompactTextString(m) }
func (*NodeStatus) ProtoMessage()    {}
func (*NodeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{8}
}
func (m *NodeStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeStatus.Merge(m, src)
}
func (m *NodeStatus) XXX_Size() int {
	return m.Size()
}
func (m *NodeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_NodeStatus proto.InternalMessageInfo

func (m *NodeStatus) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NodeStatus) GetMemberStatus() *MemberStatus {
	if m != nil {
		return m.MemberStatus
	}
	return nil
}

func (m *NodeStatus) GetStatus() NodeStatus_Type {
	if m != nil {
		return m.Status
	}
	return NodeStatus_Unknown
}

func (m *NodeStatus) GetProbes() []*Probe {
	if m != nil {
		return m.Probes
	}
	return nil
}

// Probe represents the outcome of a single check
type Probe struct {
	// Checker is the name of the checker that generated the probe
	Checker string `protobuf:"bytes,1,opt,name=checker,proto3" json:"checker,omitempty"`
	// Detail is the optional detail specific to the checker
	Detail string `protobuf:"bytes,2,opt,name=detail,proto3" json:"detail,omitempty"`
	// Code is the optional code specific to a checker (i.e. HTTP status code)
	Code string `protobuf:"bytes,3,opt,name=code,proto3" json:"code,omitempty"`
	// Status is the result of the probe
	Status Probe_Type `protobuf:"varint,4,opt,name=status,proto3,enum=agentpb.Probe_Type" json:"status,omitempty"`
	// Error is the probe-specific error message
	Error string `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// CheckerData is a free-form data specific to the checker
	CheckerData []byte `protobuf:"bytes,6,opt,name=checker_data,json=checkerData,proto3" json:"checker_data,omitempty"`
	// Severity is the severity of the probe
	Severity             Probe_Severity `protobuf:"varint,7,opt,name=severity,proto3,enum=agentpb.Probe_Severity" json:"severity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Probe) Reset()         { *m = Probe{} }
func (m *Probe) String() string { return proto.CompactTextString(m) }
func (*Probe) ProtoMessage()    {}
func (*Probe) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{9}
}
func (m *Probe) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Probe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Probe.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Probe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Probe.Merge(m, src)
}
func (m *Probe) XXX_Size() int {
	return m.Size()
}
func (m *Probe) XXX_DiscardUnknown() {
	xxx_messageInfo_Probe.DiscardUnknown(m)
}

var xxx_messageInfo_Probe proto.InternalMessageInfo

func (m *Probe) GetChecker() string {
	if m != nil {
		return m.Checker
	}
	return ""
}

func (m *Probe) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *Probe) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *Probe) GetStatus() Probe_Type {
	if m != nil {
		return m.Status
	}
	return Probe_Unknown
}

func (m *Probe) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *Probe) GetCheckerData() []byte {
	if m != nil {
		return m.CheckerData
	}
	return nil
}

func (m *Probe) GetSeverity() Probe_Severity {
	if m != nil {
		return m.Severity
	}
	return Probe_None
}

type Timestamp struct {
	Seconds              int64    `protobuf:"varint,1,opt,name=seconds,proto3" json:"seconds,omitempty"`
	Nanoseconds          int32    `protobuf:"varint,2,opt,name=nanoseconds,proto3" json:"nanoseconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Timestamp) Reset()         { *m = Timestamp{} }
func (m *Timestamp) String() string { return proto.CompactTextString(m) }
func (*Timestamp) ProtoMessage()    {}
func (*Timestamp) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{10}
}
func (m *Timestamp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Timestamp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Timestamp.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Timestamp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Timestamp.Merge(m, src)
}
func (m *Timestamp) XXX_Size() int {
	return m.Size()
}
func (m *Timestamp) XXX_DiscardUnknown() {
	xxx_messageInfo_Timestamp.DiscardUnknown(m)
}

var xxx_messageInfo_Timestamp proto.InternalMessageInfo

func (m *Timestamp) GetSeconds() int64 {
	if m != nil {
		return m.Seconds
	}
	return 0
}

func (m *Timestamp) GetNanoseconds() int32 {
	if m != nil {
		return m.Nanoseconds
	}
	return 0
}

// TimeRequest is a request to get the node's local time
type TimeRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeRequest) Reset()         { *m = TimeRequest{} }
func (m *TimeRequest) String() string { return proto.CompactTextString(m) }
func (*TimeRequest) ProtoMessage()    {}
func (*TimeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{11}
}
func (m *TimeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeRequest.Merge(m, src)
}
func (m *TimeRequest) XXX_Size() int {
	return m.Size()
}
func (m *TimeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TimeRequest proto.InternalMessageInfo

// TimeResponse contains the node's local time in UTC
type TimeResponse struct {
	// Timestamp is the node's local timestamp in UTC
	Timestamp            *Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *TimeResponse) Reset()         { *m = TimeResponse{} }
func (m *TimeResponse) String() string { return proto.CompactTextString(m) }
func (*TimeResponse) ProtoMessage()    {}
func (*TimeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{12}
}
func (m *TimeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeResponse.Merge(m, src)
}
func (m *TimeResponse) XXX_Size() int {
	return m.Size()
}
func (m *TimeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TimeResponse proto.InternalMessageInfo

func (m *TimeResponse) GetTimestamp() *Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

// UpdateRequest requests a new event be added to the timeline.
type UpdateRequest struct {
	// Name specifies the serf name of the requesting node.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Event specifies the event to be added to the timeline.
	Event                *TimelineEvent `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *UpdateRequest) Reset()         { *m = UpdateRequest{} }
func (m *UpdateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateRequest) ProtoMessage()    {}
func (*UpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{13}
}
func (m *UpdateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRequest.Merge(m, src)
}
func (m *UpdateRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRequest proto.InternalMessageInfo

func (m *UpdateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateRequest) GetEvent() *TimelineEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

// UpdateResponse indicates a successful update.
type UpdateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateResponse) Reset()         { *m = UpdateResponse{} }
func (m *UpdateResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateResponse) ProtoMessage()    {}
func (*UpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{14}
}
func (m *UpdateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateResponse.Merge(m, src)
}
func (m *UpdateResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateResponse proto.InternalMessageInfo

type TimelineRequest struct {
	// Params will be used to filter the timeline response.
	Params               map[string]string `protobuf:"bytes,1,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *TimelineRequest) Reset()         { *m = TimelineRequest{} }
func (m *TimelineRequest) String() string { return proto.CompactTextString(m) }
func (*TimelineRequest) ProtoMessage()    {}
func (*TimelineRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{15}
}
func (m *TimelineRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimelineRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimelineRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimelineRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimelineRequest.Merge(m, src)
}
func (m *TimelineRequest) XXX_Size() int {
	return m.Size()
}
func (m *TimelineRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TimelineRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TimelineRequest proto.InternalMessageInfo

func (m *TimelineRequest) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

type TimelineResponse struct {
	// Events contains a list of timeline events that occurred.
	Events               []*TimelineEvent `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TimelineResponse) Reset()         { *m = TimelineResponse{} }
func (m *TimelineResponse) String() string { return proto.CompactTextString(m) }
func (*TimelineResponse) ProtoMessage()    {}
func (*TimelineResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{16}
}
func (m *TimelineResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimelineResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimelineResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimelineResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimelineResponse.Merge(m, src)
}
func (m *TimelineResponse) XXX_Size() int {
	return m.Size()
}
func (m *TimelineResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TimelineResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TimelineResponse proto.InternalMessageInfo

func (m *TimelineResponse) GetEvents() []*TimelineEvent {
	if m != nil {
		return m.Events
	}
	return nil
}

type TimelineEvent struct {
	// Timestamp is the node's local timestamp in UTC.
	Timestamp *Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Data contains event specific data.
	//
	// Types that are valid to be assigned to Data:
	//	*TimelineEvent_ClusterHealthy
	//	*TimelineEvent_ClusterDegraded
	//	*TimelineEvent_ClusterUpgrade
	//	*TimelineEvent_NodeAdded
	//	*TimelineEvent_NodeRemoved
	//	*TimelineEvent_NodeHealthy
	//	*TimelineEvent_NodeDegraded
	//	*TimelineEvent_ProbeSucceeded
	//	*TimelineEvent_ProbeFailed
	//	*TimelineEvent_LeaderElected
	//	*TimelineEvent_UnknownEvent
	Data                 isTimelineEvent_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimelineEvent) Reset()         { *m = TimelineEvent{} }
func (m *TimelineEvent) String() string { return proto.CompactTextString(m) }
func (*TimelineEvent) ProtoMessage()    {}
func (*TimelineEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_56ede974c0020f77, []int{17}
}
func (m *TimelineEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimelineEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimelineEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimelineEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimelineEvent.Merge(m, src)
}
func (m *TimelineEvent) XXX_Size() int {
	return m.Size()
}
func (m *TimelineEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_TimelineEvent.DiscardUnknown(m)
}

var xxx_messageInfo_TimelineEvent proto.InternalMessageInfo

type isTimelineEvent_Data interface {
	isTimelineEvent_Data()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TimelineEvent_ClusterHealthy struct {
	ClusterHealthy *ClusterHealthy `protobuf:"bytes,2,opt,name=clusterHealthy,proto3,oneof"`
}
type TimelineEvent_ClusterDegraded struct {
	ClusterDegraded *ClusterDegraded `protobuf:"bytes,3,opt,name=clusterDegraded,proto3,oneof"`
}
type TimelineEvent_ClusterUpgrade struct {
	ClusterUpgrade *ClusterUpgrade `protobuf:"bytes,4,opt,name=clusterUpgrade,proto3,oneof"`
}
type TimelineEvent_NodeAdded struct {
	NodeAdded *NodeAdded `protobuf:"bytes,5,opt,name=nodeAdded,proto3,oneof"`
}
type TimelineEvent_NodeRemoved struct {
	NodeRemoved *NodeRemoved `protobuf:"bytes,6,opt,name=nodeRemoved,proto3,oneof"`
}
type TimelineEvent_NodeHealthy struct {
	NodeHealthy *NodeHealthy `protobuf:"bytes,7,opt,name=nodeHealthy,proto3,oneof"`
}
type TimelineEvent_NodeDegraded struct {
	NodeDegraded *NodeDegraded `protobuf:"bytes,8,opt,name=nodeDegraded,proto3,oneof"`
}
type TimelineEvent_ProbeSucceeded struct {
	ProbeSucceeded *ProbeSucceeded `protobuf:"bytes,9,opt,name=probeSucceeded,proto3,oneof"`
}
type TimelineEvent_ProbeFailed struct {
	ProbeFailed *ProbeFailed `protobuf:"bytes,10,opt,name=probeFailed,proto3,oneof"`
}
type TimelineEvent_LeaderElected struct {
	LeaderElected *LeaderElected `protobuf:"bytes,11,opt,name=leaderElected,proto3,oneof"`
}
type TimelineEvent_UnknownEvent struct {
	UnknownEvent *UnknownEvent `protobuf:"bytes,12,opt,name=unknownEvent,proto3,oneof"`
}

func (*TimelineEvent_ClusterHealthy) isTimelineEvent_Data()  {}
func (*TimelineEvent_ClusterDegraded) isTimelineEvent_Data() {}
func (*TimelineEvent_ClusterUpgrade) isTimelineEvent_Data()  {}
func (*TimelineEvent_NodeAdded) isTimelineEvent_Data()       {}
func (*TimelineEvent_NodeRemoved) isTimelineEvent_Data()     {}
func (*TimelineEvent_NodeHealthy) isTimelineEvent_Data()     {}
func (*TimelineEvent_NodeDegraded) isTimelineEvent_Data()    {}
func (*TimelineEvent_ProbeSucceeded) isTimelineEvent_Data()  {}
func (*TimelineEvent_ProbeFailed) isTimelineEvent_Data()     {}
func (*TimelineEvent_LeaderElected) isTimelineEvent_Data()   {}
func (*TimelineEvent_UnknownEvent) isTimelineEvent_Data()    {}

func (m *TimelineEvent) GetData() isTimelineEvent_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *TimelineEvent) GetTimestamp() *Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *TimelineEvent) GetClusterHealthy() *ClusterHealthy {
	if x, ok := m.GetData().(*TimelineEvent_ClusterHealthy); ok {
		return x.ClusterHealthy
	}
	return nil
}

func (m *TimelineEvent) GetClusterDegraded() *ClusterDegraded {
	if x, ok := m.GetData().(*TimelineEvent_ClusterDegraded); ok {
		return x.ClusterDegraded
	}
	return nil
}

func (m *TimelineEvent) GetClusterUpgrade() *ClusterUpgrade {
	if x, ok := m.GetData().(*TimelineEvent_ClusterUpgrade); ok {
		return x.ClusterUpgrade
	}
	return nil
}

func (m *TimelineEvent) GetNodeAdded() *NodeAdded {
	if x, ok := m.GetData().(*TimelineEvent_NodeAdded); ok {
		return x.NodeAdded
	}
	return nil
}

func (m *TimelineEvent) GetNodeRemoved() *NodeRemoved {
	if x, ok := m.GetData().(*TimelineEvent_NodeRemoved); ok {
		return x.NodeRemoved
	}
	return nil
}

func (m *TimelineEvent) GetNodeHealthy() *NodeHealthy {
	if x, ok := m.GetData().(*TimelineEvent_NodeHealthy); ok {
		return x.NodeHealthy
	}
	return nil
}

func (m *TimelineEvent) GetNodeDegraded() *NodeDegraded {
	if x, ok := m.GetData().(*TimelineEvent_NodeDegraded); ok {
		return x.NodeDegraded
	}
	return nil
}

func (m *TimelineEvent) GetProbeSucceeded() *ProbeSucceeded {
	if x, ok := m.GetData().(*TimelineEvent_ProbeSucceeded); ok {
		return x.ProbeSucceeded
	}
	return nil
}

func (m *TimelineEvent) GetProbeFailed() *ProbeFailed {
	if x, ok := m.GetData().(*TimelineEvent_ProbeFailed); ok {
		return x.ProbeFailed
	}
	return nil
}

func (m *TimelineEvent) GetLeaderElected() *LeaderElected {
	if x, ok := m.GetData().(*TimelineEvent_LeaderElected); ok {
		return x.LeaderElected
	}
	return nil
}

func (m *TimelineEvent) GetUnknownEvent() *UnknownEvent {
	if x, ok := m.GetData().(*TimelineEvent_UnknownEvent); ok {
		return x.UnknownEvent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TimelineEvent) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TimelineEvent_OneofMarshaler, _TimelineEvent_OneofUnmarshaler, _TimelineEvent_OneofSizer, []interface{}{
		(*TimelineEvent_ClusterHealthy)(nil),
		(*TimelineEvent_ClusterDegraded)(nil),
		(*TimelineEvent_ClusterUpgrade)(nil),
		(*TimelineEvent_NodeAdded)(nil),
		(*TimelineEvent_NodeRemoved)(nil),
		(*TimelineEvent_NodeHealthy)(nil),
		(*TimelineEvent_NodeDegraded)(nil),
		(*TimelineEvent_ProbeSucceeded)(nil),
		(*TimelineEvent_ProbeFailed)(nil),
		(*TimelineEvent_LeaderElected)(nil),
		(*TimelineEvent_UnknownEvent)(nil),
	}
}

func _TimelineEvent_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TimelineEvent)
	// data
	switch x := m.Data.(type) {
	case *TimelineEvent_ClusterHealthy:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterHealthy); err != nil {
			return err
		}
	case *TimelineEvent_ClusterDegraded:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterDegraded); err != nil {
			return err
		}
	case *TimelineEvent_ClusterUpgrade:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterUpgrade); err != nil {
			return err
		}
	case *TimelineEvent_NodeAdded:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NodeAdded); err != nil {
			return err
		}
	case *TimelineEvent_NodeRemoved:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NodeRemoved); err != nil {
			return err
		}
	case *TimelineEvent_NodeHealthy:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NodeHealthy); err != nil {
			return err
		}
	case *TimelineEvent_NodeDegraded:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NodeDegraded); err != nil {
			return err
		}
	case *TimelineEvent_ProbeSucceeded:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProbeSucceeded); err != nil {
			return err
		}
	case *TimelineEvent_ProbeFailed:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProbeFailed); err != nil {
			return err
		}
	case *TimelineEvent_LeaderElected:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeaderElected); err != nil {
			return err
		}
	case *TimelineEvent_UnknownEvent:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UnknownEvent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TimelineEvent.Data has unexpected type %T", x)
	}
	return nil
}

func _TimelineEvent_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TimelineEvent)
	switch tag {
	case 2: // data.clusterHealthy
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClusterHealthy)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_ClusterHealthy{msg}
		return true, err
	case 3: // data.clusterDegraded
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClusterDegraded)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_ClusterDegraded{msg}
		return true, err
	case 4: // data.clusterUpgrade
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClusterUpgrade)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_ClusterUpgrade{msg}
		return true, err
	case 5: // data.nodeAdded
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NodeAdded)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_NodeAdded{msg}
		return true, err
	case 6: // data.nodeRemoved
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NodeRemoved)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_NodeRemoved{msg}
		return true, err
	case 7: // data.nodeHealthy
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NodeHealthy)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_NodeHealthy{msg}
		return true, err
	case 8: // data.nodeDegraded
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NodeDegraded)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_NodeDegraded{msg}
		return true, err
	case 9: // data.probeSucceeded
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProbeSucceeded)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_ProbeSucceeded{msg}
		return true, err
	case 10: // data.probeFailed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProbeFailed)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_ProbeFailed{msg}
		return true, err
	case 11: // data.leaderElected
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LeaderElected)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_LeaderElected{msg}
		return true, err
	case 12: // data.unknownEvent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UnknownEvent)
		err := b.DecodeMessage(msg)
		m.Data = &TimelineEvent_UnknownEvent{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TimelineEvent_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TimelineEvent)
	// data
	switch x := m.Data.(type) {
	case *TimelineEvent_ClusterHealthy:
		s := proto.Size(x.ClusterHealthy)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_ClusterDegraded:
		s := proto.Size(x.ClusterDegraded)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_ClusterUpgrade:
		s := proto.Size(x.ClusterUpgrade)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_NodeAdded:
		s := proto.Size(x.NodeAdded)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_NodeRemoved:
		s := proto.Size(x.NodeRemoved)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_NodeHealthy:
		s := proto.Size(x.NodeHealthy)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_NodeDegraded:
		s := proto.Size(x.NodeDegraded)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_ProbeSucceeded:
		s := proto.Size(x.ProbeSucceeded)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_ProbeFailed:
		s := proto.Size(x.ProbeFailed)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_LeaderElected:
		s := proto.Size(x.LeaderElected)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimelineEvent_UnknownEvent:
		s := proto.Size(x.UnknownEvent)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterEnum("agentpb.SystemStatus_Type", SystemStatus_Type_name, SystemStatus_Type_value)
	proto.RegisterEnum("agentpb.MemberStatus_Type", MemberStatus_Type_name, MemberStatus_Type_value)
	proto.RegisterEnum("agentpb.NodeStatus_Type", NodeStatus_Type_name, NodeStatus_Type_value)
	proto.RegisterEnum("agentpb.Probe_Type", Probe_Type_name, Probe_Type_value)
	proto.RegisterEnum("agentpb.Probe_Severity", Probe_Severity_name, Probe_Severity_value)
	proto.RegisterType((*StatusRequest)(nil), "agentpb.StatusRequest")
	proto.RegisterType((*StatusResponse)(nil), "agentpb.StatusResponse")
	proto.RegisterType((*LocalStatusRequest)(nil), "agentpb.LocalStatusRequest")
	proto.RegisterType((*LocalStatusResponse)(nil), "agentpb.LocalStatusResponse")
	proto.RegisterType((*LastSeenRequest)(nil), "agentpb.LastSeenRequest")
	proto.RegisterType((*LastSeenResponse)(nil), "agentpb.LastSeenResponse")
	proto.RegisterType((*SystemStatus)(nil), "agentpb.SystemStatus")
	proto.RegisterType((*MemberStatus)(nil), "agentpb.MemberStatus")
	proto.RegisterMapType((map[string]string)(nil), "agentpb.MemberStatus.TagsEntry")
	proto.RegisterType((*NodeStatus)(nil), "agentpb.NodeStatus")
	proto.RegisterType((*Probe)(nil), "agentpb.Probe")
	proto.RegisterType((*Timestamp)(nil), "agentpb.Timestamp")
	proto.RegisterType((*TimeRequest)(nil), "agentpb.TimeRequest")
	proto.RegisterType((*TimeResponse)(nil), "agentpb.TimeResponse")
	proto.RegisterType((*UpdateRequest)(nil), "agentpb.UpdateRequest")
	proto.RegisterType((*UpdateResponse)(nil), "agentpb.UpdateResponse")
	proto.RegisterType((*TimelineRequest)(nil), "agentpb.TimelineRequest")
	proto.RegisterMapType((map[string]string)(nil), "agentpb.TimelineRequest.ParamsEntry")
	proto.RegisterType((*TimelineResponse)(nil), "agentpb.TimelineResponse")
	proto.RegisterType((*TimelineEvent)(nil), "agentpb.TimelineEvent")
}

func init() { proto.RegisterFile("agent.proto", fileDescriptor_56ede974c0020f77) }

var fileDescriptor_56ede974c0020f77 = []byte{
	// 1117 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0xb7, 0x93, 0x38, 0x4d, 0x9e, 0x93, 0xd4, 0x9a, 0x76, 0x77, 0x4d, 0x40, 0xa5, 0x58, 0x80,
	0x16, 0x01, 0x61, 0x95, 0x0a, 0xb1, 0xec, 0xae, 0x16, 0xfa, 0x0f, 0x22, 0x54, 0xaa, 0xe2, 0xb6,
	0xe2, 0xb8, 0x9a, 0xc6, 0x8f, 0x6e, 0x54, 0xff, 0x09, 0xf6, 0x24, 0x28, 0x5f, 0x81, 0x23, 0xa7,
	0xfd, 0x48, 0x1c, 0xb9, 0x71, 0x45, 0x45, 0x42, 0xe2, 0xce, 0x07, 0x40, 0x33, 0x9e, 0x89, 0xc7,
	0x6e, 0x0a, 0x94, 0x9b, 0xdf, 0xff, 0xdf, 0xfb, 0xf9, 0xcd, 0x9b, 0x01, 0x9b, 0x5e, 0x62, 0xcc,
	0x06, 0xd3, 0x34, 0x61, 0x09, 0x59, 0x13, 0xc2, 0xf4, 0xa2, 0x6f, 0xe3, 0x7c, 0xa9, 0xf5, 0xd6,
	0xa1, 0x7b, 0xca, 0x28, 0x9b, 0x65, 0x3e, 0x7e, 0x3f, 0xc3, 0x8c, 0x79, 0x9f, 0x41, 0x4f, 0x29,
	0xb2, 0x69, 0x12, 0x67, 0x48, 0x3e, 0x84, 0x66, 0x26, 0x34, 0xae, 0xb9, 0x6d, 0x3e, 0xb4, 0x87,
	0xf7, 0x06, 0x32, 0xd3, 0xe0, 0x74, 0x91, 0x31, 0x8c, 0xa4, 0xbb, 0x74, 0xf2, 0x36, 0x81, 0x1c,
	0x25, 0x63, 0x1a, 0x96, 0xd3, 0xee, 0xc1, 0x46, 0x49, 0x2b, 0x73, 0xbf, 0x5f, 0xc9, 0xbd, 0xb1,
	0xcc, 0x7d, 0x9c, 0x04, 0x58, 0xc9, 0xfc, 0x0e, 0xac, 0x1f, 0xd1, 0x8c, 0x9d, 0x22, 0xc6, 0x32,
	0x2d, 0x21, 0xd0, 0x88, 0x69, 0x84, 0x22, 0xba, 0xed, 0x8b, 0x6f, 0xef, 0x00, 0x9c, 0xc2, 0x4d,
	0xd6, 0x79, 0x04, 0x6d, 0x36, 0x89, 0x30, 0x63, 0x34, 0x9a, 0xca, 0x52, 0x64, 0x59, 0xea, 0x4c,
	0x59, 0xfc, 0xc2, 0xc9, 0xfb, 0xd3, 0x84, 0x8e, 0xde, 0x1f, 0x19, 0x96, 0xa0, 0xf6, 0x86, 0xfd,
	0x95, 0x34, 0x0c, 0xce, 0x16, 0x53, 0x54, 0x88, 0xc9, 0x7b, 0x60, 0xc5, 0x49, 0x80, 0x99, 0x5b,
	0xdb, 0xae, 0xdf, 0xd6, 0x5d, 0xee, 0x51, 0x46, 0x58, 0xff, 0x0f, 0x08, 0x89, 0x0b, 0x6b, 0xd9,
	0x2c, 0x8a, 0x68, 0xba, 0x70, 0x1b, 0xa2, 0x7d, 0x25, 0x7a, 0x03, 0x68, 0x70, 0x18, 0xc4, 0x86,
	0xb5, 0xf3, 0xf8, 0x2a, 0x4e, 0x7e, 0x88, 0x1d, 0x83, 0x0b, 0xfe, 0x2c, 0x8e, 0x27, 0xf1, 0xa5,
	0x63, 0x92, 0x0e, 0xb4, 0x0e, 0xf0, 0x32, 0xa5, 0x01, 0x06, 0x4e, 0xcd, 0x7b, 0x55, 0x83, 0xce,
	0xd7, 0x18, 0x5d, 0x60, 0x2a, 0x7b, 0x5d, 0x41, 0x2b, 0xd7, 0xd1, 0x20, 0x48, 0xdd, 0x5a, 0xae,
	0xe3, 0xdf, 0x1a, 0x27, 0xf5, 0x0a, 0x27, 0x7a, 0xba, 0x32, 0x27, 0x3b, 0xd0, 0x60, 0xf4, 0x32,
	0x73, 0x1b, 0x82, 0x92, 0x37, 0x6f, 0x89, 0xa0, 0x97, 0xd9, 0x61, 0xcc, 0xd2, 0x85, 0x2f, 0x9c,
	0xfb, 0x9f, 0x40, 0x7b, 0xa9, 0x22, 0x0e, 0xd4, 0xaf, 0x70, 0x21, 0xc1, 0xf1, 0x4f, 0xb2, 0x09,
	0xd6, 0x9c, 0x86, 0x33, 0x94, 0xe0, 0x72, 0xe1, 0x49, 0xed, 0xb1, 0xe9, 0x3d, 0x97, 0x54, 0xb4,
	0xa0, 0x71, 0x9c, 0xc4, 0xe8, 0x18, 0xa4, 0x0d, 0xd6, 0x6e, 0x38, 0x99, 0xa3, 0x63, 0x72, 0x4a,
	0x8e, 0x90, 0xce, 0x39, 0x25, 0x35, 0xee, 0x71, 0x84, 0xdf, 0x31, 0xa7, 0x4e, 0x00, 0x9a, 0x5f,
	0xd0, 0x49, 0x88, 0x81, 0xd3, 0xf0, 0xfe, 0x30, 0x01, 0x8a, 0x9f, 0xb5, 0x92, 0x98, 0x27, 0xd0,
	0x8d, 0x04, 0xf6, 0x17, 0x92, 0x8b, 0x5a, 0xe5, 0x98, 0xe8, 0x9d, 0xf9, 0x9d, 0x48, 0x27, 0xfa,
	0x51, 0x85, 0x40, 0x77, 0xc5, 0x84, 0x94, 0xe9, 0x7b, 0x17, 0x9a, 0xd3, 0x34, 0xb9, 0x40, 0x45,
	0x60, 0x6f, 0x19, 0x71, 0xc2, 0xd5, 0xbe, 0xb4, 0xde, 0x79, 0x06, 0x7e, 0xad, 0x81, 0x25, 0x32,
	0xf0, 0xb9, 0x1a, 0xbf, 0xc4, 0xf1, 0x15, 0xa6, 0xb2, 0x4d, 0x25, 0x92, 0xfb, 0xd0, 0x0c, 0x90,
	0xd1, 0x49, 0x28, 0x79, 0x96, 0x12, 0x67, 0x65, 0x9c, 0x04, 0x28, 0x7a, 0x68, 0xfb, 0xe2, 0x5b,
	0x3b, 0xd9, 0x0d, 0xd1, 0xd9, 0x46, 0x19, 0x67, 0xb9, 0xa9, 0x4d, 0xb0, 0x30, 0x4d, 0x93, 0xd4,
	0xb5, 0xf2, 0xff, 0x27, 0x04, 0xf2, 0x16, 0x74, 0x64, 0xe5, 0x17, 0x01, 0x65, 0xd4, 0x6d, 0x6e,
	0x9b, 0x0f, 0x3b, 0xbe, 0x2d, 0x75, 0x07, 0x94, 0x51, 0xb2, 0x03, 0xad, 0x0c, 0xe7, 0x98, 0x4e,
	0xd8, 0xc2, 0x5d, 0x13, 0x75, 0x1e, 0x54, 0xea, 0x9c, 0x4a, 0xb3, 0xbf, 0x74, 0xf4, 0x9e, 0xfd,
	0x2b, 0x35, 0xc5, 0x04, 0xd4, 0x48, 0x0f, 0xe0, 0x0c, 0xd3, 0x68, 0x12, 0x53, 0x86, 0x81, 0x53,
	0xf7, 0x3e, 0x82, 0x96, 0xca, 0xa9, 0x4d, 0x55, 0x07, 0x5a, 0xfb, 0xe9, 0x84, 0x4d, 0xc6, 0x34,
	0xcc, 0x07, 0xeb, 0x5b, 0x9a, 0x8a, 0x64, 0x35, 0xef, 0x4b, 0x68, 0x9f, 0x95, 0x0e, 0x2d, 0x8e,
	0x93, 0x38, 0xc8, 0xd7, 0x48, 0xdd, 0x57, 0x22, 0xd9, 0x06, 0x3b, 0xa6, 0x71, 0xa2, 0xac, 0x9c,
	0x61, 0xcb, 0xd7, 0x55, 0x5e, 0x17, 0x6c, 0x9e, 0x48, 0xad, 0xd4, 0xcf, 0xa1, 0x93, 0x8b, 0xff,
	0x7b, 0xc7, 0x7d, 0x03, 0xdd, 0xf3, 0x69, 0x40, 0x19, 0xfe, 0xc3, 0x3a, 0x25, 0x1f, 0x80, 0x25,
	0x2e, 0x0c, 0x39, 0xd6, 0xf7, 0x4b, 0x29, 0xc3, 0x49, 0x8c, 0x87, 0xdc, 0xea, 0xe7, 0x4e, 0x9e,
	0x03, 0x3d, 0x95, 0x32, 0x87, 0xe5, 0xfd, 0x68, 0xc2, 0xba, 0x72, 0x55, 0x75, 0x9e, 0x41, 0x73,
	0x4a, 0x53, 0x1a, 0x71, 0x12, 0xf8, 0x10, 0xbf, 0x7d, 0x23, 0xa9, 0xf4, 0x1c, 0x9c, 0x08, 0xb7,
	0x7c, 0x15, 0xc8, 0x98, 0xfe, 0xa7, 0x60, 0x6b, 0xea, 0x3b, 0xad, 0x83, 0x3d, 0x70, 0x8a, 0x0a,
	0x92, 0xb7, 0x01, 0x34, 0x05, 0x76, 0x05, 0xe6, 0xb6, 0x0e, 0xa5, 0x97, 0xf7, 0x97, 0x05, 0xdd,
	0x92, 0xe5, 0xee, 0xcc, 0x93, 0x5d, 0xe8, 0x8d, 0xc3, 0x59, 0xc6, 0x30, 0x1d, 0x21, 0x0d, 0xd9,
	0xcb, 0x85, 0x64, 0xb7, 0x98, 0xde, 0xfd, 0x92, 0x79, 0x64, 0xf8, 0x95, 0x00, 0x72, 0x00, 0xeb,
	0x52, 0xa3, 0x4e, 0xb1, 0xbc, 0x36, 0xdc, 0x6a, 0x0e, 0x65, 0x1f, 0x19, 0x7e, 0x35, 0x44, 0x03,
	0x72, 0x3e, 0x15, 0x2a, 0x71, 0x5c, 0x57, 0x00, 0x91, 0x66, 0x0d, 0x88, 0xd4, 0x90, 0x21, 0xb4,
	0xf9, 0x15, 0xb6, 0x1b, 0x70, 0x08, 0x56, 0xa5, 0xfb, 0x63, 0x65, 0x19, 0x19, 0x7e, 0xe1, 0x46,
	0x1e, 0x83, 0xcd, 0x05, 0x1f, 0xa3, 0x64, 0x8e, 0x81, 0x38, 0xd9, 0xf6, 0x70, 0xb3, 0x14, 0x25,
	0x6d, 0x23, 0xc3, 0xd7, 0x5d, 0x55, 0xa4, 0xa2, 0x6d, 0x6d, 0x45, 0x64, 0xc1, 0x99, 0xee, 0x4a,
	0x9e, 0x42, 0x87, 0x8b, 0x4b, 0xb6, 0x5a, 0x95, 0x35, 0x7d, 0xac, 0x19, 0x47, 0x86, 0x5f, 0x72,
	0xe6, 0x3c, 0x89, 0xc5, 0x7a, 0x3a, 0x1b, 0x8f, 0x11, 0x79, 0x78, 0xbb, 0xc2, 0xd3, 0x49, 0xc9,
	0xcc, 0x79, 0x2a, 0x07, 0x70, 0xe4, 0x42, 0x93, 0x6f, 0x16, 0x17, 0x2a, 0xc8, 0x4f, 0x0a, 0x1b,
	0x47, 0xae, 0xb9, 0x92, 0xe7, 0xd0, 0x0d, 0x91, 0x06, 0x98, 0x1e, 0x86, 0x38, 0x66, 0x18, 0xb8,
	0x76, 0xe5, 0x28, 0x1e, 0xe9, 0xd6, 0x91, 0xe1, 0x97, 0xdd, 0x79, 0xe7, 0xb3, 0x7c, 0xd1, 0x89,
	0x79, 0x75, 0x3b, 0x95, 0xce, 0xcf, 0x35, 0x23, 0xef, 0x5c, 0x77, 0xde, 0x6b, 0x42, 0x83, 0x6f,
	0xdf, 0xe1, 0x4f, 0x75, 0xb0, 0x76, 0x79, 0x00, 0x79, 0x0a, 0x4d, 0x79, 0x7d, 0x15, 0x08, 0x4a,
	0xaf, 0xbd, 0xfe, 0x83, 0x1b, 0x7a, 0xb9, 0x0c, 0x0c, 0xf2, 0x15, 0xd8, 0xda, 0x43, 0x90, 0xbc,
	0x5e, 0xf4, 0x70, 0xe3, 0xd1, 0xd8, 0x7f, 0x63, 0xb5, 0x71, 0x99, 0x6b, 0x17, 0x5a, 0xea, 0xa5,
	0x47, 0x8a, 0xa9, 0xaf, 0xbc, 0x11, 0xfb, 0xaf, 0xad, 0xb0, 0x2c, 0x53, 0x7c, 0x0c, 0x0d, 0x7e,
	0x40, 0xc9, 0x66, 0xe9, 0xbc, 0xaa, 0xd0, 0x7b, 0x15, 0xad, 0x5e, 0x59, 0xad, 0x00, 0xad, 0x72,
	0x65, 0x79, 0x69, 0x95, 0xab, 0x4b, 0xc7, 0x33, 0xc8, 0xbe, 0xda, 0x94, 0xcb, 0x44, 0x05, 0x9b,
	0xa5, 0xad, 0xac, 0xb1, 0x59, 0x59, 0xad, 0xc6, 0x9e, 0xf3, 0xf3, 0xf5, 0x96, 0xf9, 0xcb, 0xf5,
	0x96, 0xf9, 0xdb, 0xf5, 0x96, 0xf9, 0xea, 0xf7, 0x2d, 0xe3, 0xa2, 0x29, 0xde, 0xf5, 0x3b, 0x7f,
	0x07, 0x00, 0x00, 0xff, 0xff, 0x1b, 0x50, 0x90, 0xb5, 0xfc, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AgentClient is the client API for Agent service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentClient interface {
	// Status collects the global cluster status
	Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error)
	// LocalStatus collects the local node status
	LocalStatus(ctx context.Context, in *LocalStatusRequest, opts ...grpc.CallOption) (*LocalStatusResponse, error)
	// LastSeen requests the last seen timestamp for a specified member
	LastSeen(ctx context.Context, in *LastSeenRequest, opts ...grpc.CallOption) (*LastSeenResponse, error)
	// Time requests the node's local time in UTC
	Time(ctx context.Context, in *TimeRequest, opts ...grpc.CallOption) (*TimeResponse, error)
	// Timeline collects the status timeline
	Timeline(ctx context.Context, in *TimelineRequest, opts ...grpc.CallOption) (*TimelineResponse, error)
	// UpdateTimeline requests a new event be added to the timeline.
	// This RPC is idempotent. Repeated calls with the same event will have no effect.
	UpdateTimeline(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error)
}

type agentClient struct {
	cc *grpc.ClientConn
}

func NewAgentClient(cc *grpc.ClientConn) AgentClient {
	return &agentClient{cc}
}

func (c *agentClient) Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error) {
	out := new(StatusResponse)
	err := c.cc.Invoke(ctx, "/agentpb.Agent/Status", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) LocalStatus(ctx context.Context, in *LocalStatusRequest, opts ...grpc.CallOption) (*LocalStatusResponse, error) {
	out := new(LocalStatusResponse)
	err := c.cc.Invoke(ctx, "/agentpb.Agent/LocalStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) LastSeen(ctx context.Context, in *LastSeenRequest, opts ...grpc.CallOption) (*LastSeenResponse, error) {
	out := new(LastSeenResponse)
	err := c.cc.Invoke(ctx, "/agentpb.Agent/LastSeen", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) Time(ctx context.Context, in *TimeRequest, opts ...grpc.CallOption) (*TimeResponse, error) {
	out := new(TimeResponse)
	err := c.cc.Invoke(ctx, "/agentpb.Agent/Time", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) Timeline(ctx context.Context, in *TimelineRequest, opts ...grpc.CallOption) (*TimelineResponse, error) {
	out := new(TimelineResponse)
	err := c.cc.Invoke(ctx, "/agentpb.Agent/Timeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentClient) UpdateTimeline(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error) {
	out := new(UpdateResponse)
	err := c.cc.Invoke(ctx, "/agentpb.Agent/UpdateTimeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentServer is the server API for Agent service.
type AgentServer interface {
	// Status collects the global cluster status
	Status(context.Context, *StatusRequest) (*StatusResponse, error)
	// LocalStatus collects the local node status
	LocalStatus(context.Context, *LocalStatusRequest) (*LocalStatusResponse, error)
	// LastSeen requests the last seen timestamp for a specified member
	LastSeen(context.Context, *LastSeenRequest) (*LastSeenResponse, error)
	// Time requests the node's local time in UTC
	Time(context.Context, *TimeRequest) (*TimeResponse, error)
	// Timeline collects the status timeline
	Timeline(context.Context, *TimelineRequest) (*TimelineResponse, error)
	// UpdateTimeline requests a new event be added to the timeline.
	// This RPC is idempotent. Repeated calls with the same event will have no effect.
	UpdateTimeline(context.Context, *UpdateRequest) (*UpdateResponse, error)
}

func RegisterAgentServer(s *grpc.Server, srv AgentServer) {
	s.RegisterService(&_Agent_serviceDesc, srv)
}

func _Agent_Status_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).Status(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/agentpb.Agent/Status",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).Status(ctx, req.(*StatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_LocalStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LocalStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).LocalStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/agentpb.Agent/LocalStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).LocalStatus(ctx, req.(*LocalStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_LastSeen_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LastSeenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).LastSeen(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/agentpb.Agent/LastSeen",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).LastSeen(ctx, req.(*LastSeenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_Time_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).Time(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/agentpb.Agent/Time",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).Time(ctx, req.(*TimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_Timeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TimelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).Timeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/agentpb.Agent/Timeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).Timeline(ctx, req.(*TimelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agent_UpdateTimeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentServer).UpdateTimeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/agentpb.Agent/UpdateTimeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentServer).UpdateTimeline(ctx, req.(*UpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Agent_serviceDesc = grpc.ServiceDesc{
	ServiceName: "agentpb.Agent",
	HandlerType: (*AgentServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Status",
			Handler:    _Agent_Status_Handler,
		},
		{
			MethodName: "LocalStatus",
			Handler:    _Agent_LocalStatus_Handler,
		},
		{
			MethodName: "LastSeen",
			Handler:    _Agent_LastSeen_Handler,
		},
		{
			MethodName: "Time",
			Handler:    _Agent_Time_Handler,
		},
		{
			MethodName: "Timeline",
			Handler:    _Agent_Timeline_Handler,
		},
		{
			MethodName: "UpdateTimeline",
			Handler:    _Agent_UpdateTimeline_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "agent.proto",
}

func (m *StatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Status.Size()))
		n1, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LocalStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LocalStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Status.Size()))
		n2, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LastSeenRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LastSeenRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LastSeenResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LastSeenResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Timestamp.Size()))
		n3, err := m.Timestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SystemStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SystemStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Status))
	}
	if len(m.Nodes) > 0 {
		for _, msg := range m.Nodes {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Timestamp != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Timestamp.Size()))
		n4, err := m.Timestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.Summary) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Summary)))
		i += copy(dAtA[i:], m.Summary)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MemberStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemberStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Addr) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Status))
	}
	if len(m.Tags) > 0 {
		for k, _ := range m.Tags {
			dAtA[i] = 0x22
			i++
			v := m.Tags[k]
			mapSize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + len(v) + sovAgent(uint64(len(v)))
			i = encodeVarintAgent(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAgent(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NodeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.MemberStatus != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.MemberStatus.Size()))
		n5, err := m.MemberStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Status))
	}
	if len(m.Probes) > 0 {
		for _, msg := range m.Probes {
			dAtA[i] = 0x22
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Probe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Probe) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Checker) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Checker)))
		i += copy(dAtA[i:], m.Checker)
	}
	if len(m.Detail) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Detail)))
		i += copy(dAtA[i:], m.Detail)
	}
	if len(m.Code) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Code)))
		i += copy(dAtA[i:], m.Code)
	}
	if m.Status != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Status))
	}
	if len(m.Error) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Error)))
		i += copy(dAtA[i:], m.Error)
	}
	if len(m.CheckerData) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.CheckerData)))
		i += copy(dAtA[i:], m.CheckerData)
	}
	if m.Severity != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Severity))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Timestamp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Timestamp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Seconds != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Seconds))
	}
	if m.Nanoseconds != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Nanoseconds))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TimeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TimeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Timestamp.Size()))
		n6, err := m.Timestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpdateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Event != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Event.Size()))
		n7, err := m.Event.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpdateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TimelineRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimelineRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Params) > 0 {
		for k, _ := range m.Params {
			dAtA[i] = 0xa
			i++
			v := m.Params[k]
			mapSize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + len(v) + sovAgent(uint64(len(v)))
			i = encodeVarintAgent(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAgent(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TimelineResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimelineResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TimelineEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimelineEvent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Timestamp.Size()))
		n8, err := m.Timestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Data != nil {
		nn9, err := m.Data.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn9
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TimelineEvent_ClusterHealthy) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterHealthy != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ClusterHealthy.Size()))
		n10, err := m.ClusterHealthy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *TimelineEvent_ClusterDegraded) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterDegraded != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ClusterDegraded.Size()))
		n11, err := m.ClusterDegraded.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *TimelineEvent_ClusterUpgrade) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterUpgrade != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ClusterUpgrade.Size()))
		n12, err := m.ClusterUpgrade.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *TimelineEvent_NodeAdded) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NodeAdded != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.NodeAdded.Size()))
		n13, err := m.NodeAdded.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *TimelineEvent_NodeRemoved) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NodeRemoved != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.NodeRemoved.Size()))
		n14, err := m.NodeRemoved.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *TimelineEvent_NodeHealthy) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NodeHealthy != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.NodeHealthy.Size()))
		n15, err := m.NodeHealthy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *TimelineEvent_NodeDegraded) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NodeDegraded != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.NodeDegraded.Size()))
		n16, err := m.NodeDegraded.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}
func (m *TimelineEvent_ProbeSucceeded) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ProbeSucceeded != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ProbeSucceeded.Size()))
		n17, err := m.ProbeSucceeded.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *TimelineEvent_ProbeFailed) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ProbeFailed != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ProbeFailed.Size()))
		n18, err := m.ProbeFailed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}
func (m *TimelineEvent_LeaderElected) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LeaderElected != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.LeaderElected.Size()))
		n19, err := m.LeaderElected.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}
func (m *TimelineEvent_UnknownEvent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.UnknownEvent != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.UnknownEvent.Size()))
		n20, err := m.UnknownEvent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	return i, nil
}
func encodeVarintAgent(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LastSeenRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LastSeenResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SystemStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovAgent(uint64(m.Status))
	}
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Summary)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MemberStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovAgent(uint64(m.Status))
	}
	if len(m.Tags) > 0 {
		for k, v := range m.Tags {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + len(v) + sovAgent(uint64(len(v)))
			n += mapEntrySize + 1 + sovAgent(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.MemberStatus != nil {
		l = m.MemberStatus.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovAgent(uint64(m.Status))
	}
	if len(m.Probes) > 0 {
		for _, e := range m.Probes {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Probe) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Checker)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Detail)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Code)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovAgent(uint64(m.Status))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.CheckerData)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Severity != 0 {
		n += 1 + sovAgent(uint64(m.Severity))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Timestamp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Seconds != 0 {
		n += 1 + sovAgent(uint64(m.Seconds))
	}
	if m.Nanoseconds != 0 {
		n += 1 + sovAgent(uint64(m.Nanoseconds))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Event != nil {
		l = m.Event.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimelineRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Params) > 0 {
		for k, v := range m.Params {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + len(v) + sovAgent(uint64(len(v)))
			n += mapEntrySize + 1 + sovAgent(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimelineResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimelineEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Data != nil {
		n += m.Data.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimelineEvent_ClusterHealthy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterHealthy != nil {
		l = m.ClusterHealthy.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_ClusterDegraded) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterDegraded != nil {
		l = m.ClusterDegraded.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_ClusterUpgrade) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterUpgrade != nil {
		l = m.ClusterUpgrade.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_NodeAdded) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeAdded != nil {
		l = m.NodeAdded.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_NodeRemoved) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeRemoved != nil {
		l = m.NodeRemoved.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_NodeHealthy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeHealthy != nil {
		l = m.NodeHealthy.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_NodeDegraded) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeDegraded != nil {
		l = m.NodeDegraded.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_ProbeSucceeded) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProbeSucceeded != nil {
		l = m.ProbeSucceeded.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_ProbeFailed) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProbeFailed != nil {
		l = m.ProbeFailed.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_LeaderElected) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LeaderElected != nil {
		l = m.LeaderElected.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}
func (m *TimelineEvent_UnknownEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UnknownEvent != nil {
		l = m.UnknownEvent.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func sovAgent(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAgent(x uint64) (n int) {
	return sovAgent(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &SystemStatus{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &NodeStatus{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LastSeenRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LastSeenRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LastSeenRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LastSeenResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LastSeenResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LastSeenResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SystemStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SystemStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SystemStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= SystemStatus_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, &NodeStatus{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Summary", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Summary = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemberStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemberStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemberStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= MemberStatus_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tags == nil {
				m.Tags = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAgent
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAgent
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAgent
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAgent
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAgent(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAgent
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Tags[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MemberStatus == nil {
				m.MemberStatus = &MemberStatus{}
			}
			if err := m.MemberStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= NodeStatus_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Probes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Probes = append(m.Probes, &Probe{})
			if err := m.Probes[len(m.Probes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Probe) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Probe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Probe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checker", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checker = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Detail = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Code = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= Probe_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckerData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CheckerData = append(m.CheckerData[:0], dAtA[iNdEx:postIndex]...)
			if m.CheckerData == nil {
				m.CheckerData = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			m.Severity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Severity |= Probe_Severity(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Timestamp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Timestamp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Timestamp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seconds", wireType)
			}
			m.Seconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seconds |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nanoseconds", wireType)
			}
			m.Nanoseconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Nanoseconds |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Event", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Event == nil {
				m.Event = &TimelineEvent{}
			}
			if err := m.Event.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimelineRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimelineRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimelineRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Params == nil {
				m.Params = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAgent
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAgent
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAgent
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAgent
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAgent(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAgent
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Params[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimelineResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimelineResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimelineResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &TimelineEvent{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimelineEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimelineEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimelineEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterHealthy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClusterHealthy{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_ClusterHealthy{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterDegraded", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClusterDegraded{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_ClusterDegraded{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterUpgrade", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClusterUpgrade{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_ClusterUpgrade{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeAdded", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NodeAdded{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_NodeAdded{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeRemoved", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NodeRemoved{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_NodeRemoved{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeHealthy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NodeHealthy{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_NodeHealthy{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeDegraded", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NodeDegraded{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_NodeDegraded{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProbeSucceeded", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ProbeSucceeded{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_ProbeSucceeded{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProbeFailed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ProbeFailed{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_ProbeFailed{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaderElected", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LeaderElected{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_LeaderElected{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnknownEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &UnknownEvent{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &TimelineEvent_UnknownEvent{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAgent(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAgent
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthAgent
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAgent(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthAgent
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAgent = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAgent   = fmt.Errorf("proto: integer overflow")
)
