/*
Copyright 2019 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import React from 'react'
import { storiesOf } from '@storybook/react'
import DialogConfirmation, { DialogHeader, DialogContent, DialogFooter, DialogTitle } from './index';
import { ButtonPrimary } from './../Button';

storiesOf('DialogConfirmation', module)
  .add('Simple DialogConfirmation', () => (
    <DialogConfirmation open={true} >
    <DialogHeader>
      <DialogTitle>
        Hello
      </DialogTitle>
    </DialogHeader>
    <DialogContent width="400px">
       DIALOG CONTENT AREA
    </DialogContent>
    <DialogFooter>
      <ButtonPrimary>
        Save And Close
      </ButtonPrimary>
    </DialogFooter>
  </DialogConfirmation>
  ));