/*
Copyright 2019 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import React from 'react';
import { storiesOf } from '@storybook/react';
import styled from 'styled-components'
import * as Icon from '../Icon';

storiesOf('Icon', module)
  .add('Icon components', () => (
    <Container>
      <IconBox IconCmpt={Icon.AddUsers} text="AddUsers"/>
      <IconBox IconCmpt={Icon.Amex} text="Amex"/>
      <IconBox IconCmpt={Icon.Apartment} text="Apartment"/>
      <IconBox IconCmpt={Icon.AppInstalled} text="AppInstalled"/>
      <IconBox IconCmpt={Icon.Apple} text="Apple"/>
      <IconBox IconCmpt={Icon.AppRollback} text="AppRollback"/>
      <IconBox IconCmpt={Icon.Archive} text="Archive"/>
      <IconBox IconCmpt={Icon.ArrowDown} text="ArrowDown"/>
      <IconBox IconCmpt={Icon.ArrowLeft} text="ArrowLeft"/>
      <IconBox IconCmpt={Icon.ArrowRight} text="ArrowRight"/>
      <IconBox IconCmpt={Icon.ArrowsVertical} text="ArrowsVertical"/>
      <IconBox IconCmpt={Icon.ArrowUp} text="ArrowUp"/>
      <IconBox IconCmpt={Icon.Bubble} text="Bubble"/>
      <IconBox IconCmpt={Icon.Calendar} text="Calendar"/>
      <IconBox IconCmpt={Icon.Camera} text="Camera"/>
      <IconBox IconCmpt={Icon.CardView} text="CardView"/>
      <IconBox IconCmpt={Icon.CardViewSmall} text="CardViewSmall"/>
      <IconBox IconCmpt={Icon.CaretLeft} text="CaretLeft"/>
      <IconBox IconCmpt={Icon.CaretRight} text="CaretRight"/>
      <IconBox IconCmpt={Icon.CarrotDown} text="CarrotDown"/>
      <IconBox IconCmpt={Icon.CarrotLeft} text="CarrotLeft"/>
      <IconBox IconCmpt={Icon.CarrotRight} text="CarrotRight"/>
      <IconBox IconCmpt={Icon.CarrotSort} text="CarrotSort"/>
      <IconBox IconCmpt={Icon.CarrotUp} text="CarrotUp"/>
      <IconBox IconCmpt={Icon.Cash} text="Cash"/>
      <IconBox IconCmpt={Icon.ChevronCircleDown} text="ChevronCircleDown"/>
      <IconBox IconCmpt={Icon.ChevronCircleLeft} text="ChevronCircleLeft"/>
      <IconBox IconCmpt={Icon.ChevronCircleRight} text="ChevronCircleRight"/>
      <IconBox IconCmpt={Icon.ChevronCircleUp} text="ChevronCircleUp"/>
      <IconBox IconCmpt={Icon.CircleArrowLeft} text="CircleArrowLeft"/>
      <IconBox IconCmpt={Icon.CircleArrowRight} text="CircleArrowRight"/>
      <IconBox IconCmpt={Icon.CircleCheck} text="CircleCheck"/>
      <IconBox IconCmpt={Icon.CircleCross} text="CircleCross"/>
      <IconBox IconCmpt={Icon.CirclePause} text="CirclePause"/>
      <IconBox IconCmpt={Icon.CirclePlay} text="CirclePlay"/>
      <IconBox IconCmpt={Icon.CircleStop} text="CircleStop"/>
      <IconBox IconCmpt={Icon.Cli} text="Cli"/>
      <IconBox IconCmpt={Icon.Clipboard} text="Clipboard"/>
      <IconBox IconCmpt={Icon.ClipboardUser} text="ClipboardUser"/>
      <IconBox IconCmpt={Icon.Close} text="Close"/>
      <IconBox IconCmpt={Icon.Cloud} text="Cloud"/>
      <IconBox IconCmpt={Icon.Cluster} text="Cluster"/>
      <IconBox IconCmpt={Icon.ClusterAdded} text="ClusterAdded"/>
      <IconBox IconCmpt={Icon.ClusterAuth} text="ClusterAuth"/>
      <IconBox IconCmpt={Icon.Code} text="Code"/>
      <IconBox IconCmpt={Icon.Cog} text="Cog"/>
      <IconBox IconCmpt={Icon.Config} text="Config"/>
      <IconBox IconCmpt={Icon.Contract} text="Contract"/>
      <IconBox IconCmpt={Icon.CreditCard} text="CreditCard"/>
      <IconBox IconCmpt={Icon.CreditCardAlt} text="CreditCardAlt"/>
      <IconBox IconCmpt={Icon.CreditCardAlt2} text="CreditCardAlt2"/>
      <IconBox IconCmpt={Icon.Cross} text="Cross"/>
      <IconBox IconCmpt={Icon.Database} text="Database"/>
      <IconBox IconCmpt={Icon.Discover} text="Discover"/>
      <IconBox IconCmpt={Icon.Download} text="Download"/>
      <IconBox IconCmpt={Icon.Earth} text="Earth"/>
      <IconBox IconCmpt={Icon.Edit} text="Edit"/>
      <IconBox IconCmpt={Icon.Ellipsis} text="Ellipsis"/>
      <IconBox IconCmpt={Icon.EmailSolid} text="EmailSolid"/>
      <IconBox IconCmpt={Icon.Equalizer} text="Equalizer"/>
      <IconBox IconCmpt={Icon.Expand} text="Expand"/>
      <IconBox IconCmpt={Icon.Facebook} text="Facebook"/>
      <IconBox IconCmpt={Icon.FacebookSquare} text="FacebookSquare"/>
      <IconBox IconCmpt={Icon.ForwarderAdded} text="ForwarderAdded"/>
      <IconBox IconCmpt={Icon.Github} text="Github"/>
      <IconBox IconCmpt={Icon.Google} text="Google"/>
      <IconBox IconCmpt={Icon.Graph} text="Graph"/>
      <IconBox IconCmpt={Icon.Home} text="Home"/>
      <IconBox IconCmpt={Icon.Keypair} text="Keypair"/>
      <IconBox IconCmpt={Icon.Label} text="Label"/>
      <IconBox IconCmpt={Icon.Lan} text="Lan"/>
      <IconBox IconCmpt={Icon.LanAlt} text="LanAlt"/>
      <IconBox IconCmpt={Icon.Layers} text="Layers"/>
      <IconBox IconCmpt={Icon.Layers1} text="Layers1"/>
      <IconBox IconCmpt={Icon.License} text="License"/>
      <IconBox IconCmpt={Icon.Link} text="Link"/>
      <IconBox IconCmpt={Icon.Linkedin} text="Linkedin"/>
      <IconBox IconCmpt={Icon.Linux} text="Linux"/>
      <IconBox IconCmpt={Icon.List} text="List"/>
      <IconBox IconCmpt={Icon.ListAddCheck} text="ListAddCheck"/>
      <IconBox IconCmpt={Icon.ListBullet} text="ListBullet"/>
      <IconBox IconCmpt={Icon.ListCheck} text="ListCheck"/>
      <IconBox IconCmpt={Icon.ListView} text="ListView"/>
      <IconBox IconCmpt={Icon.LocalPlay} text="LocalPlay"/>
      <IconBox IconCmpt={Icon.Lock} text="Lock"/>
      <IconBox IconCmpt={Icon.Magnifier} text="Magnifier"/>
      <IconBox IconCmpt={Icon.MapMarker} text="MapMarker"/>
      <IconBox IconCmpt={Icon.MasterCard} text="MasterCard"/>
      <IconBox IconCmpt={Icon.Memory} text="Memory" />
      <IconBox IconCmpt={Icon.MoreHoriz} text="MoreHoriz"/>
      <IconBox IconCmpt={Icon.MoreVert} text="MoreVert"/>
      <IconBox IconCmpt={Icon.Mute} text="Mute"/>
      <IconBox IconCmpt={Icon.NoteAdded} text="NoteAdded"/>
      <IconBox IconCmpt={Icon.NotificationsActive} text="NotificationsActive"/>
      <IconBox IconCmpt={Icon.Paypal} text="Paypal"/>
      <IconBox IconCmpt={Icon.Pencil} text="Pencil"/>
      <IconBox IconCmpt={Icon.Person} text="Person"/>
      <IconBox IconCmpt={Icon.PersonAdd} text="PersonAdd"/>
      <IconBox IconCmpt={Icon.Phone} text="Phone"/>
      <IconBox IconCmpt={Icon.PhonelinkErase} text="PhonelinkErase"/>
      <IconBox IconCmpt={Icon.PhonelinkSetup} text="PhonelinkSetup"/>
      <IconBox IconCmpt={Icon.Planet} text="Planet"/>
      <IconBox IconCmpt={Icon.Play} text="Play"/>
      <IconBox IconCmpt={Icon.Power} text="Power"/>
      <IconBox IconCmpt={Icon.Profile} text="Profile"/>
      <IconBox IconCmpt={Icon.Restore} text="Restore"/>
      <IconBox IconCmpt={Icon.Server} text="Server"/>
      <IconBox IconCmpt={Icon.SettingsInputComposite} text="SettingsInputComposite"/>
      <IconBox IconCmpt={Icon.SettingsOverscan} text="SettingsOverscan"/>
      <IconBox IconCmpt={Icon.Shart} text="Shart"/>
      <IconBox IconCmpt={Icon.ShieldCheck} text="ShieldCheck"/>
      <IconBox IconCmpt={Icon.Shrink} text="Shrink"/>
      <IconBox IconCmpt={Icon.Signal} text="Signal"/>
      <IconBox IconCmpt={Icon.SmallArrowDown} text="SmallArrowDown"/>
      <IconBox IconCmpt={Icon.SmallArrowUp} text="SmallArrowUp"/>
      <IconBox IconCmpt={Icon.SmartPhone} text="SmartPhone"/>
      <IconBox IconCmpt={Icon.Sort} text="Sort"/>
      <IconBox IconCmpt={Icon.SortAsc} text="SortAsc"/>
      <IconBox IconCmpt={Icon.SortDesc} text="SortDesc"/>
      <IconBox IconCmpt={Icon.Speed} text="Speed"/>
      <IconBox IconCmpt={Icon.Spinner} text="Spinner"/>
      <IconBox IconCmpt={Icon.Stars} text="Stars"/>
      <IconBox IconCmpt={Icon.Stripe} text="Stripe"/>
      <IconBox IconCmpt={Icon.Tablet} text="Tablet"/>
      <IconBox IconCmpt={Icon.Trash} text="Trash"/>
      <IconBox IconCmpt={Icon.Twitter} text="Twitter"/>
      <IconBox IconCmpt={Icon.Unarchive} text="Unarchive" />
      <IconBox IconCmpt={Icon.Unlock} text="Unlock"/>
      <IconBox IconCmpt={Icon.Upload} text="Upload"/>
      <IconBox IconCmpt={Icon.User} text="User"/>
      <IconBox IconCmpt={Icon.UserCreated} text="UserCreated"/>
      <IconBox IconCmpt={Icon.Users} text="Users"/>
      <IconBox IconCmpt={Icon.VideoGame} text="VideoGame"/>
      <IconBox IconCmpt={Icon.Visa} text="Visa"/>
      <IconBox IconCmpt={Icon.VolumeUp} text="VolumeUp"/>
      <IconBox IconCmpt={Icon.VpnKey} text="VpnKey"/>
      <IconBox IconCmpt={Icon.Warning} text="Warning"/>
      <IconBox IconCmpt={Icon.Wifi} text="Wifi"/>
      <IconBox IconCmpt={Icon.Window} text="Window"/>
      <IconBox IconCmpt={Icon.Windows} text="Windows"/>
      <IconBox IconCmpt={Icon.Youtube} text="Youtube"/>
      <IconBox IconCmpt={Icon.Kubernetes} text="Kubernetes"/>

    </Container>
  ));

const Container = styled.div`
  font-size: 24px;
  display: flex;
  flex-direction: row;
  flex-wrap: wrap;
`

const IconBox = ({IconCmpt, text}) => (
  <Box>
    <IconCmpt/>
    {text}
  </Box>
)


const Box = styled.div`
  display: flex;
  margin: 10px 10px;
  width: 300px;
  font-size: 14px;

  .icon {
    display: inline-block;
    margin: 0 10px;
    font-size: 16px;
  }
`