function OnInit( )
  global.gt = {
    organic_trees = { },
    grass_trees = { },
    dirt_trees = { },
    desert_trees = { },
    sand_trees = { },
    nuclear_trees = { },
    dead_trees = { },
    random = game.create_random_generator( ),
  }
  InitBiomeTrees( )
end

function OnLoad( )
end

function InitBiomeTrees( )
  OrganicBiomeTrees( )
  GrassBiomeTrees( )
  DirtBiomeTrees( )
  DesertBiomeTrees( )
  SandBiomeTrees( )
  NuclearBiomeTrees( )
  DeadBiomeTrees( )
end

function BiomeTiles( name )
  local biome = {
    [ "landfill" ] = "dirt",
    [ "grass-1" ] = "grass",
    [ "grass-2" ] = "grass",
    [ "grass-3" ] = "grass",
    [ "grass-4" ] = "grass",
    [ "absorbtion-bricks" ] = "organic",
    [ "organic-concrete" ] = "organic",
    [ "refined-organic-concrete" ] = "organic",
    [ "dry-dirt" ] = "desert",
    [ "dirt-1" ] = "desert",
    [ "dirt-2" ] = "desert",
    [ "dirt-3" ] = "desert",
    [ "dirt-4" ] = "desert",
    [ "dirt-5" ] = "dirt",
    [ "dirt-6" ] = "dirt",
    [ "dirt-7" ] = "dirt",
    [ "red-desert-0" ] = "desert",
    [ "red-desert-1" ] = "desert",
    [ "red-desert-2" ] = "desert",
    [ "red-desert-3" ] = "desert",
    [ "sand-1" ] = "sand",
    [ "sand-2" ] = "sand",
    [ "sand-3" ] = "sand",
    [ "nuclear-ground" ] = "nuclear",
  }
  if biome[ name ]
    then
    return biome[ name ]
  else
    return false
  end
end

function OrganicBiomeTrees( )
  if #global.gt.organic_trees == 0
    then
    local trees = {
      [ "tree-01" ] = true,
      [ "tree-02" ] = false,
      [ "tree-02-red" ] = false,
      [ "tree-03" ] = false,
      [ "tree-04" ] = false,
      [ "tree-05" ] = false,
      [ "tree-06" ] = false,
      [ "tree-06-brown" ] = false,
      [ "tree-07" ] = false,
      [ "tree-08" ] = false,
      [ "tree-08-brown" ] = false,
      [ "tree-08-red" ] = false,
      [ "tree-09" ] = false,
      [ "tree-09-brown" ] = false,
      [ "dry-tree" ] = false,
      [ "dead-tree-desert" ] = false,
      [ "dead-grey-trunk" ] = false,
      [ "dead-dry-hairy-tree" ] = false,
      [ "dry-hairy-tree" ] = false,
    }
    for _, tree in pairs( game.entity_prototypes ) do
      if tree.type == "tree"
        then
        if trees[ tree.name ]
          then
          table.insert( global.gt.organic_trees, tree.name )
        end
      end
    end
  end
end

function GrassBiomeTrees( )
  if #global.gt.grass_trees == 0
    then
    local trees = {
      [ "tree-01" ] = true,
      [ "tree-02" ] = true,
      [ "tree-02-red" ] = false,
      [ "tree-03" ] = false,
      [ "tree-04" ] = false,
      [ "tree-05" ] = false,
      [ "tree-06" ] = false,
      [ "tree-06-brown" ] = false,
      [ "tree-07" ] = false,
      [ "tree-08" ] = false,
      [ "tree-08-brown" ] = false,
      [ "tree-08-red" ] = false,
      [ "tree-09" ] = false,
      [ "tree-09-brown" ] = false,
      [ "dry-tree" ] = false,
      [ "dead-tree-desert" ] = false,
      [ "dead-grey-trunk" ] = false,
      [ "dead-dry-hairy-tree" ] = false,
      [ "dry-hairy-tree" ] = false,
    }
    for _, tree in pairs( game.entity_prototypes ) do
      if tree.type == "tree"
        then
        if trees[ tree.name ]
          then
          table.insert( global.gt.grass_trees, tree.name )
        end
      end
    end
  end
end

function DirtBiomeTrees( )
  if #global.gt.dirt_trees == 0
    then
    local trees = {
      [ "tree-01" ] = false,
      [ "tree-02" ] = false,
      [ "tree-02-red" ] = false,
      [ "tree-03" ] = true,
      [ "tree-04" ] = true,
      [ "tree-05" ] = false,
      [ "tree-06" ] = false,
      [ "tree-06-brown" ] = false,
      [ "tree-07" ] = false,
      [ "tree-08" ] = false,
      [ "tree-08-brown" ] = false,
      [ "tree-08-red" ] = false,
      [ "tree-09" ] = false,
      [ "tree-09-brown" ] = false,
      [ "dry-tree" ] = false,
      [ "dead-tree-desert" ] = false,
      [ "dead-grey-trunk" ] = false,
      [ "dead-dry-hairy-tree" ] = false,
      [ "dry-hairy-tree" ] = false,
    }
    for _, tree in pairs( game.entity_prototypes ) do
      if tree.type == "tree"
        then
        if trees[ tree.name ]
          then
          table.insert( global.gt.dirt_trees, tree.name )
        end
      end
    end
  end
end

function DesertBiomeTrees( )
  if #global.gt.desert_trees == 0
    then
    local trees = {
      [ "tree-01" ] = false,
      [ "tree-02" ] = false,
      [ "tree-02-red" ] = false,
      [ "tree-03" ] = false,
      [ "tree-04" ] = false,
      [ "tree-05" ] = false,
      [ "tree-06" ] = false,
      [ "tree-06-brown" ] = false,
      [ "tree-07" ] = true,
      [ "tree-08" ] = true,
      [ "tree-08-brown" ] = false,
      [ "tree-08-red" ] = false,
      [ "tree-09" ] = true,
      [ "tree-09-brown" ] = false,
      [ "dry-tree" ] = false,
      [ "dead-tree-desert" ] = false,
      [ "dead-grey-trunk" ] = false,
      [ "dead-dry-hairy-tree" ] = false,
      [ "dry-hairy-tree" ] = false,
    }
    for _, tree in pairs( game.entity_prototypes ) do
      if tree.type == "tree"
        then
        if trees[ tree.name ]
          then
          table.insert( global.gt.desert_trees, tree.name )
        end
      end
    end
  end
end

function SandBiomeTrees( )
  if #global.gt.sand_trees == 0
    then
    local trees = {
      [ "tree-01" ] = false,
      [ "tree-02" ] = false,
      [ "tree-02-red" ] = true,
      [ "tree-03" ] = false,
      [ "tree-04" ] = false,
      [ "tree-05" ] = true,
      [ "tree-06" ] = false,
      [ "tree-06-brown" ] = false,
      [ "tree-07" ] = false,
      [ "tree-08" ] = false,
      [ "tree-08-brown" ] = true,
      [ "tree-08-red" ] = true,
      [ "tree-09" ] = false,
      [ "tree-09-brown" ] = true,
      [ "dry-tree" ] = false,
      [ "dead-tree-desert" ] = false,
      [ "dead-grey-trunk" ] = false,
      [ "dead-dry-hairy-tree" ] = false,
      [ "dry-hairy-tree" ] = false,
    }
    for _, tree in pairs( game.entity_prototypes ) do
      if tree.type == "tree"
        then
        if trees[ tree.name ]
          then
          table.insert( global.gt.sand_trees, tree.name )
        end
      end
    end
  end
end

function NuclearBiomeTrees( )
  if #global.gt.nuclear_trees == 0
    then
    local trees = {
      [ "tree-01" ] = false,
      [ "tree-02" ] = false,
      [ "tree-02-red" ] = false,
      [ "tree-03" ] = false,
      [ "tree-04" ] = false,
      [ "tree-05" ] = false,
      [ "tree-06" ] = true,
      [ "tree-06-brown" ] = true,
      [ "tree-07" ] = false,
      [ "tree-08" ] = false,
      [ "tree-08-brown" ] = false,
      [ "tree-08-red" ] = false,
      [ "tree-09" ] = false,
      [ "tree-09-brown" ] = false,
      [ "dry-tree" ] = false,
      [ "dead-tree-desert" ] = false,
      [ "dead-grey-trunk" ] = false,
      [ "dead-dry-hairy-tree" ] = false,
      [ "dry-hairy-tree" ] = false,
    }
    for _, tree in pairs( game.entity_prototypes ) do
      if tree.type == "tree"
        then
        if trees[ tree.name ]
          then
          table.insert( global.gt.nuclear_trees, tree.name )
        end
      end
    end
  end
end

function DeadBiomeTrees( )
  if #global.gt.dead_trees == 0
    then
    local trees = {
      [ "tree-01" ] = false,
      [ "tree-02" ] = false,
      [ "tree-02-red" ] = false,
      [ "tree-03" ] = false,
      [ "tree-04" ] = false,
      [ "tree-05" ] = false,
      [ "tree-06" ] = false,
      [ "tree-06-brown" ] = false,
      [ "tree-07" ] = false,
      [ "tree-08" ] = false,
      [ "tree-08-brown" ] = false,
      [ "tree-08-red" ] = false,
      [ "tree-09" ] = false,
      [ "tree-09-brown" ] = false,
      [ "dry-tree" ] = true,
      [ "dead-tree-desert" ] = true,
      [ "dead-grey-trunk" ] = true,
      [ "dead-dry-hairy-tree" ] = true,
      [ "dry-hairy-tree" ] = true,
    }
    for _, tree in pairs( game.entity_prototypes ) do
      if tree.type == "tree" then
        if trees[ tree.name ]
          then
          table.insert( global.gt.dead_trees, tree.name )
        end
      end
    end
  end
end

function GetRandomTree( biome )
  if biome == "grass"
    then
    return global.gt.grass_trees[ global.gt.random( 1, #global.gt.grass_trees )]
  elseif biome == "dirt"
    then
    return global.gt.dirt_trees[ global.gt.random( 1, #global.gt.dirt_trees )]
  elseif biome == "desert"
    then
    return global.gt.desert_trees[ global.gt.random( 1, #global.gt.desert_trees )]
  elseif biome == "sand"
    then
    return global.gt.sand_trees[ global.gt.random( 1, #global.gt.sand_trees )]
  elseif biome == "nuclear"
    then
    return global.gt.nuclear_trees[ global.gt.random( 1, #global.gt.nuclear_trees )]
  elseif biome == "dead"
    then
    return global.gt.dead_trees[ global.gt.random( 1, #global.gt.dead_trees )]
  elseif biome == "organic"
    then
    return global.gt.organic_trees[ global.gt.random( 1, #global.gt.organic_trees )]
  end
end

function GrassType( tile )
  local grass_type = settings.global[ "grass_type" ].value
  local grass = { }
  local x = tile.position.x + 0.5
  local y = tile.position.y + 0.5
  if grass_type == "grass"
    then
    grass = {
      {
        name = "green-carpet-grass",
        position = { x, y },
        amount = 4
      }
    }
  elseif grass_type == "pita"
    then
    grass = {
      {
        name = "green-pita",
        position = { x, y },
        amount = 4
      },
      {
        name = "green-pita-mini",
        position = { x, y },
        amount = 4
      },
    }
  else
    grass = {
      {
        name = "green-carpet-grass",
        position = { x, y },
        amount = 2
      },
      {
        name = "green-pita",
        position = { x, y },
        amount = 4
      },
      {
        name = "green-pita-mini",
        position = { x, y },
        amount = 4
      },
    }
  end
  
  return grass
end

function PlayerBuiltTile( event )
  PlaceTileGrass( event.tiles, game.players[ event.player_index ].surface )
end

function RobotBuiltTile( event )
  PlaceTileGrass( event.tiles, event.robot.surface )
end

function PlaceTileGrass( tiles, surface )
  for _, oldtile in ipairs( tiles ) do
    local position = oldtile.position
    local x = position.x
    local y = position.y
    local currentTilename = surface.get_tile( x, y ).name
    if currentTilename == "absorbtion-bricks"
      or currentTilename == "organic-concrete"
      or currentTilename == "hazard-organic-concrete-left"
      or currentTilename == "hazard-organic-concrete-right"
      or currentTilename == "refined-organic-concrete"
      or currentTilename == "refined-hazard-organic-concrete-left"
      or currentTilename == "refined-hazard-organic-concrete-right"
      then
      if settings.global[ "set_hidden_grass_tile" ].value == true
        then
        surface.set_hidden_tile( position, "grass-1" )
      end
      if settings.global[ "grass_in_organic_tile" ].value == true
        then
        surface.create_decoratives({ check_collision = false, decoratives = GrassType( oldtile )})
      end
    end
  end
end

function PlaceGrass( event )
  local player = game.players[ event.player_index ]
  local grass_tiles = {
    "absorbtion-bricks",
    "organic-concrete",
    "refined-organic-concrete"
  }
  local tiles = player.surface.find_tiles_filtered{ name = grass_tiles }
  for _, tile in ipairs( tiles ) do
    player.surface.create_decoratives{ check_collision = false, decoratives = GrassType( tile )}
  end
end

function DeleteGrass( event )
  local player = game.players[ event.player_index ]
  local clean_grass_tiles = {
    "absorbtion-bricks",
    "organic-concrete",
    "refined-organic-concrete",
    "hazard-organic-concrete-left",
    "hazard-organic-concrete-right",
    "refined-hazard-organic-concrete-left",
    "refined-hazard-organic-concrete-right",
    "hazard-concrete-left",
    "hazard-concrete-right",
    "refined-hazard-concrete-left",
    "refined-hazard-concrete-right",
    "underground-electric-tile"
  }
  local tiles = player.surface.find_tiles_filtered{ name = clean_grass_tiles }
  for i, tile in ipairs( tiles ) do
    local area = { left_top = { tile.position.x, tile.position.y }, right_bottom = { tile.position.x + 1, tile.position.y + 1 }}
    player.surface.destroy_decoratives{ area = area }
  end
end

local function OnSelectedArea( event )
  local player = game.players[ event.player_index ]
  local surface = player.surface
  
  if event.item == "garden-tools"
    then
    local entity_names = {
      "dry-tree",
      "dead-tree-desert",
      "dead-grey-trunk",
      "dead-dry-hairy-tree",
      "dry-hairy-tree",
      "tree-06",
      "tree-06-brown",
      "rock-big",
      "sand-rock-big",
      "rock-huge",
      "item-on-ground",
    }
    local tile_names = {
      "absorbtion-bricks",
      "organic-concrete",
      "refined-organic-concrete",
      "hazard-organic-concrete-left",
      "hazard-organic-concrete-right",
      "refined-hazard-organic-concrete-left",
      "refined-hazard-organic-concrete-right",
      "hazard-concrete-left",
      "hazard-concrete-right",
      "refined-hazard-concrete-left",
      "refined-hazard-concrete-right"
    }
    local enemy_decal_names = {
      "shroom-decal",
      "lichen-decal",
      "enemy-decal",
      "enemy-decal-transparent",
      "worms-decal",
      "dark-mud-decal",
    }
    local corpses = surface.find_entities_filtered{ area = event.area, type = "corpse" }
    for _, corpse in pairs( corpses ) do
      corpse.destroy( )
    end
    surface.destroy_decoratives{ area = event.area, name = enemy_decal_names }
    local entities = surface.find_entities_filtered{ area = event.area, type = { "tree", "simple-entity", "item-entity" }, name = entity_names }
    for _, entity in pairs( entities ) do
      player.mine_entity( entity, player.force )
    end
    for _, tree in pairs( surface.find_entities_filtered{ area = event.area, type = "tree" }) do
      if tree.tree_stage_index == 4 then
        player.mine_entity( tree, player.force )
      end
    end
  else
    if event.item == "resource-tools"
      then
      local entity_names = {
        "iron-ore",
        "copper-ore",
        "coal",
        "stone",
      }
      local entities = surface.find_entities_filtered{ area = event.area, type = { "resource" }, name = entity_names }
      for _, entity in pairs( entities ) do
        if entity.name == "iron-ore"
          then
          CreateWaterOre( entity, "iron-water-ore" )
        elseif entity.name == "copper-ore"
          then
          CreateWaterOre( entity, "copper-water-ore" )
        elseif entity.name == "stone"
          then
          CreateWaterOre( entity, "stone-water-ore" )
        elseif entity.name == "coal"
          then
          CreateWaterOre( entity, "coal-water-ore" )
        end
      end
    end
  end
end

function CreateWaterOre( entity, name )
  local ore = entity.surface.create_entity({ name = name, position = entity.position, amount = entity.amount })
  ore.graphics_variation = entity.graphics_variation
  rendering.draw_sprite {
    sprite = "fluid/water",
    surface = entity.surface,
    target = ore,
    render_layer = 68,
    x_scale = 0.4, y_scale = 0.4
  }
  entity.destroy( )
end

function DeleteWaterOre( entity, name )
  local ore = entity.surface.create_entity({ name = name, position = entity.position, amount = entity.amount })
  ore.graphics_variation = entity.graphics_variation
  entity.destroy( )
end

function OnAltSelectedArea( event )
  local surface = game.players[ event.player_index ].surface
  if event.item == "garden-tools"
    then
    surface.destroy_decoratives({ area = event.area })
  else
    if event.item == "resource-tools"
      then
      local entity_names = {
        "iron-water-ore",
        "copper-water-ore",
        "stone-water-ore",
        "coal-water-ore",
      }
      local entities = surface.find_entities_filtered{ area = event.area, type = { "resource" }, name = entity_names }
      for _, entity in pairs( entities ) do
        if entity.name == "iron-water-ore"
          then
          DeleteWaterOre( entity, "iron-ore" )
        elseif entity.name == "copper-water-ore"
          then
          DeleteWaterOre( entity, "copper-ore" )
        elseif entity.name == "stone-water-ore"
          then
          DeleteWaterOre( entity, "stone" )
        elseif entity.name == "coal-water-ore"
          then
          DeleteWaterOre( entity, "coal" )
        end
      end
    end
  end
end

function TriggerCreatedEntity( event )
  local entity = event.entity
  local surface = entity.surface
  local position = entity.position
  local chunks = {{ math.floor( position.x / 32 ), math.floor( position.y / 32 )}}
  local radius = 0
  local evolution = 0
  if entity.name == "fertiliser-cloud"
    then
    local pollution = -100
    Terraformer( position, chunks, pollution, surface, 5 )
  elseif entity.name == "advanced-fertiliser-cloud"
    then
    local pollution = -200
    Terraformer( position, chunks, pollution, surface, 25 )
  elseif entity.name == "t-virus-cloud"
    then
    evolution = 0.0002
    radius = 8
    CreateInfection( surface, position, radius, evolution )
  elseif entity.name == "virus-artillery-cloud"
    then
    evolution = 0.002
    radius = 32
    CreateInfection( surface, position, radius, evolution )
  end
end

function Terraformer( position, chunks, pollution, surface, chance )
  local grass_tiles = {
    "absorbtion-bricks",
    "organic-concrete",
    "refined-organic-concrete"
  }
  local tile_names = {
    "landfill",
    "grass-2",
    "grass-3",
    "grass-4",
    "dry-dirt",
    "dirt-1",
    "dirt-2",
    "dirt-3",
    "dirt-4",
    "dirt-5",
    "dirt-6",
    "dirt-7",
    "red-desert-0",
    "red-desert-1",
    "red-desert-2",
    "red-desert-3",
    "sand-1",
    "sand-2",
    "sand-3",
    "nuclear-ground",
  }
  local terraformation = {
    [ "landfill" ] = "dry-dirt",
    [ "grass-2" ] = "grass-1",
    [ "grass-3" ] = "grass-2",
    [ "grass-4" ] = "grass-3",
    [ "dry-dirt" ] = "dirt-1",
    [ "dirt-1" ] = "dirt-2",
    [ "dirt-2" ] = "dirt-3",
    [ "dirt-3" ] = "dirt-4",
    [ "dirt-4" ] = "dirt-5",
    [ "dirt-5" ] = "dirt-6",
    [ "dirt-6" ] = "dirt-7",
    [ "dirt-7" ] = "grass-4",
    [ "red-desert-0" ] = "dry-dirt",
    [ "red-desert-1" ] = "dry-dirt",
    [ "red-desert-2" ] = "dry-dirt",
    [ "red-desert-3" ] = "dry-dirt",
    [ "sand-1" ] = "dry-dirt",
    [ "sand-2" ] = "dry-dirt",
    [ "sand-3" ] = "dry-dirt",
    [ "nuclear-ground" ] = "sand-1",
  }
  local tiles = surface.find_tiles_filtered{ position = position, radius = 16, name = tile_names }
  for i, tile in pairs ( tiles ) do
    if math.random( 0, 100 ) < chance
      then
      surface.destroy_decoratives({ position = tile.position })
      surface.set_tiles({{ name = terraformation[ tile.name ], position = tile.position }})
      rendering.draw_sprite {
        sprite = "fluid/steam",
        surface = surface,
        target = { tile.position.x + 0.5, tile.position.y + 0.5 },
        render_layer = 140,
        tint = { r = 0.2, g = 0.8, b = 0.2, a = 0.4 },
        time_to_live = 300,
        x_scale = 0.8, y_scale = 0.8
      }
    end
  end
  for _, tree in pairs( surface.find_entities_filtered{ position = position, radius = 16, type = "tree" }) do
    if tree.tree_stage_index > 1
      then
      tree.tree_stage_index = math.ceil( tree.tree_stage_index / 2 )
      rendering.draw_sprite {
        sprite = "item/seedling",
        surface = surface,
        target_offset = { 0.5, 2.5 },
        target = tree.position,
        render_layer = 140,
        tint = { r = 0.2, g = 0.8, b = 0.2, a = 0.4 },
        time_to_live = 300,
        x_scale = 0.8, y_scale = 0.8
      }
    end
  end
  for _, seedling in pairs( surface.find_entities_filtered{ position = position, radius = 16, name = "seedling" }) do
    local biome = BiomeTiles( surface.get_tile( seedling.position ).name )
    if biome
      then
      tree = surface.create_entity({ name = GetRandomTree( biome ), position = seedling.position })
      if tree.tree_color_index_max ~= 0
        then
        tree.tree_color_index = math.random( 1, tree.tree_color_index_max )
        seedling.destroy( )
      end
    else
      surface.create_entity({ name = GetRandomTree( "dead" ), position = seedling.position })
      seedling.destroy( )
    end
  end
  local organic_tiles = surface.find_tiles_filtered{ position = position, radius = 16, name = grass_tiles }
  for i, organic_tile in ipairs( organic_tiles ) do
    surface.create_decoratives{ check_collision = true, decoratives = GrassType( organic_tile )}
  end
  surface.pollute( position, pollution )
  surface.regenerate_decorative( nil, chunks )
end

function CreateInfection( surface, position, radius, evolution )
  
  local virus_name = "t-virus"
  
  if not game.forces[ virus_name ]
    then game.create_force( virus_name )
  end
  
  local enemies = surface.find_entities_filtered { position = position, radius = radius, force = { "enemy" }, type = "unit" }
  
  local count = 0
  for i, enemy in pairs ( enemies ) do
    if enemy.health ~= nil and enemy.can_be_destroyed( )
      then
      enemy.force = virus_name
      rendering.draw_circle{
        color = { r = 0.2, g = 0.8, b = 0.2, a = 0.4 },
        filled = true,
        radius = 0.2,
        surface = surface,
        target = enemy
      }
      count = count + 1
    end
  end
  
  evolution = evolution * count
  enemy_evolution_factor = game.forces.enemy.evolution_factor - ( game.forces.enemy.evolution_factor * evolution )
  game.forces.enemy.evolution_factor = enemy_evolution_factor
  
end

function SpreadOfInfection( event )
  local entity = event.entity
  local surface = entity.surface
  local position = entity.position
  local radius = 8
  local evolution = 0.0002
  if entity.force.name == "t-virus"
    then
    surface.create_entity{ name = "t-virus-cloud", position = position }
    surface.create_entity{ name = "t-virus-poison-cloud", position = position }
    CreateInfection( surface, position, radius, evolution )
  end
end

script.on_load( OnLoad )
script.on_init( OnInit )
script.on_event( defines.events.on_player_built_tile, PlayerBuiltTile )
script.on_event( defines.events.on_robot_built_tile, RobotBuiltTile )
script.on_event( defines.events.on_player_selected_area, OnSelectedArea )
script.on_event( defines.events.on_player_alt_selected_area, OnAltSelectedArea )
script.on_event( defines.events.on_trigger_created_entity, TriggerCreatedEntity )
script.on_event( defines.events.on_entity_died, SpreadOfInfection, {{ filter = "type", type = "unit" }})

script.on_event( "place-grass", PlaceGrass )
script.on_event( "delete-grass", DeleteGrass )

