if mods[ "deadlock-beltboxes-loaders" ] then
  local icons = "__GreenTec__/graphics/icons/";
  local deadlock_stack_size = settings.startup[ "deadlock-stack-size" ].value
  local item_types = {
    "item",
    "ammo",
    "gun",
    "tool",
    "repair-tool",
    "module",
    "item-with-label",
    "item-with-tags",
    "capsule"
  }
  
  deadlock.add_stack( "seedling", icons.."stacked-seedling.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "ash", icons.."stacked-ash.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "woodpulp", icons.."stacked-woodpulp.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "cellulose", icons.."stacked-cellulose.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "gt-fertiliser", icons.."stacked-fertiliser.png", "deadlock-stacking-1", 64, "capsule", 4 )
  deadlock.add_stack( "advanced-fertiliser", icons.."stacked-advanced-fertiliser.png", "deadlock-stacking-1", 64, "capsule", 4 )
  deadlock.add_stack( "absorbtion-brick", icons.."stacked-absorbtion-brick.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "organic-concrete", icons.."stacked-organic-concrete.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "refined-organic-concrete", icons.."stacked-refined-organic-concrete.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "flux", icons.."stacked-flux.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "fluxed-iron-ore", icons.."stacked-fluxed-iron-ore.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "fluxed-copper-ore", icons.."stacked-fluxed-copper-ore.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "fluxed-iron", icons.."stacked-fluxed-iron.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "purified-fuel", icons.."stacked-purified-fuel.png", "deadlock-stacking-1", 64, "item", 4 )
  deadlock.add_stack( "bio-fuel", icons.."stacked-bio-fuel.png", "deadlock-stacking-1", 64, "item", 4 )
  
  for k, v in pairs( data.raw.item ) do
    if string.match( k, "deadlock%-stack%-" ) then
      local parent_item = string.sub( k, 16 )
      for _, item_type in ipairs( item_types ) do
        if data.raw[ item_type ][ parent_item ] then
          data.raw.item[ k ].stack_size = math.floor( data.raw[ item_type ][ parent_item ].stack_size )
          if data.raw[ item_type ][ parent_item ].fuel_value then
            data.raw.item[ k ].fuel_category = data.raw[ item_type ][ parent_item ].fuel_category
            data.raw.item[ k ].fuel_acceleration_multiplier = data.raw[ item_type ][ parent_item ].fuel_acceleration_multiplier
            data.raw.item[ k ].fuel_top_speed_multiplier = data.raw[ item_type ][ parent_item ].fuel_top_speed_multiplier
            data.raw.item[ k ].fuel_emissions_multiplier = data.raw[ item_type ][ parent_item ].fuel_emissions_multiplier
            data.raw.item[ k ].fuel_value = ( tonumber( string.match( data.raw[ item_type ][ parent_item ].fuel_value, "%d+" )) * deadlock_stack_size ) .. string.match( data.raw[ item_type ][ parent_item ].fuel_value, "%a+" )
          end
        end
      end
    end
  end
end
