local icons = "__GreenTec__/graphics/icons/";
local entities = "__GreenTec__/graphics/entities/";
local sounds = "__GreenTec__/sounds/";

data:extend({
  {
    name = "t-virus-poison-cloud",
    type = "smoke-with-trigger",
    flags = { "not-on-map" },
    show_when_smoke_off = true,
    particle_count = 1,
    particle_spread = { 1.5, 1.5 },
    particle_distance_scale_factor = 0.5,
    particle_scale_factor = { 0.5, 0.5 },
    wave_speed = { 1 / 60, 1 / 60 },
    wave_distance = { 0.5, 0.5 },
    spread_duration_variation = 20,
    particle_duration_variation = 60 * 3,
    render_layer = "object",
    affected_by_wind = true,
    cyclic = true,
    duration = 60 * 20,
    fade_away_duration = 2 * 60,
    spread_duration = 20,
    color = { r = 0.2, g = 0.8, b = 0.2, a = 0.4 },
    animation =
    {
      width = 152,
      height = 120,
      line_length = 5,
      frame_count = 60,
      shift = { -0.53125, -0.4375 },
      priority = "high",
      animation_speed = 0.25,
      filename = "__base__/graphics/entity/smoke/smoke.png",
      flags = { "smoke" }
    },
    created_effect =
    {
      {
        type = "cluster",
        cluster_count = 2,
        distance = 2,
        distance_deviation = 2,
        action_delivery =
        {
          type = "instant",
          target_effects =
          {
            {
              type = "create-smoke",
              show_in_tooltip = false,
              entity_name = "poison-cloud-visual-dummy",
              initial_height = 0
            }
          }
        }
      }
    },
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          type = "nested-result",
          action =
          {
            type = "area",
            radius = 2,
            entity_flags = { "placeable-enemy" },
            action_delivery =
            {
              type = "instant",
              target_effects =
              {
                type = "damage",
                damage = { amount = 10, type = "acid" }
              }
            }
          }
        }
      }
    },
    action_cooldown = 30
  },
  --
  {
    type = "smoke-with-trigger",
    name = "t-virus-cloud",
    flags = { "not-on-map" },
    show_when_smoke_off = false,
    animation =
    {
      width = 152,
      height = 120,
      line_length = 5,
      frame_count = 60,
      axially_symmetrical = false,
      direction_count = 1,
      priority = "high",
      flags = { "smoke" },
      animation_speed = 1,
      scale = 4,
      filename = "__base__/graphics/entity/smoke/smoke.png"
    },
    affected_by_wind = true,
    cyclic = true,
    duration = 300,
    fade_away_duration = 300,
    spread_duration = 60,
    color = { r = 0.2, g = 0.8, b = 0.2, a = 0.4 },
    action =
    {
      type = "area",
      radius = 8,
      force = "enemy",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          type = "create-sticker",
          sticker = "virus-sticker"
        }
      }
    },
    action_cooldown = 60
  },
  {
    type = "projectile",
    name = "t-virus-wave",
    flags = { "not-on-map" },
    acceleration = 0,
    action =
    {
      {
        type = "direct",
        action_delivery =
        {
          type = "instant",
          target_effects =
          {
            {
              type = "create-entity",
              trigger_created_entity = true,
              entity_name = "t-virus-cloud"
            },
            {
              type = "create-sticker",
              sticker = "virus-sticker"
            }
          }
        }
      },
    },
    animation =
    {
      filename = "__core__/graphics/empty.png",
      frame_count = 1,
      width = 1,
      height = 1,
      priority = "high"
    },
    shadow =
    {
      filename = "__core__/graphics/empty.png",
      frame_count = 1,
      width = 1,
      height = 1,
      priority = "high"
    }
  },
  --
  {
    type = "sticker",
    name = "virus-sticker",
    flags = { },
    duration_in_ticks = 300 * 60,
    target_movement_modifier = 2,
    stickers_per_square_meter = 48
  },
  --
  {
    type = "projectile",
    name = "virus-rocket",
    flags = { "not-on-map" },
    acceleration = 0.002,
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "nested-result",
            action =
            {
              type = "area",
              target_entities = false,
              trigger_from_target = true,
              repeat_count = 32,
              radius = 16,
              action_delivery =
              {
                type = "projectile",
                projectile = "t-virus-wave",
                starting_speed = 0.2
              }
            }
          }
        }
      }
    },
    light = { intensity = 0.8, size = 15 },
    animation =
    {
      filename = "__base__/graphics/entity/rocket/rocket.png",
      frame_count = 8,
      line_length = 8,
      width = 9,
      height = 35,
      shift = { 0, 0 },
      priority = "high"
    },
    shadow =
    {
      filename = "__base__/graphics/entity/rocket/rocket-shadow.png",
      frame_count = 1,
      width = 7,
      height = 24,
      priority = "high",
      shift = { 0, 0 }
    },
    smoke =
    {
      {
        name = "smoke-fast",
        deviation = { 0.15, 0.15 },
        frequency = 1,
        position = { 0, 1 },
        slow_down_factor = 1,
        starting_frame = 3,
        starting_frame_deviation = 5,
        starting_frame_speed = 0,
        starting_frame_speed_deviation = 5
      }
    }
  },
  --
  {
    type = "smoke-with-trigger",
    name = "virus-artillery-cloud",
    flags = { "not-on-map" },
    show_when_smoke_off = false,
    animation =
    {
      width = 152,
      height = 120,
      line_length = 5,
      frame_count = 60,
      axially_symmetrical = false,
      direction_count = 1,
      priority = "high",
      flags = { "smoke" },
      animation_speed = 0.5,
      scale = 4,
      filename = "__base__/graphics/entity/smoke/smoke.png"
    },
    affected_by_wind = true,
    cyclic = false,
    duration = 600,
    fade_away_duration = 300,
    spread_duration = 300,
    color = { r = 0.2, g = 0.8, b = 0.2, a = 0.4 },
    action_cooldown = 60
  },
  --
  {
    type = "artillery-projectile",
    name = "virus-artillery-projectile",
    flags = { "not-on-map" },
    acceleration = 0,
    direction_only = true,
    reveal_map = true,
    map_color = { r = 0, g = 1, b = 0 },
    picture =
    {
      filename = entities.."artillery-projectile/hr-shell.png",
      width = 64,
      height = 64,
      scale = 0.5
    },
    shadow =
    {
      filename = entities.."artillery-projectile/hr-shell-shadow.png",
      width = 64,
      height = 64,
      scale = 0.5
    },
    chart_picture =
    {
      filename = entities.."artillery-projectile/artillery-shoot-map-visualization.png",
      flags = { "icon" },
      frame_count = 1,
      width = 64,
      height = 64,
      priority = "high",
      scale = 0.25
    },
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "nested-result",
            action =
            {
              type = "area",
              target_entities = false,
              trigger_from_target = true,
              repeat_count = 64,
              radius = 32,
              action_delivery =
              {
                type = "projectile",
                projectile = "t-virus-wave",
                starting_speed = 0.2
              }
            }
          },
          {
            type = "create-entity",
            entity_name = "big-artillery-explosion"
          },
          {
            type = "show-explosion-on-chart",
            scale = 0.5
          }
        }
      }
    },
    final_action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "create-entity",
            show_in_tooltip = false,
            trigger_created_entity = true,
            trigger_fired_artillery = false, -- not working?
            entity_name = "virus-artillery-cloud"
          },
          {
            type = "create-entity",
            entity_name = "small-scorchmark",
            check_buildability = true
          },
        }
      }
    },
    animation =
    {
      filename = "__base__/graphics/entity/bullet/bullet.png",
      frame_count = 1,
      width = 3,
      height = 50,
      priority = "high"
    },
    height_from_ground = 280 / 64
  },
})
