local icons = "__GreenTec__/graphics/icons/";
local entities = "__GreenTec__/graphics/entities/";
local sounds = "__GreenTec__/sounds/";

data:extend({
  --
  {
    type = "projectile",
    name = "fertiliser-capsule",
    flags = { "not-on-map" },
    acceleration = 0.05,
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          type = "create-entity",
          show_in_tooltip = false,
          trigger_created_entity = true,
          entity_name = "fertiliser-cloud"
        }
      }
    },
    light = { intensity = 0.5, size = 8 },
    animation =
    {
      filename = icons.."fertiliser.png",
      frame_count = 1,
      width = 32,
      height = 32,
      priority = "high"
    },
  },
  --
  {
    type = "projectile",
    name = "advanced-fertiliser-capsule",
    flags = { "not-on-map" },
    acceleration = 0.05,
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          type = "create-entity",
          show_in_tooltip = false,
          trigger_created_entity = true,
          entity_name = "advanced-fertiliser-cloud"
        }
      }
    },
    light = { intensity = 0.5, size = 8 },
    animation =
    {
      filename = icons.."advanced-fertiliser.png",
      frame_count = 1,
      width = 32,
      height = 32,
      priority = "high"
    },
  },
  --
  {
    type = "smoke-with-trigger",
    name = "fertiliser-cloud",
    flags = { "not-on-map" },
    show_when_smoke_off = true,
    animation =
    {
      width = 152,
      height = 120,
      line_length = 5,
      frame_count = 60,
      axially_symmetrical = false,
      direction_count = 1,
      priority = "high",
      flags = { "smoke" },
      animation_speed = 0.5,
      scale = 8,
      filename = "__base__/graphics/entity/smoke/smoke.png"
    },
    affected_by_wind = true,
    cyclic = true,
    duration = 600,
    fade_away_duration = 60,
    spread_duration = 0,
    color = { r = 0.8, g = 0.8, b = 0.2, a = 0.4 },
    action_cooldown = 30
  },
  --
  {
    type = "smoke-with-trigger",
    name = "advanced-fertiliser-cloud",
    flags = { "not-on-map" },
    show_when_smoke_off = true,
    animation =
    {
      width = 152,
      height = 120,
      line_length = 5,
      frame_count = 60,
      axially_symmetrical = false,
      direction_count = 1,
      priority = "high",
      flags = { "smoke" },
      animation_speed = 0.5,
      scale = 8,
      filename = "__base__/graphics/entity/smoke/smoke.png"
    },
    affected_by_wind = true,
    cyclic = true,
    duration = 600,
    fade_away_duration = 60,
    spread_duration = 0,
    color = { r = 0.4, g = 1, b = 0.4, a = 0.4 },
    action_cooldown = 30
  },
})
